// WinBug11Doc.h : interface of the CWinBug11Doc class
//
/////////////////////////////////////////////////////////////////////////////

class CRegistersDlg;		// Forward Declaration
class CBreakList;		// Forward Declaration
class CMemoryDump;		// Forward Declaration

class CWinBug11Doc : public CRichEditDoc
{
protected: // create from serialization only
	CWinBug11Doc();
	DECLARE_DYNCREATE(CWinBug11Doc)

// Attributes
public:
	CStringArray straMemory;
	CStringArray straAsmFile;
	void AlignMemoryValues(UINT* puiStart, UINT* puiEnd);
	CMemoryDump* m_pMemDlg;
	CRegistersDlg* m_pRegDlg;
	CBreakList* m_pBreakList;
	BOOL bAsmViewCreated;
	CStatusBar* pStatus;
	UINT uiNumScroll;
private:
// Operations
public:
	void SetStatusMessage(UINT uiMessage);
	void SetStatusMessage(const char* pszMessage);
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWinBug11Doc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	//}}AFX_VIRTUAL
	virtual CRichEditCntrItem* CreateClientItem(REOBJECT* preo) const;

// Implementation
public:
	virtual ~CWinBug11Doc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CWinBug11Doc)
	afx_msg void OnProgramExecute();
	afx_msg void OnProgramStop();
	afx_msg void OnProgramCallSub();
	afx_msg void OnFileProps();
	afx_msg void OnMemoryFindByte();
	afx_msg void OnMemoryMoveMemory();
	afx_msg void OnFileVerify();
	afx_msg void OnMemoryRegisters();
	afx_msg void OnUpdateMemoryRegisters(CCmdUI* pCmdUI);
	afx_msg void OnMemoryBlockFill();
	afx_msg void OnMemorySetMemory();
	afx_msg void OnFileOpen();
	afx_msg void OnMemoryMemoryDisplay();
	afx_msg void OnMemoryClear();
	afx_msg void OnBreakpointList();
	afx_msg void OnUpdateBreakpointList(CCmdUI* pCmdUI);
	afx_msg void OnBreakpointClear();
	afx_msg void OnBreakpointSet();
	afx_msg void OnBreakpointClearAll();
	afx_msg void OnUpdateBreakpointClear(CCmdUI* pCmdUI);
	afx_msg void OnBreakpointTrace();
	afx_msg void OnBreakpointConttrace();
	afx_msg void OnUpdateMemoryMemoryDisplay(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
