// WinBug11View.cpp : implementation of the CWinBug11View class
//

#include "stdafx.h"
#include "WinBug11.h"

#include "WinBug11Doc.h"
#include "CntrItem.h"
#include "WinBug11View.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWinBug11View

IMPLEMENT_DYNCREATE(CWinBug11View, CRichEditView)

BEGIN_MESSAGE_MAP(CWinBug11View, CRichEditView)
	//{{AFX_MSG_MAP(CWinBug11View)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CRichEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CRichEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CRichEditView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinBug11View construction/destruction

CWinBug11View::CWinBug11View()
{
}

CWinBug11View::~CWinBug11View()
{
}

BOOL CWinBug11View::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CRichEditView::PreCreateWindow(cs);
}

void CWinBug11View::OnInitialUpdate()
{
	CRichEditView::OnInitialUpdate();
	GetParent()->SetWindowText("Memory View");
}

/////////////////////////////////////////////////////////////////////////////
// CWinBug11View printing

BOOL CWinBug11View::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}


/////////////////////////////////////////////////////////////////////////////
// CWinBug11View diagnostics

#ifdef _DEBUG
void CWinBug11View::AssertValid() const
{
	CRichEditView::AssertValid();
}

void CWinBug11View::Dump(CDumpContext& dc) const
{
	CRichEditView::Dump(dc);
}

CWinBug11Doc* CWinBug11View::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWinBug11Doc)));
	return (CWinBug11Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWinBug11View message handlers

int CWinBug11View::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	CHARFORMAT cf;
	cf.cbSize = sizeof(CHARFORMAT);
	cf.dwMask = CFM_FACE;
	::lstrcpy(cf.szFaceName, "Courier New");
	SetCharFormat(cf);
	m_nWordWrap = WrapNone;
	GetRichEditCtrl().SetReadOnly();
	if (CRichEditView::OnCreate(lpCreateStruct) == -1)
		return -1;
	return 0;
}

void CWinBug11View::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	CWinBug11Doc* pdoc = GetDocument();
	CString str;

	CHARFORMAT cf;
	cf.cbSize = sizeof(CHARFORMAT);
	cf.dwMask = CFM_FACE;
	::lstrcpy(cf.szFaceName, "Courier New");
	SetCharFormat(cf);
	m_nWordWrap = WrapNone;
	GetRichEditCtrl().SetReadOnly();

	// Loop through the string array, and build a master string

	for(int iCounter = 0; iCounter <= pdoc->straMemory.GetUpperBound(); iCounter++)
	{
		str += "   ";
		str += pdoc->straMemory[iCounter];
		str += '\n';
	}
	iCounter+=1;
	// Display the text in the window
	
	SetWindowText(str);
	TRACE("uiCounter = %d, uiNumScroll = %d\n", iCounter, pdoc->uiNumScroll);
	GetRichEditCtrl().LineScroll(iCounter - pdoc->uiNumScroll, 0);
}
