// WinBug11View.cpp : implementation of the CWinBugAsmView class
//

#include "stdafx.h"
#include "WinBug11.h"

#include "WinBug11Doc.h"
#include "CntrItem.h"
#include "WinBugAsmView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWinBugAsmView

IMPLEMENT_DYNCREATE(CWinBugAsmView, CRichEditView)

BEGIN_MESSAGE_MAP(CWinBugAsmView, CRichEditView)
	//{{AFX_MSG_MAP(CWinBugAsmView)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CRichEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CRichEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CRichEditView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinBugAsmView construction/destruction

CWinBugAsmView::CWinBugAsmView()
{
}

CWinBugAsmView::~CWinBugAsmView()
{
	GetDocument()->straAsmFile.RemoveAll();
	GetDocument()->bAsmViewCreated = FALSE;
}

BOOL CWinBugAsmView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CRichEditView::PreCreateWindow(cs);
}

void CWinBugAsmView::OnInitialUpdate()
{
	CRichEditView::OnInitialUpdate();
	GetParent()->SetWindowText("Assembly View");
}

/////////////////////////////////////////////////////////////////////////////
// CWinBugAsmView printing

BOOL CWinBugAsmView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}


/////////////////////////////////////////////////////////////////////////////
// CWinBugAsmView diagnostics

#ifdef _DEBUG
void CWinBugAsmView::AssertValid() const
{
	CRichEditView::AssertValid();
}

void CWinBugAsmView::Dump(CDumpContext& dc) const
{
	CRichEditView::Dump(dc);
}

CWinBug11Doc* CWinBugAsmView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWinBug11Doc)));
	return (CWinBug11Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWinBugAsmView message handlers

int CWinBugAsmView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	CHARFORMAT cf;
	cf.cbSize = sizeof(CHARFORMAT);
	cf.dwMask = CFM_FACE;
	::lstrcpy(cf.szFaceName, "Courier New");
	SetCharFormat(cf);
	m_nWordWrap = WrapNone;
	GetRichEditCtrl().SetReadOnly();
	if (CRichEditView::OnCreate(lpCreateStruct) == -1)
		return -1;
	return 0;
}

void CWinBugAsmView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	CWinBug11Doc* pdoc = GetDocument();
	CString str;

	CHARFORMAT cf;
	cf.cbSize = sizeof(CHARFORMAT);
	cf.dwMask = CFM_FACE;
	::lstrcpy(cf.szFaceName, "Courier New");
	SetCharFormat(cf);
	m_nWordWrap = WrapNone;
	GetRichEditCtrl().SetReadOnly();


	// Loop through the string array, and build a master string

	for(int iCounter = 0; iCounter <= pdoc->straAsmFile.GetUpperBound(); iCounter++)
	{
		str += "   ";
		str += pdoc->straAsmFile[iCounter];
		str += '\n';
	}

	// Display the text in the window
	
	SetWindowText(str);
}

void CWinBugAsmView::OnDestroy() 
{
	GetDocument()->bAsmViewCreated = FALSE;
	CRichEditView::OnDestroy();
	
	// TODO: Add your message handler code here
	
}
