*talke.asm
*************************** TALKSCI.ASC 14/8/91 **************************
*   Motorola Copyright 1988,1991                                         *
*   MCU resident, Interrupt driven Communication routines for 68HC11     *
*   monitor. Provides low level memory and stack read/write operations.  *
*                                                                        *
*   This talker DOES NOT use XIRQ                                        *
*   -----------------------------                                        *
*                                                                        *
* N.B. TALKSCI.ASC is a general purpose talker. It is intended to be     *
*      placed in the MCU memory map at $6000 but this can be changed by  *
*      the user to any suitable address. The talker is for general debug *
*      and can be used in any mode as long as the vectors are correctly  *
*      initialised. It is therefore useful for normal modes. The SCI is  *
*      used for communications - use TALKACIA when an external ACIA is   *
*      to be used. TALKSCI assumes that the interrupt vectors are        *
*      pointing to RAM in the same way as the boostrap ROM.              *
*      IMPORTANT : If you change the running address of this program     *
*      then you MUST also change the TALKSCI.MAP file so that the two    *
*      match.                                                            *
*                                                                        *
*      When PCBUG11 is executed with option TALKSCI, a 10mS break is     *
*      output to the 68HC11's SCI, prior to establishing communication.  *
*
* CONSTANTS
*TALKBASE  equ $6000
TALKBASE  equ $0000
STACK     equ $01FF       User may alter this parameter if required
BOOTVECT  equ $00C4       Start of bootstrap vector jump table.
REGBASE   equ $1000       Change if registers are moved
*
JSCI      equ $00C4
JXIRQ     equ $00F1
JSWI      equ $00F4
JILLOP    equ $00F7
JCOP      equ $00FA
JMPEXT    equ $7E         Mnemonic for jump extended instruction
BRKCODE   equ $4A         Break point signal code to host.
BRKACK    equ $4A         Break point acknowledge code from host.
*
* REGISTERS               Change if required for MCU
BAUD      equ $2B
SCCR1     equ $2C
SCCR2     equ $2D
SCSR      equ $2E
SCDR      equ $2F
*
RDRF      equ $20         SCI Masks, change if required
TDRE      equ $80
OR        equ $08
FE        equ $02
*
* PROGRAM
          org TALKBASE
*
* Initialise the SCI and interrupts
*
TLKRSTART  EQU *         First dynamically set up Boot vector jump table.
*          LDAA #JMPEXT
*          LDY #NULLSRV
*          LDX #BOOTVECT
*SETVECT   EQU *
*          STAA ,X
*          INX
*          STY ,X
*          INX
*          INX
*          CPX #$100
*          BNE SETVECT
*          LDX #SCISRV
*          STX JSCI+1
*          LDX #TLKRSTART
*          STX JILLOP+1
**
USERSTART EQU *
          LDS #STACK
          LDX #REGBASE
          CLR SCCR1,X
          LDD #$302C
          STAA BAUD,X   Initialise SCI to 9600 baud, no parity, no interrupt
          STAB SCCR2,X  and enable SCI tx & rx.
          LDAA #$40     Enable STOP, and I bit interrupts, disable XIRQ.
          TAP
*
* User may add jump to his own code here or may move the above
* initialisation to the start of his own program. 
* IDLE is the infinite loop which allows the 'STOPPED' mode of PCbug11
*
IDLE      JMP IDLE      Now hang around for SCI interrupt from host.
*
* A RESET from host changes above jump destination to start of user code.
*
SCISRV    EQU *             On detecting interrupt,
          LDAA SCSR+REGBASE assume receiver caused it.
          ANDA #RDRF
          BEQ SCISRV        otherwise program will hang up
*
RXSRV     EQU *             Talker code processes received data.
          LDAA SCDR+REGBASE Read command byte, & echo it as acknowledge
          COMA              Inverted
          BSR OUTSCI        to host.
          BPL INH1      If command bit 7 set, then process inherent command
          BSR INSCI     else read byte count from host into ACCB.(0=256)
          XGDX          Save command and byte count.
          BSR INSCI     Read high address byte
          TBA           into ACCA
          BSR INSCI     then low address byte into ACCB
          XGDX          Restore command in ACCA,count in ACCB,address in X
          CMPA #$FE
          BNE RXSRV1    If command is memory read, then
*
TREADMEM  EQU *         REPEAT
          LDAA ,X             read required address
          BSR OUTSCI          send it to host
          TBA                 (save byte count)
          BSR INSCI           and wait for acknowledge
          TAB                 (restore byte count)
          INX                 Increment address
          DECB                Decrement byte count
          BNE TREADMEM  UNTIL all done
          RTI           and return to idle loop or user code.
*
RXSRV1    EQU *
          CMPA #$BE
          BNE RXSRVEX    If command is memory write then
*
          TBA           move byte count to ACCA
TWRITMEM  EQU *         REPEAT
          BSR INSCI           Read next byte from host into ACCB,
          STAB ,X             and store at required address.
          LDY #$0001          Set up wait loop to allow for external EEPROM
WAITPOLL  DEY                 Y may take on suitable value
          BNE WAITPOLL
          LDAB ,X             Read stored byte and
          STAB SCDR+REGBASE   echo it back to host,
          INX
          DECA                Decrement byte count
          BNE TWRITMEM  UNTIL all done
RXSRVEX   EQU *         and return
NULLSRV   RTI
*
* INSCI gets the received byte form the SCI
*
INSCI     EQU *
          LDAB SCSR+REGBASE   Wait for RDRF=1
          BITB #(FE+OR)       If break detected then
          BNE TLKRSTART       restart talker.
          ANDB #RDRF
          BEQ INSCI
          LDAB SCDR+REGBASE   then read data received from host
          RTS                 and return with data in ACCB
*
* OUTSCI is the subroutine which transmits a byte from the SCI
*
OUTSCI    EQU *               Only register Y modified.
          XGDY                Enter with data to send in ACCA.
OUTSCI1   LDAA SCSR+REGBASE
          BPL OUTSCI1         MS bit is TDRE flag
          XGDY
          STAA SCDR+REGBASE   Important - Updates CCR!
          RTS
*
* Now decide which inherent command was sent
*
INH1      EQU *
          CMPA #$7E     If command is read MCU registers then
          BNE INH2
*
* Command was to read MCU registers
*
INH1A     TSX           Move stack pointer to X
          XGDX          then to ACCD
          BSR OUTSCI    send stack pointer to host (high byte first)
          TBA
          BSR OUTSCI    then low byte
          TSX           Restore X (=stack pointer)
          LDAB #9       then return 9 bytes on stack
          BRA TREADMEM  i.e. CCR,ACCB,ACCA,IXH,IXL,IYH,IYL,PCH,PCL
*
* Command was to write MCU registers
*
INH2      EQU *
          CMPA #$3E     If command is write MCU registers then
          BNE SWISRV1
*
          BSR INSCI     get stack pointer from host (High byte first)
          TBA
          BSR INSCI     get low byte next
          XGDX          Move to X reg
          TXS           and copy to stack pointer
          LDAA #9       Then put next 9 bytes from host on to stack
          BRA TWRITMEM
*
* An SWI interrupt was generated
*
SWISRV    EQU *         Breakpoints generated by host-placed SWI instruction.
          LDAA #BRKCODE Force host to process breakpoints
          BSR OUTSCI    by sending it the break signal
SWIIDLE   CLI
          BRA SWIIDLE   then wait for response from host. (Ibit=0,Xbit=1)
*
SWISRV1   EQU *
          CMPA #BRKACK  If host has acknowledged breakpoint state then
          BNE RXSRVEX
          TSX           move stack pointer to SWI stack frame and
          LDAB #9
          ABX
          TXS
          LDD 7,X       Send user code breakpoint return address to host
          BSR OUTSCI    (high byte first)
          TBA
          BSR OUTSCI    (low byte next)
          LDD #SWIIDLE  force idle loop on return from breakpoint processing
          STD 7,X
          BRA INH1A     but first return all MCU registers to host
*
          ORG BOOTVECT
          JMP SCISRV    SCI
          JMP NULLSRV   SPI
          JMP NULLSRV   Pulse accumulator input edge
          JMP NULLSRV   Pulse accumulator overflow
          JMP NULLSRV   Timer overflow
          JMP NULLSRV   Timer output compare 5
          JMP NULLSRV   Timer output compare 4
          JMP NULLSRV   Timer output compare 3
          JMP NULLSRV   Timer output compare 2
          JMP NULLSRV   Timer output compare 1
          JMP NULLSRV   Timer input capture 3
          JMP NULLSRV   Timer input capture 2
          JMP NULLSRV   Timer input capture 1
          JMP NULLSRV   Real time interrupt
          JMP NULLSRV   /IRQ
          JMP NULLSRV   /XIRQ
          JMP SWISRV    SWI
          JMP USERSTART Illegal opcode
          JMP NULLSRV   COP Fail
          JMP NULLSRV   Clock monitor fail
*
          END
