
/* C include file -- zserial.c
 *
 *  Compiled using Small C
 *
 *  V 1.0 (02/20/95) - Good working version, allows change of baud rate by program
 *
*/


/* NOTE: YOU MUST DEFINE THIS GLOBAL IN YOUR PROGRAM!
 * it is two bytes (16 bits) and I have no idea where
 * you are putting your globals, so you keep track of where to
 * stick this global!
 * you need to do something like this:
 *
 *   #define rcvchar   *0x0006
 *
 *
*/


/*-------------- SERIAL DRIVER AREA -----------------*/

/* serset(baud) - Sets up the serial port
   baud is the rate, see below
*****************************************/

serset(baud)
int baud;
{
pokeb(BAUD,baud); /* set up serial port, baud rate 0x33=1200 0x32=2400 0x30=9600 (8Mhz) */
pokeb(SCCR1,0x00); /* data bits 8, one stop */
pokeb(SCCR2,0x0C); /* enable the TX and RX */
}

/* sercout(what) - Sends a character to the serial port
   what is the data
*****************************************/
sercout(what)
int what;
{
while(!(peekb(SCSR) & 0x80)) {} /* wait for trans data to clear out */
pokeb(SCDR,what); /* send the data out */
}

/* serprint("whatever") - Prints to the serial port
   no fancy stuff here yet
*****************************************/

serprint(s)
char *s;
{
	while (*s) {
		*s = *s & 0xFF; /* make sure everything is byte wide */
		if (*s == ']') {
			sercout(0x0D); /* do a CR line feed for terminal */
			sercout(0x0A);
			}
		else {sercout(*s);} /* output the character */
		s++;
	}
}

/* getser() - gets a character from serial port
*****************************************/

getser()
{
if (!(peekb(SCSR) & 0x20)) return(0); /* is something there? */
rcvchar = peekb(SCDR) & 0x00FF; /* return the data, in a global variable */
return(1); /* report we have something */
}


/* serhex(int) - Prints to serial
   a hex number
*****************************************/

serhex(num)
int num;
{
int temp;
temp=(num >> 12) & 0x000F; /* get upper digit */
if (temp < 0x0A) sercout(temp + 0x30);
if (temp > 0x09) sercout(temp + 0x37); /* 41 - 0A = 37 */
temp=(num >> 8) & 0x000F; /* get digit */
if (temp < 0x0A) sercout(temp + 0x30);
if (temp > 0x09) sercout(temp + 0x37); /* 41 - 0A = 37 */
temp=(num >> 4) & 0x000F; /* get digit */
if (temp < 0x0A) sercout(temp + 0x30);
if (temp > 0x09) sercout(temp + 0x37); /* 41 - 0A = 37 */
temp=num & 0x000F; /* get digit */
if (temp < 0x0A) sercout(temp + 0x30);
if (temp > 0x09) sercout(temp + 0x37); /* 41 - 0A = 37 */
}


/* serdec(dig,num) - Prints a decimal number
dig = number of digits to print, num = number
*****************************************/

serdec(dig,num)
int dig, num;
{
char s[20];
int i, n, n1;

n = num; /* put it local for more speed */

	for (i = 0; i < dig; i++) { /* do dig digits */
		n1 = 0;
		while (n >= 10) { /* devide by 10, the hard way, num is remainder */
			n = n - 10;
			n1++;
			}
		s[i] = n + '0'; /* the remainder is the digit */
		n = n1;
		}
	i= dig - 1;
	while (i >= 0) {
		s[i] = s[i] & 0xFF; /* make sure everything is byte wide */
		sercout(s[i]); /* output the character */
		i--;
	}
}


/*-------------- END SERIAL DRIVER AREA -----------------*/


