/*
 *
 *  U-HC11 Monitor ROM Program
 *
 *  COPYRIGHT NOTICE: Public Domain, do what you want with it
 *
 *  Compiled using Small C, set for transfer to a EPROM for the
 *  RAM/EEPROM Expansion Board.
 *
 *  Version 1.0 (02/20/95) - First Version!
 *  Version 1.1 (04/21/96) - Timeout delay extended & unlocks EEPROM on 'E9
 *
*/

/* we use a 32K EPROM, this sets up for "zend.h" file */
#define ROM32K

/* define these global variables for use by the LCD driver file */
/* character counter for display */
#define chcnt     *0x0002
/* sets extra bits not used in the display port */
#define disbuf    *0x0004

/* input buffer for serial ports */
#define rcvchar   *0x0006

/* you only include the files you need for your particular application */
#include "z68hc11.h"
#include "zUHCrun.h"
#include "zadc.c"
#include "zLCD1.c"
#include "zserial.c"
#include "zdelay.c"
#include "zintEEP.c"

/* globals for use by this program */
#define timeout    *0x0022
#define timeoutf   *0x0024

/* this variable is used for the "go" function, a machine language call */
#define goloc      *0x0026
#asm
GOLOC EQU $0026
#endasm

/* internal EEPROM bytes used by monitor for settings */

#define moder      *0xB7FC
#define modew       0xB7FC
#define offsetr    *0xB7FE
#define offsetw     0xB7FE

/* values used by this program */
/* timeout time for the serial receive of data */
#define timeoutx 1000

/* locations of stuff */

#define modeport   0x1E00


portset()
{
pokeb(PORTA,0x00);  /* set all bits */
}

main()
{
int x;
pokeb(BPROT,0x00);  /* enable EEPROM and CONFIG writes on a 'E9 */
portset(); /* set up all the ports */
serset(0x30);  /* set up serial port, baud rate 0x33=1200 0x32=2400 0x30=9600 */

setmode(moder); /* sets the mode on the expansion board from EEPROM byte */

while(1)
 {
serprint("]]] U-HC11 Monitor V1.1]]");
serprint("Offset: ");
serhex(offsetr);
serprint("  Exp Mode: ");
serhex(moder);
serprint("]]");
serprint("D0000 - Display memory byte]");
serprint("E0000 - Write byte to internal EEPROM (B600 - B7FF area)]");
serprint("G0000 - Go run user program]");
serprint("L0000 - List memory (any key to stop)]");
serprint("M     - set the expansion Mode register]");
serprint("O     - set the Offset for loading 'S' records]");
serprint("R     - Receive 'S' records]");
serprint("W0000 - Write byte to memory]");
serprint("Z     - Zap (write) the expansion RAM to EEPROM]");
serprint("]Select: ");

while(!getser()) {  }
sercout(rcvchar);

switch (rcvchar) {
	case 'G':
	case 'g':
		go();
		break;
	case 'D':
	case 'd':
		display();
		break;
	case 'E':
	case 'e':
		eeprom();
		break;
	case 'L':
	case 'l':
		list();
		break;
	case 'M':
	case 'm':
		gomode();
		break;
	case 'O':
	case 'o':
		gooffset();
		break;
	case 'R':
	case 'r':
		s19rcv();
		break;
	case 'W':
	case 'w':
		write();
		break;
	case 'Z':
	case 'z':
		zap();
		break;
	default: 
		serprint("]]  What????]]");
		break;
	}
 } /* close the main "while" */
}

zap(){
int x, start, bank, c, d, i, z, stop, time1;

serprint("]This will write the ENTIRE External RAM to EEPROM.");
serprint("]] Write to]  1- 2864 ]  2- 28256]  Enter Choice: ");
while(!getser()) {  }
if (rcvchar == '1') {
	start = 0x6000; /* starting location (2864 is always at 6000) */
	bank = 1; /* how many banks to go to */
	serprint("]2864 Selected]");
	}
else	{
	start = 0x4000;
	bank = 2;
	serprint("]28256 Selected]");
	}
serprint("]]Are you sure (Y/N)? ");
while(!getser()) {  }
if (rcvchar != 'Y' && rcvchar != 'y') {
	serprint("]CANCELED]");
	return;
	}
serprint("]] Writing to EEPROM, please wait (press any key to stop)...]");
z = 0; stop = 0;
for (c = 0; c < bank; c++) { /* switches the banks */
	serprint("]Bank ");
	if (c) serprint("1  ");
	else serprint("0  ");
	for (i = start; i != 0x8000; i++) {
		if (z++ == 0x10) { /* do a readout every 16 bytes */
			serhex(i);
			sercout(0x08); sercout(0x08);
			sercout(0x08); sercout(0x08);
			z = 0;
			if(getser()) { /* check for key press */
				stop = 1;
				break;
				}
			}
		setmode(c); /* select the RAM bank */
		x=peekb(i); /* read from RAM */
		setmode((c + 2)); /* select the EEPROM bank */
		if (peekb(i) != x) { /* see if it's already programed */
			pokeb(i,x); /* write to EEPROM */
			}
		delay(1);  /* delay just a bit */	
		time1 = 0;
		while ((d = peekb(i)) != x) { /* only wait for a while */
			if(time1++ > 100) break;
			delay(1);
			}
		if (d != x) {
			serprint("]]ERROR AT LOCATION ");
			serhex(i);
			serprint(", wrote a ");
			serhex(x);
			serprint(", got a ");
			serhex(d);
			serprint("]       ");
			}
		}
	if (stop) break;
	}
serprint("]]DONE...]");
}

gooffset(){
int x, a;

serprint("]] Enter a 16 bit Number:");
x = gettwo(); /* get the data */
a = gettwo();
eeprog(offsetw,x); /* write out 16 bits*/
eeprog(offsetw+1,a);
serprint("]");
}

gomode(){
int x;

serprint("]] Enter a 8 bit Number:");
x = gettwo(); /* get the data */
eeprog(modew,0); /* write out 16 bits, it's easier */
eeprog(modew+1,x);
setmode(x);
serprint("]");
}


setmode(modex)
int modex;
{
int i,x;
x = modex;

for (i = 0; i < 3; i++) { /* shift the bits into the modeport register */
	if (x & 0x04) pokeb(modeport+1,0); /* shift in a 1 */
	else pokeb(modeport,0); /* shift in a 0 */
	x = x << 1; /* rotate it over */
	}
}

gettwo(){
int temph, templ, low;

timeout = timeoutf = 0;

while(!getser() && !timeoutc()) {} if (timeoutf) return(0); timeout = 0;
sercout(rcvchar);
temph = rcvchar; /* get the address to list from */
while(!getser() && !timeoutc()) {} if (timeoutf) return(0); timeout = 0;
sercout(rcvchar);
templ = rcvchar;
low = convhex(temph,templ); /* convert it to a byte */
return(low);
}

getfour(){
int x, high, low;

high = gettwo(); /* convert it to a byte */
if (timeoutf) return(0);
low = gettwo(); /* convert it to a byte */
if (timeoutf) return(0);
x = low + (high << 8); /* put it all together */
return(x);
}

go(){

goloc = getfour(); /* get the address */
if (timeoutf) return;
serprint("]]");
/* here's where we make a call to the user's routine, goloc is the addr */
#asm
	LDX GOLOC
	JSR 0,X
#endasm
/* we should return here if everything went well */

}


display(){
int x, a;

a = getfour(); /* get the address */
serprint("]]");
serhex(a);
serprint(" - ");
x = peekb(a);
serhex(x);
serprint("  (byte wide)]");
}

write(){
int x, a;

a = getfour(); /* get the address */
serprint("]] Enter a Byte:");
x = gettwo(); /* get the data */
pokeb(a,x);
serprint("]");
serhex(x);
serprint(" written to ");
serhex(a);
serprint("   (byte wide)]");
}

eeprom(){
int x, a;

a = getfour(); /* get the address */
serprint("]] Enter a Byte:");
x = gettwo(); /* get the data */
eeprog(a,x);
serprint("]");
serhex(x);
serprint(" written to INTERNAL EEPROM ");
serhex(a);
serprint("   (byte wide)]");
}


list(){
int i, x, a, addr;

addr = getfour(); /* get the address */
serprint("]]");
while(!getser()) {
	serhex(addr);
	serprint(" - ");
	a = addr;
	for (i = 0; i < 8; i++) {
		x = peekb((a + 1)) + (peekb(a) << 8);
		serhex(x);
		serprint(" ");
		a = a + 2;
		}
	a = addr;
	for (i = 0; i < 8; i++) {
		x = peekb(a) & 0x7F;
		if (x < ' ' || x > '~') x = '.';
		sercout(x);
		a++;
		x = peekb(a) & 0x7F;
		if (x < ' ' || x > '~') x = '.';
		sercout(x);
		a++;
		}
	serprint("]");
	addr = addr + 16;
	}
}


s19rcv(){
int x, i, checksum, reclength, temph, templ;
int tempbyte, address, check, bank1, bank2, mode1, dobank;
serprint("]]Ready to receive S Records:]");

address = 0;
timeout = timeoutf = 0;
bank2 = 0xFFFF; /* bank2 is the value of the last bank switch, inverted */
mode1 = moder; /* read the current bank mode setting */

dobank = 0; /* see if we want to do bank switching, use special mode setting */
if ((mode1 & 0x80)) dobank = 1;

while(1) /* this is the main loop for the whole file download */
 {
while(1){
	while(!getser() && !timeoutc()) {} if (timeoutf) break; timeout = 0;
	if (rcvchar != 'S') continue; /* find the beginning of a line */
	while(!getser() && !timeoutc()) {} if (timeoutf) break; timeout = 0;
	if (rcvchar != '1' && rcvchar != '9') continue; /* we now have "S1" or "S9" */
	break;
	}
if (timeoutf) break; /* if we have a timeout */
if (rcvchar == '9') break; /* we now have "S9", stop */
while(!getser() && !timeoutc()) {} if (timeoutf) break; timeout = 0;
temph = rcvchar; /* pick up the record length pair of characters */
while(!getser() && !timeoutc()) {} if (timeoutf) break; timeout = 0;
templ = rcvchar; /* pick up the record length pair of characters */
reclength = convhex(temph,templ); /* convert it to a byte */
checksum = reclength; /* start the checksum */
for (i = 0; i < (reclength - 1); i++) { /* pick up all the rest of the bytes */
	while(!getser() && !timeoutc()) {} if (timeoutf) break; timeout = 0; /* get two characters */
	temph = rcvchar;
	while(!getser() && !timeoutc()) {} if (timeoutf) break; timeout = 0;
	templ = rcvchar;
	tempbyte = convhex(temph,templ);
	checksum = checksum + tempbyte; /* add in for the checksum */
	if (i == 0) {
		address = (tempbyte << 8) & 0xFF00; /* the first two bytes are the address */
		continue;
		}
	if (i == 1) {
		address = address + tempbyte;
		address = address - offsetr; /* subtract the offset if needed */
		continue;
		}
	/* it only gets here if the address is all in */
	if (dobank) { /* see if we are going to do bank switching */
		bank1 = (address & 0x4000) ^ 0xFFFF; /* get bit and flip it */
		if (bank2 != bank1) { /* see if we have a address bit change */
			bank2 = bank1; /* set it to ignore till next change */
			if ((bank1 & 0x4000)) setmode(mode1); /* put it to normal */
			else setmode((mode1) + 1); /* increment it by one, next bank */
			}
		pokeb((address & bank1),tempbyte); /* write the data out, fix the address for bank sw */
		}
	else pokeb(address,tempbyte); /* write the data out, no bank sw */
	address++;
	}
if (timeoutf) break; /* if we have a timeout */
while(!getser() && !timeoutc()) {} if (timeoutf) break; timeout = 0; /* get two checksum characters */
temph = rcvchar;
while(!getser() && !timeoutc()) {} if (timeoutf) break; timeout = 0;
templ = rcvchar;
check = convhex(temph,templ);
checksum = (checksum ^ 0x00FF) & 0x00FF; /* make our checksum like what comes in */
if (check != checksum) {
	serprint("]]ERROR IN RECEIVED FILE!!]");
	return;
	}
 } /* close the main "while" */
if (timeoutf) {
	serprint("]]TIMEOUT WHILE RECEIVING FILE!!]");
	return;
	}
delay(2000); /* wait as the rest is skipped over */
serprint("]]S Record receive complete, no errors...]");
getser(); /* clear any left over characters */
}

timeoutc(){
if(peekb(TFLG2) & 0x80) { /* count timer overflows */
	pokeb(TFLG2,0x80); /* reset the main timer overflow */
	if(timeout > timeoutx){
		timeoutf = 1;
		return (1); /* show a timeout */
		}
	else	{
		timeout = timeout + 1;
		}
	}
return(0);
}

convhex(temph,templ) /* take two characters and make a number out of it */
int temph, templ;    /* will accept lowercase letters for A - F */
{
int result;

result = 0;

if (templ > '9') { /* should now be A - F or a - f */
	if (templ < 'A') return (0); /* check for out of bounds characters */
	if (templ > 'F') { /* check for out of bounds characters */
		if (templ < 'a') return (0); /* check for lowercase */
		if (templ > 'f') return (0);
		result = (templ - 'a') + 10; /* "a" would be 10, "f" would be 15 */
		}
	else result = (templ - 'A') + 10; /* "A" would be 10, "F" would be 15 */
	}
else if (templ >= '0') { /* should now be 0 - 9 */
	result = templ - '0';
	}
else return(0);

if (temph > '9') { /* should now be A - F */
	if (temph < 'A') return (0); /* check for out of bounds characters */
	if (temph > 'F') { /* check for out of bounds characters */
		if (temph < 'a') return (0); /* check for lowercase */
		if (temph > 'f') return (0);
		result = result + (((temph - 'a') + 10) << 4); /* "a" would be 10, "f" would be 15 */
		}
	else result = result + (((temph - 'A') + 10) << 4); /* "A" would be 10, "F" would be 15 */
	}
else if (temph >= '0') { /* should now be 0 - 9 */
	result = result + ((temph - '0') << 4);
	}
else return(0);

} /* if there is a error in conversion, 00 is the default result */




/* include this at the end of your program */

#include "zend.h"

