/*
 *
 *  U-HC11 TEST SERVO Program
 *
 *  COPYRIGHT NOTICE: Public Domain, have fun
 *
 *  Compiled using Small C, set for transfer to RAM for the
 *  RAM/EEPROM Expansion Board.
 *
 *  Version 1.0 (02/20/95) - First Version!
 *
 *  This program simply reads the adc bit 7 and makes bit 7 & 6 of port A
 *  move two servo motors.
 *
 *  This was downloaded and run through the monitor program
 *  at 9600 directly to the board.
 *
*/

/* put this in when you are downloading to RAM */
ramjump()
{
#asm
	clra
	clrb
	jmp	_main
#endasm
}

/* input buffer for serial ports */
#define rcvchar   *0x0006

/* you only include the files you need for your particular application */
#include "z68hc11.h"
#include "zUHCrun.h"
#include "zserial.c"
#include "zadc.c"
#include "zdelay.c"

/* globals for use by this program */

 /* for use by the pwm routine, image of the port
  * NOTE: You need to change the pwm routine "EQU"'s to match what is here!
  *       And you must define how many bits you are going to use via "EQU"
 */
#define pwmbits  0x0038
 /* for use by the pwm routine, storage of the pwm time values
  * note that this takes up 6 more bytes! you have 1 byte
  * for each output bit, bit 7 is the first value
 */
#define pwm0     0x0030


/* values used by this program */


portset()
{
pokeb(PACTL,0x80);  /* set bit 7 as a output on PORTA */
}


main()
{
int a, a1, x, i;
portset(); /* set the ports */
adset(); /* set up to use the ad converter */
delay(300);

  /* you must define the starting condition of the pwm port */
pokeb(PORTA,0xFF); /* set the port accordingly */
pokeb(pwmbits,0xFF);

serprint("]]]here we are!!]]");
x=0;
while(1)
 {
if(x++ > 5) { /* we only do this every 5 loops */
	a=getad(7); /* get the number to use 0 - FF */
	pokeb(pwm0,a); /* put it into memory at this bits location */
	a1 = (a ^ 0xFF) & 0x00FF; /* make this motor go the other way, invert */
	pokeb(pwm0+1,a1); /* put it into memory at this bits location */
	serhex(a); /* show what the number is */
	serprint(".");	
	x=0;
	}
pwm();
if (peekb(SCSR) & 0x20) break; /* this will stop if a key is pressed, serial port */
 }	
x = peekb(SCDR); /* clear out the serial character */
}

/* pwm() - Runs up to 8 servo motors on any output port or latch
 *
 * sorry, but this must be done in assembly language because we are
 * talking about micro seconds here.
 * you should come back to this loop at least every second or so, most
 * servos will hold their position forever, but who knows....
 * DON'T COME RIGHT BACK! Give at least 4 MS till you call this again!
 * if you don't there won't be much of a LOW time for the bits.
 *
 * You must set up the memory locations for storage of the setting
 * values, and match them with the "EQU"'s in the "asm" portion of
 * this routine.
 * You need to tell this routine how many bits you are using, the other
 * bits are not touched, you need to keep track of the unused bits
 * in the variable "pwmbits", then this routine uses that to set
 * the bits it uses and leave the others the way you define them.
 *
 * something like this :
 *
 * #define pwm0       0x0030
 * #define pwmbits    0x0038
 *
*/


pwm(){


#asm

* You tell us how many bits to use, starting with bit 7 first
BITNUM	EQU	2
* You define which port to use here
PWMPORT	EQU	$1000
* You define where the start of the values is at
PWM0	EQU	$30
* You show where the port's bit immage is stuck
PWMBITS	EQU	$38
* used in this routine only, counter of delay loops
PWMCNT	EQU	$39
* used in this routine only, mask for setting the bits
PWMMASK	EQU	$3A

	ldaa	#$80	* mask starts at bit 7
	staa	PWMMASK	* we do each bit's delay seperate because we don't 
*			  have enough time, so the more bits you have
*			  the longer this will all take

	ldy	#0	* y is our index to the memory locations
*			  first we set the bit HIGH

pwmlpx:	ldaa	PWMBITS	* here's what the port is now
	oraa	PWMMASK	* make that bit HIGH
	staa	PWMBITS	* record it for next time around
	staa	PWMPORT	* put it out to the port

	ldaa	#0	* now we do a delay till a number is found that
	staa	PWMCNT	* matches a bit's setting number, and set that bit low
*			  PWMCNT is the number of delay cycles we have done

pwmlp2:	ldaa	PWMCNT	* see if it's at what number we want for this bit
	cmpa	PWM0,Y
	beq	pwmout
	inc	PWMCNT	* keep doing the delay, this loop is just right!
	bra	pwmlp2

pwmout:	ldaa	PWMMASK	* it is so make this bit LOW, here's what the port is now
	eora	#$FF	* flip the bits for a AND mask
	anda	PWMBITS	* make that bit low
	staa	PWMBITS	* record it for next time around
	staa	PWMPORT	* put it out to the port
	clc
	ror	PWMMASK	* rotate the mask to the next bit
	iny
	cpy	#BITNUM * are we done with all the bits?
	bne	pwmlpx

#endasm

}

