/*
 *
 *  U-HC11 TEST SERVO ROBOT Program
 *
 *  COPYRIGHT NOTICE: Public Domain, have fun!
 *
 *  Compiled using Small C, set for transfer to RAM for the
 *  RAM/EEPROM Expansion Board.
 *
 *  Version 1.0 (02/20/95) - First Version!
 *
 *  This program moves the two servos in a "robot" fasion, one is
 *  mounted on top of the other to give a "X Y" movement, to pick
 *  metal balls with a electro magnet, driven by PORTA 5, through transistor.
 *  
 *
 *  This was downloaded and run through the monitor program
 *  at 9600 directly to the board.
 *
*/

/* put this in when you are downloading to RAM */
ramjump()
{
#asm
	clra
	clrb
	jmp	_main
#endasm
}

/* input buffer for serial ports */
#define rcvchar   *0x0006

/* you only include the files you need for your particular application */
#include "z68hc11.h"
#include "zUHCrun.h"
#include "zserial.c"
#include "zadc.c"
#include "zdelay.c"

/* globals for use by this program */

 /* for use by the pwm routine, image of the port
  * NOTE: You need to change the pwm routine "EQU"'s to match what is here!
  *       And you must define how many bits you are going to use via "EQU"
 */
#define pwmbits  0x0038
 /* for use by the pwm routine, storage of the pwm time values
  * note that this takes up 6 more bytes! you have 1 byte
  * for each output bit, bit 7 is the first value
 */
#define pwm0     0x0030

#define moves    *0x0040


/* values used by this program */



portset()
{
pokeb(PACTL,0x80);  /* set bit 7 as a output on PORTA */
}

#define rate	20


main()
{
int a, a1, x, i, move, where, now, temp, last;

portset(); /* set the ports */
adset(); /* set up to use the ad converter */
moveset();
delay(300);

  /* you must define the starting condition of the pwm port */
pokeb(PORTA,0x00); /* set the port accordingly */
pokeb(pwmbits,0x00);

last = 0; /* the last time what the setting of the ports was */

serprint("]]Reseting motors]");
pokeb(pwm0,0x80); /* move the motors to center for start */
pokeb(pwm0+1,0x80);
for (i = 0; i < 40; i++) {
	pwm();
	delay(50);
	}


serprint("]]]here we go!!]]");
x=0;
while(1)
 {
/* do the "X" position */
move = peekb((moves + x));
if(move == 0) { /* are we at end? do it again */
	x=0;
	continue;
	}
where = peekb(pwm0); /* mark where we are now */
now = where;
while(1) { /* we are going to move there at a certian rate, not all at once */
	if (where == move) break; /* we are already there */
	if (where < move) { now++; } /* are we going backwards? */
	else now--;
	pokeb(pwm0,now);
	pwm();	/* do the move */
	if (now == move) break; /* we are there */
	delay(rate); /* this sets the rate of movement */
	}
x++; /* go to next move byte */

serhex(move);  serprint(",");	

/* do the "Y" position */
move = peekb((moves + x)); /* get the move to do */
where = peekb((pwm0+1)); /* mark where we are now */
now = where;
while(1) { /* we are going to move there at a certian rate, not all at once */
	if (where == move) break; /* we are already there */
	if (where < move) { now++; } /* are we going backwards? */
	else now--;
	pokeb(pwm0+1,now);
	pwm();	/* do the move */
	if (now == move) break; /* we are there */
	delay(rate); /* this sets the rate of movement */
	}
x++; /* go to next move byte */

serhex(move);  serprint(",");

/* now set the port bits accordingly */
move = peekb((moves + x)); /* get the port bits setting */
if(last != move) { /* is the condition the same? */
	pokeb(pwmbits,move);
	pwm();	/* set the port and send out more pulses */
	delay(300); /* let magnet pick up object */
	last = move;
	}
x++; /* go to next move byte */

serhex(move);  serprint("]");

if (peekb(SCSR) & 0x20) break; /* this will stop if a key is pressed, serial port */
 }	
x = peekb(SCDR); /* clear out the serial character */
}


/* this is how we get our move data table into ROM, with this compiler
 * this is the best way I could figure out, just change the "FCB" numbers
 * for each move you do. You need to define the variable "moves" to access
 * the value from C. You call this once at the start to set up "moves".
*/

moveset(){
#asm
* This is a two byte location for storing the location of the start of our data table
MOVES	EQU	$40

	ldd 	#*	* load the current address pointer into d
	Addd	#9	* point to the bytes after the rts
	std	MOVES	* put it where we can use it from C
	rts

* the moves are X,Y,bits  (bits are the extra port pins)
* NEVER USE ZERO (0) as first byte, it means end of moves
*
	FCB	175,082,$00	* move to right, down
	FCB	175,082,$20	* stay, mag on
	FCB	175,100,$20	* pull up a little
	FCB	160,128,$20	* move left, pull all the way up
	FCB	090,128,$20	* move left
	FCB	090,110,$20	* down a bit
	FCB	090,110,$00	* mag off
	FCB	090,128,$00	* arm up
	FCB	120,128,$00	* center
	FCB	00,00,00	* the end
	

#endasm
}


/* pwm() - Runs up to 8 servo motors on any output port or latch
 *
 * sorry, but this must be done in assembly language because we are
 * talking about micro seconds here.
 * you should come back to this loop at least every second or so, most
 * servos will hold their position forever, but who knows....
 * DON'T COME RIGHT BACK! Give at least 4 MS till you call this again!
 * if you don't there won't be much of a LOW time for the bits.
 *
 * You must set up the memory locations for storage of the setting
 * values, and match them with the "EQU"'s in the "asm" portion of
 * this routine.
 * You need to tell this routine how many bits you are using, the other
 * bits are not touched, you need to keep track of the unused bits
 * in the variable "pwmbits", then this routine uses that to set
 * the bits it uses and leave the others the way you define them.
 *
 * something like this :
 *
 * #define pwm0       0x0030
 * #define pwmbits    0x0038
 *
*/


pwm(){


#asm

* You tell us how many bits to use, starting with bit 7 first
BITNUM	EQU	2
* You define which port to use here
PWMPORT	EQU	$1000
* You define where the start of the values is at
PWM0	EQU	$30
* You show where the port's bit immage is stuck
PWMBITS	EQU	$38
* used in this routine only, counter of delay loops
PWMCNT	EQU	$39
* used in this routine only, mask for setting the bits
PWMMASK	EQU	$3A

	ldaa	#$80	* mask starts at bit 7
	staa	PWMMASK	* we do each bit's delay seperate because we don't 
*			  have enough time, so the more bits you have
*			  the longer this will all take

	ldy	#0	* y is our index to the memory locations
*			  first we set the bit HIGH

pwmlpx:	ldaa	PWMBITS	* here's what the port is now
	oraa	PWMMASK	* make that bit HIGH
	staa	PWMBITS	* record it for next time around
	staa	PWMPORT	* put it out to the port

	ldaa	#0	* now we do a delay till a number is found that
	staa	PWMCNT	* matches a bit's setting number, and set that bit low
*			  PWMCNT is the number of delay cycles we have done

pwmlp2:	ldaa	PWMCNT	* see if it's at what number we want for this bit
	cmpa	PWM0,Y
	beq	pwmout
	inc	PWMCNT	* keep doing the delay, this loop is just right!
	bra	pwmlp2

pwmout:	ldaa	PWMMASK	* it is so make this bit LOW, here's what the port is now
	eora	#$FF	* flip the bits for a AND mask
	anda	PWMBITS	* make that bit low
	staa	PWMBITS	* record it for next time around
	staa	PWMPORT	* put it out to the port
	clc
	ror	PWMMASK	* rotate the mask to the next bit
	iny
	cpy	#BITNUM * are we done with all the bits?
	bne	pwmlpx

#endasm

}

