/*
 *
 *  HC11 DEMO TEST Program
 * 
 *  This was a simple demo using the HC11 analog inputs and a POT
 *  reads out on a LCD display.
 *
 *  Compiled using Small C
 *
 *  Version 1.0 (02/20/95) - First Version!
 *
*/

/* we use a 32K EPROM, this sets up for "zend.h" file */
#define ROM32K

/* define these global variables for use by the LCD driver file */
/* character counter for display */
#define chcnt     *0x0002
/* sets extra bits not used in the display port */
#define disbuf    *0x0004

/* input buffer for serial ports */
#define rcvchar   *0x0006

/* you only include the files you need for your particular application */
#include "z68hc11.h"
#include "zUHCrun.h"
#include "zadc.c"
#include "zLCD1.c"
#include "zserial.c"
#include "zdelay.c"

/* globals for use by this program */

/* values used by this program */


portset()
{
disbuf = 0x00; /* set up for other port pins used besides display */
pokeb(XPORT1,0xFF);  /* set all bits high */
}

main()
{
int a, x, i;
portset(); /* set up all the ports */
serset(0x30);  /* set up serial port, baud rate 0x33=1200 0x32=2400 0x30=9600 */
adset(); /* set up to use the ad converter */
delay(1000); /* wait for display to come up */
setdis(); /* set up the display, clears it too */

print("%c     Joes  "); /* display our name! */
print("%2  Electronics   ");
delay(1000);

while(1)
 {
x=getad(7);
/* print("%3POT= "); /* show the pot value */
/* prhex(x); /* show hex value */
/* print(" ("); /* show the pot value */
/* prdec(3,x); /* show decimal value */
/* print(")"); /* show the pot value */

print("%2"); /* move to line 2 */

x = x >> 4; /* shift the number right by 4 bits */
if (x > 15) x = 15; /* limit the number to 15 places */
for (i = 0; i < x; i++) { /* send out a graph */
	cout('=');
	}
if (x < 15) {      /* send out rest in spaces */
	for (a = i; a < 15; a++) {
		cout(' ');
		}
	}

 } /* close the main "while" */
}



/* include this at the end of your program */

#include "zend.h"

