/* what does this do? Well it was a remote control for a (real) car crash we would do
for a TV program, never came to be but the thing works OK!
It used POTS on the input side, the transmitter, then the other side used
POTS on the ADC inputs to determine which motor to turn on. Simple
relays controlled servo motors with a ON signal and a DIRECTION signal
two relays were used for each motor. The idea is that the sending unit
would send let's say 100 - then the receiver unit would get the 100 and move the motor
in the right direction till the POT would read 100. There is a simple way to make
sure we got the correct transmission, and we would never be far from the stunt car,
also if we lost signal, it would slam on the breaks, turn ignition off,
to prevent a unintended crash.
Baud was only 1200, enough to do this OK.
So if you know someone who wants to crash a stunt car directly into a brick wall at
full speed, let them know you have this little program!
*/



/* turn this on and off depending on compile */


/* #define transmit */

/* turn off what you don't need in "HC11my.c" file */

#define no_lcd

/* character counter for display */
#define chcnt *0x0016
/* input buffer for serial ports */
#define rcvchar *0x0018

#include "68hc11.h"
#include "UHCrun.h"
#include "hc11my.c"

/* --------------  this is the TRANSMITER SECTION  ---------------- */

#ifdef transmit

portset()
{
pokeb(PORTA,0x00);  /* set all bits */
}


main()
{
int a0, a1, a2;
adset(); /* set up to use the ad converter */
portset(); /* set up all the ports */
serset(0x33);  /* set up serial port, baud rate 0x33=1200 0x32=2400 0x30=9600 */

while(1)
{
a0=getad(0);
if (a0 < 4) a0 = 4; /* keep it within limits for transmission */
if (a0 > 0xFA) a0 = 0xFA;
a1=getad(1);
if (a1 < 4) a1 = 4;
if (a1 > 0xFA) a1 = 0xFA;
a2=getad(2);
if (a2 < 4) a2 = 4;
if (a2 > 0xFA) a2 = 0xFA;

myout(0x03); myout(0x02); myout(0x01); /* sync */
dodata(a0); dodata(a1); dodata(a2);
}
}

dodata(a) /* here we output the data, plus "correction" */
int a;
{
myout(a);
myout(a + 1);
myout(a + 3);
}

myout(b) /* here we output the data, plus a delay */
int b;
{
sercout(b);
delay(4);
}

#endif


/* ----------- this is the RECEIVER SECTION  --------------- */

#ifndef transmit

portset()
{
pokeb(PORTD,0x30);
pokeb(DDRD,0x3C); /* set up port D */
pokeb(SPCR,0x00); /* set up port D */
pokeb(PORTA,0x78);  /* set all bits high */
}


main()
{
int a, i, x, good;
int temp[5], reading[5];
adset(); /* set up to use the ad converter */
portset(); /* set up all the ports */
serset(0x33);  /* set up serial port, baud rate 0x33=1200 0x32=2400 0x30=9600 */


while(1)
 {
x = 0;
while(1){ /* get the sync */
	while(!(a = getser())){}
	if (x == 2) {
		if (rcvchar == 1) break; /* go to next stage of sync */
		else x = 0; /* start over if bad sync */
		}
	if (x == 1) {
		if (rcvchar == 2) x = 2; /* go to next stage of sync */
		else x = 0; /* start over if bad sync */
		}
	if (x == 0) {
		if (rcvchar == 3) x = 1; /* go to next stage of sync */
		else x = 0; /* start over if bad sync */
		}
	}


good=1;
for (x = 0; x < 3; x++) { /* get the next 3 readings */

	for (i = 0; i < 3; i++) { /* get the next 3 chars */
		while(!(a = getser())){}
		temp[i] = rcvchar;
		}

	/* check the "correction" bytes */
	if ((temp[1] == (temp[0] + 1)) &&  
		(temp[2] == (temp[0] + 3))) reading[x] = temp[0];
	else good = 0;
	}

/* if (!good) ????("-BAD-"); */

a=getad(2);
if (a < 4) a = 4; /* keep it within limits for the same as the transmission */
if (a > 0xFA) a = 0xFA;

	if ((a < (reading[0] + 4)) && (a > (reading[0] - 4))) pokeb(PORTD,0x30); /* power = 0, dir = 0 */
else	{
	if (a < (reading[0] - 3))  pokeb(PORTD,0x3C); /* power = 1, dir = 1 */
	if (a > (reading[0] + 3))  pokeb(PORTD,0x38); /* power = 1, dir = 0 */
	}
 }
}

#endif

#include "zend.h"

