/* C include file -- hc11my.c , my suport routines */

#define XPORT1   0x2000

#asm
* hc11my.c -> not listed in assembler output.
	OPT	nol	
#endasm


/*-------------- A/D DRIVER AREA -----------------*/

#ifndef no_ad


adset()
{
pokeb(OPTION,0x90); /* Must turn on the ADPU bit, power up the power to the converters */
        /* you should do a delay after this! Book doesn't say how long! */
}

/* getad(port) - Get a reading from a A/D port, use 0 to 7 to indicate port pin
   port is pin number on port E, only 0 - 7 please!
*****************************************/
getad(port)
int port;
{
pokeb(ADCTL,port); /* this starts the conversion and selects the port */
while(!(peekb(ADCTL) & 0x80)) {} /* wait for the flag to show conversion complete */
return(peekb(ADR1)); /* return results */
}

/*-------------- END A/D DRIVER AREA -----------------*/

#endif


/*-------------- SERIAL DRIVER AREA -----------------*/

#ifndef no_serial


serset(baud)
int baud;
{
pokeb(BAUD,baud); /* set up serial port, baud rate 0x31=2400 0x30=9600 */
pokeb(SCCR1,0x00); /* data bits 8, one stop */
pokeb(SCCR2,0x0C); /* enable the TX and RX */
}

/* sercout(what) - Sends a character to the serial port
   what is the data
*****************************************/
sercout(what)
int what;
{
while(!(peekb(SCSR) & 0x80)) {} /* wait for trans data to clear out */
pokeb(SCDR,what); /* send the data out */
}

/* serprint("whatever") - Prints to the serial port
   no fancy stuff here yet
*****************************************/

serprint(s)
char *s;
{
	while (*s) {
		*s = *s & 0xFF; /* make sure everything is byte wide */
		if (*s == ']') {
			sercout(0x0D); /* do a CR line feed for terminal */
			sercout(0x0A);
			}
		else {sercout(*s);} /* output the character */
		s++;
	}
}

/* getser() - gets a character from serial port
*****************************************/

getser()
{
if (!(peekb(SCSR) & 0x20)) return(0); /* is something there? */
rcvchar = peekb(SCDR) & 0x00FF; /* return the data, in a global variable */
return(1); /* report we have something */
}


/* serhex(int) - Prints to serial
   a hex number
*****************************************/

serhex(num)
int num;
{
int temp;
temp=(num >> 12) & 0x000F; /* get upper digit */
if (temp < 0x0A) sercout(temp + 0x30);
if (temp > 0x09) sercout(temp + 0x37); /* 41 - 0A = 37 */
temp=(num >> 8) & 0x000F; /* get digit */
if (temp < 0x0A) sercout(temp + 0x30);
if (temp > 0x09) sercout(temp + 0x37); /* 41 - 0A = 37 */
temp=(num >> 4) & 0x000F; /* get digit */
if (temp < 0x0A) sercout(temp + 0x30);
if (temp > 0x09) sercout(temp + 0x37); /* 41 - 0A = 37 */
temp=num & 0x000F; /* get digit */
if (temp < 0x0A) sercout(temp + 0x30);
if (temp > 0x09) sercout(temp + 0x37); /* 41 - 0A = 37 */
}


/* serdec(dig,num) - Prints a decimal number
dig = number of digits to print, num = number
*****************************************/

serdec(dig,num)
int dig, num;
{
char s[20];
int i, n, n1;

n = num; /* put it local for more speed */

	for (i = 0; i < dig; i++) { /* do dig digits */
		n1 = 0;
		while (n >= 10) { /* devide by 10, the hard way, num is remainder */
			n = n - 10;
			n1++;
			}
		s[i] = n + '0'; /* the remainder is the digit */
		n = n1;
		}
	i= dig - 1;
	while (i >= 0) {
		s[i] = s[i] & 0xFF; /* make sure everything is byte wide */
		sercout(s[i]); /* output the character */
		i--;
	}
}


/*-------------- END SERIAL DRIVER AREA -----------------*/

#endif


/*-------------- EEPROM AREA -----------------*/

#ifndef no_eeprom


/* eeprog(addr,value) - Programs a byte in the EEPROM
   you get the idea....
*****************************************/

eeprog(addr,value) /* this ALWAYS ERASES THE BYTE, use addrs $B600 - $B7FF */
int addr,value;
{
/* ERASE */
pokeb(PPROG,0x16); /* turn on the latch, byte erase mode */
pokeb(addr,0);     /* write any data to latch for erase */
pokeb(PPROG,0x17); /* turn on the VPP, do program */
delay(50);         /* 10 ms delay needed, lets over do it */

/* PROGRAM */
pokeb(PPROG,0x02); /* turn on the latch, byte program mode */
pokeb(addr,value); /* write any data to latch for erase */
pokeb(PPROG,0x03); /* turn on the VPP, do program */
delay(50);         /* 10 ms delay needed, lets over do it */
pokeb(PPROG,0x00); /* turn everything off, return to normal */
}

/*-------------- END EEPROM AREA -----------------*/

#endif


/*-------------- LCD DRIVER AREA -----------------*/

#ifndef no_lcd

/* change these for particular displays */

#define disline1   0x00
#define disline2   0x28
#define disline3   0x10
#define disline4   0x50

/* disnib(RS,what) - Sends a "nibble" to the display
   RS is the condition of the RS bit, what is the data
*****************************************/

disnib(RS,what)
int RS,what;
	{
	int temp;
	temp = (what | disbuf) | 0x30;
	pokeb(XPORT1,temp); /* put the data out on the port */
	if (RS == 1) {
		/* pokeb(XPORT1,(temp & 0xFF)); /* set up RS=1 */
		pokeb(XPORT1,(temp & 0xDF)); /* E=0 */
		}
	if (RS == 0) {
		pokeb(XPORT1,(temp & 0xEF)); /* set up RS=0 */
		pokeb(XPORT1,(temp & 0xCF)); /* E=0 */
		}
	pokeb(XPORT1,temp); /* RS=1 E=1 done */
	}

/* disend() - does a delay and resets port
*****************************************/

disend()
	{
	delay(4);
	pokeb(XPORT1,(disbuf | 0x3F));  /* set all bits high */
	}
	
/* cout(what) - Sends a character to the display
   what is the data
*****************************************/
cout(what)
int what;
{
int upper;
chcnt = chcnt + 1;
upper = what >> 4;
disnib(1,upper); /* send upper nibble out RS=1*/
disnib(1,what); /* send lower nibble out RS=1*/
disend();
}



/* movdis(where) - Moves to a display area 0 - 1F
   assumes that port D bits 4 & 5 are set as outputs
*****************************************/

movdis(where)
int where;
{
int upper,lower; /* the number is $00 to $1F */
/* upper = (where >> 2) & 0x04; /* get upper number, move the '1' over */
upper = ((where >> 4) & 0x0007) | 0x0008; /* OR with 08, cmd is 08 or 0C */
lower = where & 0x000F; /* get data ready for lower */
disnib(0,upper); /* RS=0, do cmd */
delay(4);
disnib(0,lower); /* RS=0 */
disend(); /* does a delay and sets ports back */
}


/* clrdis() - Clears the display
   assumes that port D bits 4 & 5 are set as outputs
*****************************************/

clrdis() {
	disnib(0,0x00); /* RS=0, clear cmd */
	delay(4);
	disnib(0,0x01); /* RS=0 */
	delay(4);
	disnib(0,0x00); /* RS=0, set scroll */
	delay(4);
	disnib(0,0x06); /* RS=0 */
	disend(); /* does a delay and sets ports back */
	chcnt=0; /* reset the character counter */
	}


/* print("whatever") - Prints to the display
   no fancy stuff here yet
*****************************************/

print(s)
char *s;
{
	while (*s) {
		*s = *s & 0xFF; /* make sure everything is byte wide */
		if (*s == '%') {   /* look for that percent character */
			s++;  /* move up pointer */
			if (*s == 'c') clrdis(); /* clear the display */
			if (*s == '1') movdis(disline1); /* move to first line */
			if (*s == '2') movdis(disline2); /* move to 2nd line   */
			if (*s == '3') movdis(disline3); /* move to 3rd line   */
			if (*s == '4') movdis(disline4); /* move to 4th line   */
			chcnt=0;
			s++; /* move past the command character */
			} /* end backslash if statement */
		if(!*s) break; /* if it's a end character, quit this */
		cout(*s); /* output the character */
		s++;
	}
}


/* prdec(int) - Prints a decimal number
dig = number of digits to print, num = number
*****************************************/

prdec(dig,num)
int dig, num;
{
char s[20];
int i, n, n1;

n = num; /* put it local for more speed */

	for (i = 0; i < dig; i++) { /* do dig digits */
		n1 = 0;
		while (n >= 10) { /* devide by 10, the hard way, num is remainder */
			n = n - 10;
			n1++;
			}
		s[i] = n + '0'; /* the remainder is the digit */
		n = n1;
		}
	i= dig - 1;
	while (i >= 0) {
		s[i] = s[i] & 0xFF; /* make sure everything is byte wide */
		cout(s[i]); /* output the character */
		i--;
	}
}

/* prhex(int) - Prints to the display
   a hex number
*****************************************/

prhex(num)
int num;
{
int temp;
temp=(num >> 12) & 0x000F; /* get upper digit */
if (temp < 0x0A) cout(temp + 0x30);
if (temp > 0x09) cout(temp + 0x37); /* 41 - 0A = 37 */
temp=(num >> 8) & 0x000F; /* get digit */
if (temp < 0x0A) cout(temp + 0x30);
if (temp > 0x09) cout(temp + 0x37); /* 41 - 0A = 37 */
temp=(num >> 4) & 0x000F; /* get digit */
if (temp < 0x0A) cout(temp + 0x30);
if (temp > 0x09) cout(temp + 0x37); /* 41 - 0A = 37 */
temp=num & 0x000F; /* get digit */
if (temp < 0x0A) cout(temp + 0x30);
if (temp > 0x09) cout(temp + 0x37); /* 41 - 0A = 37 */
}


/* setdis() - Sets up the display
   assumes that port D bits 4 & 5 are set as outputs
*****************************************/

setdis() {
	pokeb(XPORT1,(disbuf | 0x3F));  /* set all bits high */
	delay(4);
	disnib(0,0x02); /* RS=0, set up for 4 bit transfer */
	delay(4);
	disnib(0,0x02); /* RS=0, set number of lines */
	delay(4);
	disnib(0,0x08); /* RS=0, set number of lines */
	delay(4);
	disnib(0,0x00); /* RS=0, Dis on, no cursor */
	delay(4);
	disnib(0,0x0C); /* RS=0, clear display next */
	delay(4);
	clrdis();    /* clear the display */
	}


/*-------------- END LCD DRIVER AREA -----------------*/

#endif


/* delay() - Delays for count millisecond(s).
count:	number of milliseconds to delay.
*****************************************/
#define	DLYCNT	18	/* 18 is correct for 8mhz operation	*/
			/*  9 for 4 mhz */
delay(count)
int count;		/* number of milliseconds to delay */
{
   int i,x;
   x = count;
   while ((--x) > 0)
   {
   i=DLYCNT;
   while ((--i) > 0)
   	{
        }
   }
}	/* end of delay */

#asm
	OPT	l

#endasm
