/* Just when you thought you couldn't make a serious business related
HC11 project, along comes this little IDE Hard Drive tester stuff.
You could use these routines to write to a IDE hard drive, or who
knows what.
I had to add several latches to put put the full buss for IDE, so
you need to look at the source code and also understand IDE stuff a bit.
This was a actual hard drive tester, used in a few businesses.
It had a keypad and a LCD display.
*/


/* debug mode, set to 1 when testing, SET TO 0 IN PRODUCTION! */

#define debug 1

/* globals, this is the only way to do this with this compiler */
/* these globals can only be int (16 bits) !! */
/* you need to specify memory locations */

#define track *0x0010
#define cyls  *0x0012
#define heads *0x0014

/* character counter for display */
#define chcnt *0x0016

/* misc variables */

/* current head */
#define head *0x0018

/* ports */
#define U9 0x7E00
#define U10 0x7801
#define U11 0x7802
#define U12 0x7800
#define U13 0x7803

/* for the done() routine */
#define SHORT 0
#define LONG 1
#define WAIT 2

#include "68hc11.h"
#include "UHCrun.h"
#include "hc11my.c"


portset()
{
pokeb(DDRD,0x30); /* set up port D */
pokeb(SPCR,0x00); /* set up port D */
pokeb(PORTA,0x78);  /* set all bits high */
pokeb(PORTD,0x30);
pokeb(U13,0xFF);  /* make upper 16 bit IDE latch input only */
}

keyup()
{
int k;
pokeb(U9,0x00); /* make them all low */
while (((peekb(PORTE) & 0x0F) ^ 0x0F)) {} /* sit until we have nothing pressed */
}

getkey()
{
int k;
k = (peekb(PORTE) & 0x0F) ^ 0x0F; /* gets key input and inverts results */
return (k);
}

keypad()
{
int k;
pokeb(U9,0x0E); /* check row 0, output a low */
if (k = getkey()) return (k + 0x10);  /* get the key input */
pokeb(U9,0x0D); /* check row 0, output a low */
if (k = getkey()) return (k + 0x20);  /* get the key input */
pokeb(U9,0x0B); /* check row 0, output a low */
if (k = getkey()) return (k + 0x30);  /* get the key input */
pokeb(U9,0x07); /* check row 0, output a low */
if (k = getkey()) return (k + 0x40);  /* get the key input */
return (0);
}

selreg(sel)
char sel;
{
sel = (sel | 0x80); /* set the upper 16 bit IDE latch input only */
pokeb(U13,sel);  /* output value */
}

docmd(cmd)
char cmd;
{
selreg(0x17); /* select the Command reg */
pokeb(U12,cmd); /* do the cmd */
}

main()
{
int x,k;
portset(); /* set up all the ports */
delay(1000); /* wait for display to come up */
setdis(); /* set up the display, clears it too */

track = 0;  /* set to track 0 */
cyls = 50;  /* have to put something here */
heads = 1;  /* least amount of heads */
head = 0;   /* current head setting */

while(1)
{
delay(100);
print("%cIDE TESTER V1.0"); /* here's where we start */
print("%2  Press a Key"); /* we start out at 0 */

while ((x = keypad()) == 0) {} /* get keypress */
switch (x) {
	case 0x48:
		print("%c   Test Ready   ");
		ready();
		break;
	case 0x44:
		print("%c     Recal      ");
		recal();
		track = 0;
		break;
	case 0x41:
		print("%c     Step +     ");
		step(1);
		break;
	case 0x42:
		print("%c     Step -     ");
		step(0);
		break;
	case 0x12:
		print("%c  Drive Diag.   ");
		diag();
		break;
	case 0x34:
		print("%c   Seek Half    ");
		seek(1);
		break;
	case 0x32:
		print("%c   Seek Full    ");
		seek(0);
		break;
	case 0x21:
		print("%c Identify Drive ");
		ident();
		break;
	case 0x22:
		print("%c   Set Head     ");
		sethead();
		break;
	case 0x28:
		print("%c  Read Pattern  ");
		read();
		break;
	case 0x14:
		print("%cWrite Pattern 1 ");
		write(1);
		break;
	case 0x18:
		print("%cWrite Pattern 2 ");
		write(2);
		break;
	default: 
		print("%c    What????    ");
		break;
	}
}
}

sethead(){
int x;
delay(400);
while (1) {
	print("%2 Head= ");
	prdec(2,head);
	while ((x = keypad()) == 0) {} /* get keypress */
	if (x == 0x41) head = head + 1;
	if (x == 0x42) head = head - 1;
	if (x == 0x22) break; /* press of the head set again */
	if (head < 0) head = 0;
	if (head > 15) head = 15;
	delay(200);
	}

}

puthead(){ /* sets the head in from the 'head' global variable */
char a;
a = head & 0x000F;
selreg(0x16); /* select the Head Reg */
pokeb(U12,a);
}

write(what)  /* write a sector, where we are, and 'what' is a pattern */
char what;
{
int i;
selreg(0x12); /* select the Sector Count Reg */
pokeb(U12,0x01);
selreg(0x13); /* select the Sector Number Reg */
pokeb(U12,0x01);
puthead(); /* select the Head Reg */
docmd(0x30); /* write Sector cmd */
delay(10);
selreg(0x10); /* select the Data reg */
for (i=0; i < 256; i++){ /* write the whole sector */
	pokeb(U12,what); /* put the pattern in */
	}
done(WAIT);  /* only wait for it to finish, don't report unless error */
delay(200);
}


read(){ /* read a sector, where we are, and see if it is a pattern */
int x,i;
int buf[10];
selreg(0x12); /* select the Sector Count Reg */
pokeb(U12,0x01);
selreg(0x13); /* select the Sector Number Reg */
pokeb(U12,0x01);
puthead(); /* select the Head Reg */
docmd(0x20); /* Read Sector cmd */
delay(100);
selreg(0x10); /* select the Data reg */
for (i=0; i < 9; i++){ /* get lower data */
	buf[i] = (peekb(U12) & 0x00FF);
	}
for (i=0; i < 256; i++){ /* read rest of data to nowhere */
	x=peekb(U12);
	}
done(WAIT);  /* only wait for it to finish, don't report unless error */
print("%2 Pattern= ");
i = buf[0] & 0x00FF;
if ((i != 1) && (i != 2)) print("??");
else prdec(2,i);
delay(1000);
}

ident(){  /* show all identify info */
int x,i;
int buf[52];
selreg(0x16); /* select the Head Reg, set the drive as master */
pokeb(U12,0x00);
docmd(0xEC); /* Identify Drive cmd */
delay(100);
selreg(0x10); /* select the Data reg */
for (i=0; i < 50; i++){ /* get lower data */
	buf[i] = (peekb(U12) & 0x00FF);
	}
for (i=0; i < 256; i++){ /* read rest of data to nowhere */
	x=peekb(U12);
	}
done(WAIT);  /* only wait for it to finish, don't report unless error */
docmd(0xEC); /* Identify Drive cmd */
delay(100);
selreg(0x10); /* select the Data reg */
for (i=0; i < 50; i++){ /* get high data */
	buf[i] = buf[i] | (((peekb(U10) & 0x00FF) << 8) & 0xFF00);
	}
for (i=0; i < 256; i++){ /* read rest of data to nowhere */
	x=peekb(U12);
	}
done(WAIT);  /* only wait for it to finish, don't report unless error */
	print("%cSer= "); /* show serial number */
for (i=10; i <= 19; i++){
	x = buf[i];
	cout(((x & 0xFF00) >> 8));
	cout((x & 0x00FF));
	}
	keyup();
	while ((x = keypad()) == 0) {} /* get keypress */
	print("%cVer= "); /* show software rev number */
for (i=23; i <= 26; i++){
	x = buf[i];
	cout(((x & 0xFF00) >> 8));
	cout((x & 0x00FF));
	}
	keyup();
	while ((x = keypad()) == 0) {} /* get keypress */
	clrdis();
for (i=27; i <= 46; i++){
	x = buf[i];
	cout(((x & 0xFF00) >> 8));
	cout((x & 0x00FF));
	}
	keyup();
	while ((x = keypad()) == 0) {} /* get keypress */
	print("%cCyls= "); /* show cyls */
	prdec(5,buf[1]);
	print("%2Hds =    "); /* show cyls */
	prdec(2,buf[3]);
	keyup();
	while ((x = keypad()) == 0) {} /* get keypress */
	cyls = buf[1];
	heads = buf[3];
}


seek(mode)
int mode;
{  /* seek, mode=1 half, mode=0 full */
int x, a, b, c;
char i;
pokeb(U9,0x00); /* make them all low, for key down detect */
a = 0; b = 0; c = 1;
while (1) {
	x = cyls - 5;
	if ((x < 0) || (x > 30000)) x = 50; /* most drives have 50 tracks */
	if (mode) x = x >> 1; /* simple devide by 2, shift right */
	i = x & 0x00FF;
	selreg(0x14); /* select the Cyl Low */
	pokeb(U12,i);
	i = (x >> 8) & 0x00FF;
	selreg(0x15); /* select the Cyl High */
	pokeb(U12,i);
	docmd(0x70);
	done(WAIT);  /* only wait for it to finish, don't report unless error */
	selreg(0x14); /* select the Cyl Low */
	pokeb(U12,0x00);
	selreg(0x15); /* select the Cyl High */
	pokeb(U12,0x00);
	docmd(0x70);
	done(WAIT); /* loop while the key is pressed */
		/* if we haven't pressed for long enough, quit */
	if (a > 15) {
		if (c) {
			print("%2 [LOCKED CONT.]"); /* print this once */
			c = 0;
			} /* show we have released the key now */
		if ((peekb(PORTE) & 0x0F) == 0x0F) b = 1; 
		}
	else 	{
		if ((peekb(PORTE) & 0x0F) == 0x0F) break;
		a++;
		}
	if (b && ((peekb(PORTE) & 0x0F) != 0x0F)) break; /* press again */
	}
}

diag(){  /* do a drive diagnostic */
docmd(0x90); /* do the cmd */
done(LONG);
}

ready(){
int k;
selreg(0x17); /* select the Status reg */
k=peekb(U12);
if ( (k & 0x80) != 0) {
	print("%2 --DRIVE BUSY--  ");
	return;
	}
if ( (k & 0x40) == 0) {
	print("%2 --NOT READY--   ");
	}
	else print("%2 Ready       ");
delay(1000);
}

recal(){
docmd(0x10);  /* do the cmd */
done(SHORT);
}


waitbsy()    /* wait for a busy signal, use ALT status */
{
int a, b;
selreg(0x0E); /* select the ALT Status reg */
b = 2;
a = 65533;
while ((peekb(U12) & 0x80) == 0) {
	if ((--a) == 0) {
		if ((--b) == 0) break; /* only wait for so long */
		a = 65533;
		}
	}
}


done(mode)    /* mode is long or short timeout */
int mode;
{
int a, b, k;
selreg(0x17); /* select the Status reg */
if (mode == LONG) { b = 20; } /* if mode == true, super long timeout */
else b = 1;
a = 65533;
while ((peekb(U12) & 0x80) != 0) {
	if ((--a) == 0) {
		if ((--b) == 0) break; /* only wait for so long for completion */
		a = 65533;
		}
	}
if (b == 0) {
	print("%cCOMMAND TIMEOUT"); /* we timed out */
	delay(2000);
	}
else	{
	if ((peekb(U12) & 0x01) !=0) { /* error bit was on */
		print("%cERROR -");
		selreg(0x11); /* select the Error reg */
		k = peekb(U12);
		prhex(k);
		delay(2000);
		}
	else	{
		if (mode != WAIT) {
			print("%2 Done...        ");
			delay(500);
			}
		}
	}
}

step(dir)
int dir;
{
int a;
char x;
pokeb(U9,0x00); /* make them all low, for key down detect */
while (1) {
	if (dir) track = track + 1;
	else if (track != 0) track = track -1; /* don't go beyond 0 */
	print("%2 Track = ");
	prdec(5,track);
	x = track & 0x00FF; /* get the low value */
	selreg(0x14); /* select the Cyl Low */
	pokeb(U12,x);
	x = ((track & 0xFF00) >> 8) & 0x00FF; /* get the high value */
	selreg(0x15); /* select the Cyl High */
	pokeb(U12,x);
	docmd(0x70); /* do the step command */
	done(WAIT);
	if ((peekb(PORTE) & 0x0F) == 0x0F) break; /* loop while the key is pressed */
	}
}


#include "endstuff.h"

