
/* C include file -- zLCD2.c
 *
 *
 *  Compiled using Small C
 *
 *  THIS DRIVER IS ONLY FOR THIS TYPE OF DISPLAY!
 *  This was done by modifying the zlcd1.c file.
 *
 * This was tested on the display using the "HD44780" controller
 * including the following:
 *
 * 4X40 - Optrex DMC40457
 *
 * Just look for the HD44780 chip !
 *
 *  V 1.0 (03/16/95) - Good working version
 *
 *
 *  This uses the external latch for output
 *
 *   D7   6   5   4   3   2   1   0    LATCH OUTPUT
 *
 *        E   E   R   D   D   D   D    DISPLAY
 *        1   0   S   7   6   5   4
 *
 *   Note that this display has 2 enables, it's like having
 *   two 2 X 40 displays.
 *
 *  (D7 is not used, but in this driver, we set it high)
*/

#asm
* zLCD1.c -> this is not listed in assembler output.
*	OPT	nol	
#endasm


/* NOTE: YOU MUST DEFINE THESE TWO GLOBALS IN YOUR PROGRAM!
 * they are two bytes each (16 bits) and I have no idea where
 * you are putting your globals, so you keep track of where to
 * stick these globals!
 * you need to do something like this:
 *
 *   #define chcnt     *0x0002
 *   #define disbuf    *0x0004
 *
 *
*/

/* NOTE: FOR THIS DISPLAY ONLY, we are using another global and
 * will define it here, so watch out for conflicts!
 *
 * It's for the extra enable, tells us which one to write to
*/

#define whichE     *0x0008


/* the port used by the LCD display code */
#define XPORT1   0x2000


/* NOTE: CHANGE THIS VALUE FOR THE DISPLAY YOU ARE USING
 * 
 * Bits:   1 = Number of lines, 1= 2 lines, 0= 1 line
 *         0 = Format of characters, 1 = 5X10 dots, 0= 5X7 dots
 *
 * Example:  0x02 means a 2 (or more) line display, 5X7 dots (like a LM016)
 *           0x01 means a 1 line display, 5X10 dots (like a DMC-16106)
 *
*/

#define discfg  0x02


/* Note: change these for particular displays, these are the starting
 * "memory" locations for each line, sets the "cursor" there
 * these numbers work just fine with most of the displays tested
 * line 3 for a 4X20 would be at 20, line 4 at 84 and so on...
 * you can easily test this by printing 4 test words on each line
*/

#define disline1   0
#define disline2   40
#define disline3   16
#define disline4   80


/* the delay used between commands sent in the LCD display code in MS
 * if yo uare trying out a new display, you might want to increase this
 * value a bit, 4 MS is all that is needed most of the time
*/
#define disdelay  5


/*-------------- LCD DRIVER AREA -----------------*/


/* disnib(RS,what) - Sends a "nibble" to the display
   RS is the condition of the RS bit, what is the data
*****************************************/

disnib(RS,what)
int RS,what;
	{
	int temp;
	temp = (what | disbuf) | 0x70;
	pokeb(XPORT1,temp); /* put the data out on the port */
	if (RS == 1) {
		/* pokeb(XPORT1,(temp & 0xFF)); /* set up RS=1 */
		if (!whichE) pokeb(XPORT1,(temp & 0xDF)); /* E=0  half 0 */
		else pokeb(XPORT1,(temp & 0xBF)); /* E=0 */
		}
	if (RS == 0) {
		pokeb(XPORT1,(temp & 0xEF)); /* set up RS=0 */
		if (!whichE) pokeb(XPORT1,(temp & 0xCF)); /* E=0 half 0 */
		else pokeb(XPORT1,(temp & 0xAF)); /* E=0 */
		}
	pokeb(XPORT1,temp); /* RS=1 E=1 done */
	}

/* disend() - does a delay and resets port
*****************************************/

disend()
	{
	delay(disdelay);
	pokeb(XPORT1,(disbuf | 0x7F));  /* set all bits high */
	}
	
/* cout(what) - Sends a character to the display
   what is the data
*****************************************/
cout(what)
int what;
{
int upper;
chcnt = chcnt + 1;
upper = what >> 4;
disnib(1,upper); /* send upper nibble out RS=1*/
disnib(1,what); /* send lower nibble out RS=1*/
disend();
}



/* movdis(where) - Moves to a display area 0 - 1F
   assumes that port D bits 4 & 5 are set as outputs
*****************************************/

movdis(where)
int where;
{
int upper,lower; /* the number is $00 to $1F */
/* upper = (where >> 2) & 0x04; /* get upper number, move the '1' over */
upper = ((where >> 4) & 0x0007) | 0x0008; /* OR with 08, cmd is 08 or 0C */
lower = where & 0x000F; /* get data ready for lower */
disnib(0,upper); /* RS=0, do cmd */
delay(disdelay);
disnib(0,lower); /* RS=0 */
disend(); /* does a delay and sets ports back */
}


/* clrdis() - Clears the display
   assumes that port D bits 4 & 5 are set as outputs
*****************************************/

clrdis() {
int x;
for (x = 0; x < 2; x++) {
	whichE = x;
	disnib(0,0x00); /* RS=0, clear cmd */
	delay(disdelay);
	disnib(0,0x01); /* RS=0 */
	delay(disdelay);
	disnib(0,0x00); /* RS=0, set scroll */
	delay(disdelay);
	disnib(0,0x06); /* RS=0 */
	disend(); /* does a delay and sets ports back */
	chcnt=0; /* reset the character counter */
	}
whichE = 0;
}


/* print("whatever") - Prints to the display
   no fancy stuff here yet
*****************************************/

print(s)
char *s;
{
	while (*s) {
		*s = *s & 0xFF; /* make sure everything is byte wide */
		if (*s == '%') {   /* look for that percent character */
			s++;  /* move up pointer */
			if (*s == 'c') clrdis(); /* clear the display */
			if (*s == '1') {
				whichE = 0;
				movdis(disline1); /* move to first line */
				}
			if (*s == '2') {
				whichE = 0;
				movdis(disline2); /* move to 2nd line   */
				}
			if (*s == '3') {
				whichE = 1;
				movdis(disline1); /* move to 3rd line   */
				}
			if (*s == '4') {
				whichE = 1;
				movdis(disline2); /* move to 4th line   */
				}
			chcnt=0;
			s++; /* move past the command character */
			} /* end backslash if statement */
		if(!*s) break; /* if it's a end character, quit this */
		cout(*s); /* output the character */
		s++;
	}
}


/* prdec(int) - Prints a decimal number
dig = number of digits to print, num = number
*****************************************/

prdec(dig,num)
int dig, num;
{
char s[20];
int i, n, n1;

n = num; /* put it local for more speed */

	for (i = 0; i < dig; i++) { /* do dig digits */
		n1 = 0;
		while (n >= 10) { /* devide by 10, the hard way, num is remainder */
			n = n - 10;
			n1++;
			}
		s[i] = n + '0'; /* the remainder is the digit */
		n = n1;
		}
	i= dig - 1;
	while (i >= 0) {
		s[i] = s[i] & 0xFF; /* make sure everything is byte wide */
		cout(s[i]); /* output the character */
		i--;
	}
}

/* prhex(int) - Prints to the display
   a hex number
*****************************************/

prhex(num)
int num;
{
int temp;
temp=(num >> 12) & 0x000F; /* get upper digit */
if (temp < 0x0A) cout(temp + 0x30);
if (temp > 0x09) cout(temp + 0x37); /* 41 - 0A = 37 */
temp=(num >> 8) & 0x000F; /* get digit */
if (temp < 0x0A) cout(temp + 0x30);
if (temp > 0x09) cout(temp + 0x37); /* 41 - 0A = 37 */
temp=(num >> 4) & 0x000F; /* get digit */
if (temp < 0x0A) cout(temp + 0x30);
if (temp > 0x09) cout(temp + 0x37); /* 41 - 0A = 37 */
temp=num & 0x000F; /* get digit */
if (temp < 0x0A) cout(temp + 0x30);
if (temp > 0x09) cout(temp + 0x37); /* 41 - 0A = 37 */
}


/* setdis() - Sets up the display
   assumes that port D bits 4 & 5 are set as outputs
*****************************************/

setdis() {
int i,x;
for (x = 0; x < 2; x++) { /* do both halfs of display */
	whichE = x;
	pokeb(XPORT1,(disbuf | 0x7F));  /* set all bits high */
	delay(disdelay);
	disnib(0,0x02); /* RS=0, set up for 4 bit transfer */
	delay(disdelay);
	disnib(0,0x02); /* RS=0, set number of lines */
	delay(disdelay);
	i = (discfg << 2) & 0x0C;
	disnib(0,i); /* RS=0, set number of lines */
	delay(disdelay);
	disnib(0,0x00); /* RS=0, Dis on, no cursor */
	delay(disdelay);
	disnib(0,0x0C); /* RS=0, clear display next */
	delay(disdelay);
	}
clrdis();    /* clear the display, does both halfs */
}



/*-------------- END LCD DRIVER AREA -----------------*/


#asm
	OPT	l

#endasm
