*** EQUATES ***
WREN    equ 6
RDSR    equ 5
MASKCE  equ $20
DDRD    equ 9
PORTD   equ 8
SPCR    equ $28
SPSR    equ $29
SPDR    equ $2a
IPH     equ 0
IPL     equ 1
CI      equ 2
EEDAT   equ 3
IP      equ 0
RP      equ 4
RP0     equ 5
SP0     equ $4f
        org $B600
INIT:   lds #SP0         *initialize SP
        ldy #$1000
        ldaa #$3f
        staa DDRD,y
        ldaa #$50
        staa SPCR,y
        ldaa SPSR,y
        ldx #0
        stx IP          * initialize IP
        ldaa #RP0
        staa RP         * initialize RP
        jmp NEXT
*
* SEEPROM routines from MICROCHIP application notes AN609
*
READ:   bsr CELOW
        ldaa #3
        bsr SEND
        ldaa IPH
        bsr SEND
        ldaa IPL
        bsr SEND
        bsr SEND
        staa EEDAT
        bsr CEHIGH
        rts
WRITE:  bsr CELOW
        ldaa #WREN
        bsr SEND
        bsr CEHIGH
        bsr CELOW
        ldaa #2
        bsr SEND
        ldaa IPH
        bsr SEND
        ldaa IPL
        bsr SEND
        ldaa EEDAT
        bsr SEND
        bsr CEHIGH
ACKPOL: bsr CELOW
        ldaa #RDSR
        bsr SEND
        bsr SEND
        bsr CEHIGH
        anda #1
        bne ACKPOL
        rts
SEND:   staa SPDR,y
WAIT:   brclr SPSR,y $80 WAIT
        ldaa SPDR,y
        rts
CELOW:  bclr PORTD,y MASKCE
        rts
CEHIGH: bset PORTD,y MASKCE
        rts
*
* push ACCX on the return stack
*
RPUSH:  ldab RP
        clra
        xgdx
        std 0,x
        inx
        inx
        xgdx
        stab RP
        rts
*
* pop return stack into ACCX
*
RPOP:   ldab RP
        clra
        xgdx
        dex
        dex
        ldd 0,x
        xgdx
        stab RP
        rts
*
* ( addr -- data ) fetch 1 byte from SEPROM address
*
EELOD:  pulx            * get address
        ldd IP          * save IP
        stx IP          * put address in IP
        xgdx            * ACCX holds IP
        bsr READ        * read SEEPROM
        ldab EEDAT      * put data in ACCB
        clra            * only a byte, so clear ACCA
        stx IP          * restore IP
        jmp PUSHD       * push ACCD
*
* ( data addr -- ) store 1 byte in SEEPROM
*
EESTO:  pulx            * get ADDRESS
        pula
        pulb            * get data
        stab EEDAT      * store byte to be written in EEDAT
        ldd IP          * save IP
        xgdx            * ACCX holds IP
        std IP          * store address in IP
        bsr WRITE       * write to SEEPROM
        stx IP          * restore IP
        jmp NEXT
*
* ( n addr -- ) add n to data in addr
*
PSTO:   pulx
        pula
        pulb
        addd 0,x
        std 0,x
        jmp NEXT
*
* ( -- SP ) return current stack pointer
*
SPAT:   tsx
        jmp PUSHX
*
* ( -- ) enable interrupts
*
E_INT:  cli
        jmp NEXT
*
* ( -- ) disable interrupts
*
D_INT:  sei
        jmp NEXT
*
* ( bitmask addr -- ) set bits at addr - bit mask has 1's
*                     in position to be set
*
BIT_SET:
        pulx
        pulb
        pulb
        orab 0,x
        stab 0,x
        jmp NEXT
*
* ( bismask addr -- ) clr bits at addr - bit mask has 1's in position
*                     to be cleared
*
BIT_CLR:
        pulx
        pulb
        pulb
        comb
        andb 0,x
        stab 0,x
        jmp NEXT
*
* ( addr -- ) executes a user routine at address on top of the stack
*             routine must end in JUMP to NEXT, PUSHD or PUSHX
*
EXEC:   pulx
        jmp 0,x

        org $b6e8
*
* fetch 1 byte from SEEPROM using instruction pointer as address.
* update the instruction pointer
*
FETCH:  jsr READ
        ldx IP
        inx
        stx IP
        ldab EEDAT
        rts
*
* fetch 2 bytes from SEEPROM  return them in ACCX
*
F2:     jsr FETCH
        stab CI
        jsr FETCH
        ldaa CI
        xgdx
        rts
        org $B700
*
* used to call words in page $B6
*
EXT:    bsr FETCH
        ldaa #$b6
        ldab EEDAT
        xgdx
        jmp 0,x
*
* puts 2 bytes on stack
*
LIT:    bsr F2
        bra PUSHX
*
* branch to an address
*
BR:     bsr F2
        stx IP
        bra NEXT
*
* if TOS=0 then branch else skip 2
*
ZBR:    pulx
        cpx #0
        beq BR
        ldx IP
        inx
        inx
        stx IP
        bra NEXT
*
* call a subroutine
*
CAL:    ldx IP
        inx
        inx
        jsr RPUSH
        bra BR
*
* return from a subroutine
*
RET:    jsr RPOP
        stx IP
        bra NEXT
*
* ( addr -- word ) loads stack with a word from addr
*
LOD:    pulx
        ldd 0,x
        bra PUSHD
*
* ( addr -- byte ) loads stack with a byte from addr
*
CLOD:   pulx
        ldab 0,x
        clra
        bra PUSHD
*
* ( word addr -- ) stores word from stack in addr
*
STO:    pulx
        pula
        pulb
        std 0,x
        bra NEXT
*
* ( byte adr -- ) stores byte from stack in addr
*
CSTO:   pulx
        pula
        pulb
        stab 0,x
        bra NEXT
*
* ( n2 n1 -- n1 n2 ) swaps top two numbers on the stack
*
SWAP:   pulx
        pula
        pulb
        xgdx
        pshb
        psha
        bra PUSHX
*
* ( n1 -- ) drops the top of the stack
*
DROP:   pulx
        bra NEXT
*
* ( n1 -- n1 n1 ) copies the top of the stack
*
DUP:    pulx
        pshx
        bra PUSHX
*
* ( n2 n1 -- n2 n1 n2 ) copies the next on the stack to the top of the stack
*
OVER:   pulx
        xgdx
        pulx
        pshx
        xgdx
        pshx
        bra PUSHD
*
* (n2 n1 -- r q ) n2/n1  remainder on top, followed by the quotient
*
DIV:    pulx
        pula
        pulb
        idiv
        pshx
        bra PUSHD
*
* ( n2 n1 -- prod ) n1*n2 leaves product NOTE: THIS ROUTINE ONLY MULTIPLIES
*                                              THE LSB OF n1 AND n2
*
MULT:   pulb
        pulb
        pula
        pula
        mul
        bra PUSHD
*
* ( n1 n2 -- sum ) n1+n2
*
ADD:    pulx
        xgdx
        tsx
        addd 0,x
        pulx
*
* inner interpreter - fetches a byte in SEEPROM  and jumps to that address
*                     on page $b7
*
* push ACCD
*
PUSHD:  xgdx
*
* push ACCX
*
PUSHX:  pshx
NEXT:   jsr FETCH
        ldaa #$b7
        xgdx
        jmp 0,x
*
* "-" ( n2 n1 -- diff ) n2-n1
*
SUB:    pulx
        xgdx
        pulx
        xgdx
        pshx
        tsx
        subd 0,x
        pulx
        bra PUSHD
*
* ( n1 -- ~n1 ) 1's complement of n1
*
NOT:    pula
        pulb
NOT0:   coma
        comb
        bra PUSHD
*
* ( n1 -- -n1 ) 2's complement of n1
*
NEG:    pulx
        dex
        xgdx
        bra NOT0
*
* ( n2 n1 -- T|F ) if n1=n2 then put $FFFF on the stack else put 0
*
EQ:     pula
        pulb
        tsx
        cpd 0,x
        beq TRUE
FALSE:  pulx
        clra
        clrb
        bra PUSHD
*
* ( n2 n1 -- T|F ) true if n2>n1
*
GT:     pula
        pulb
        tsx
        cpd 0,x
        bhs FALSE
TRUE:   pulx
        ldd #$ffff
        bra PUSHD
*
* ( n2 n1 -- T|F ) true if n2<n1
*
LT:     pula
        pulb
        tsx
        cpd 0,x
        bls FALSE
        bra TRUE
*
* ( n1 -- ) pushes n1 onto return stack
*
RTO:    pulx
        jsr RPUSH
        bra NEXT
*
* ( -- n1 ) pops n1 off return stack to data stack
*
RFROM:  jsr RPOP
        bra PUSHX
*
* ( -- n1 ) copies the top of the return stack to data stack
*
RAT:    jsr RPOP
        jsr RPUSH
        bra PUSHX
*
* ( n2 n1 -- n2&n1 ) logical n1 AND n2
*
AND:    pula
        pulb
        tsx
        anda 0,x
        andb 1,x
AND0:   pulx
        bra PUSHD
*
* ( n2 n1 -- n2|n1 ) logical n1 OR n2
*
OR:     pula
        pulb
        tsx
        ora 0,x
        orb 1,x
        bra AND0
*
* ( n2 n1 -- n2^n1 ) logical n1 XOR n2
*
XOR:    pula
        pulb
        tsx
        eora 0,x
        eorb 1,x
        bra AND0
*
* ( n1 -- n1+1 ) increment n1 by 1
*
INC:    pulx
        inx
        bra PUSHX
*
* ( n1 -- n1-1 ) decrement n1 by 1
*
DEC:    pulx
        dex
        bra PUSHX
*
* ( -- ) powers down MPU until a reset, IRQ or XIRQ
*
HALT:   tpa
        anda #$7f
        tap
        nop
        stop
        jmp INIT
*
* ( n1 -- 2*n1 ) double TOS
*
DBL:    pulx
        xgdx
        lsld
        jmp PUSHD
