; Cady_LabS12CIntro20.asm
; Source 1: LABS12CINTRO20, Rev 1 by Fred Cady (Freescale Semiconductor) instructor handout
; Source 2: Mazidi 11-18, too.
; 
; Use Mazidi's RTI example code to create pulses on PM5.
; Feed those pulses into PT1.  Polling on PT1 will occur.
; Whenever a polling cycle reveals an edge, then turn on/off PM2.
; Take PM2 and feed it into a BJT-driven LED.
;
;
;
; My Documents\Cady_Lab@12Cintro20_PM5LED\Sources\main.asm
;******************************** 
; Define the entry points for the main program, ISRs, stack pointer & subroutines

; export symbols
            XDEF Entry, main, RTI_ISR; _Startup            ; export 'Entry' symbol
            ABSENTRY Entry        ; for absolute assembly: mark this as application entry point


 ;             XDEF Entry, main, OC2_isr 
 ;             ;XREF __SEG_END_SSTACK 
 ;             ;XREF get_period
 ;             ; We are coding in "Absolute" assembly.  Therefore, include the following:
 ;             ABSENTRY  Entry, main, OC2_isr;, __SEG_END_SSTACK;, get_period      ; for absolute assembly: mark this as application entry point

; -   -   -   -   -   -   -   - 
BIT0:		EQU		%00000001		; Bit 0  (general purpose)
BIT1:		EQU		%00000010		; Bit 1  (general purpose)
BIT2:		EQU		%00000100		; Bit 2  (general purpose)
BIT3:		EQU		%00001000		; Bit 3  (general purpose)
BIT4:		EQU		%00010000		; Bit 4  (general purpose)
BIT5:		EQU		%00100000		; Bit 5  (general purpose)
BIT6:		EQU		%01000000		; Bit 6  (general purpose)
BIT7:		EQU		%10000000		; Bit 7  (general purpose)
EDG1B: 	EQU 	BIT3			; TIC1's `B' edge  in TCTL4
EDG1A: 	EQU 	BIT2			; TIC1's `A' edge  in TCTL4
TEN: 		EQU 	BIT7			; Timer enable bit in TSCR1
OM2:    EQU   BIT5
OL2:    EQU   BIT4
; Cady includes a number of other equates.  However, these are handled in mc9s12c32.inc

; Constants 
;HALF_P: 	EQU 	$FFFF  ; was $1000

; -   -   -   -   -   -   -   - 
; Include 9s12c32 derivative-specific definitions 
; If you use a different 9s12, then this needs to change.
          INCLUDE 'mc9s12c32.inc'
          
ROMStart    EQU  $4000  ; absolute address to place my code/constant data

; ---------------------------------------------------------------          
; Data Section 			Data Section			Data Section
; --------------------------------------------------------------- 
; variable/data section
; ---------------------------------------------------------------          
; Data Section 			Data Section			Data Section
; ---------------------------------------------------------------  			
;Data:		SECTION

 ifdef _HCS12_SERIALMON
            ORG $3FFF - (RAMEnd - RAMStart)
 else
            ORG RAMStart
 endif
 ; Insert here your data definition.
count1:		DS.w	1
TEMP	  DC.B	1           ; Scratch variable 1
COUNT	  DC.B	1           ; Scratch variable 2







; ---------------------------------------------------------------          
; Code Section 			Code Section			Code Section
; ---------------------------------------------------------------          
; code section
           ORG   ROMStart
;MyCode: 	SECTION 
Entry: 
main:
			;lds #__SEG_END_SSTACK	; Stack Pointer
;Entry:
;_Startup:
            ; remap the RAM &amp; EEPROM here. See EB386.pdf
 ifdef _HCS12_SERIALMON
            ; set registers at $0000
            CLR   $11                  ; INITRG= $0
            ; set ram to end at $3FFF
            LDAB  #$39
            STAB  $10                  ; INITRM= $39

            ; set eeprom to end at $0FFF
            LDAA  #$9
            STAA  $12                  ; INITEE= $9


            LDS   #$3FFF+1        ; See EB386.pdf, initialize the stack pointer
 else
            LDS   #RAMEnd+1       ; initialize the stack pointer
 endif
 			
; Use IC1 to measure the period Set up timer channel 1 for input capture

 ;Interrupt set-up for the "ReTurn from Interrupt" (RTI) 	
	      BSET	CRGINT,%10000000	
	      LDAA	#%01111111  ;longest RTI is about 0.13 sec Change this number to see toggling rate for RTI	
	      STAA 	RTICTL	
	      CLR	  TEMP			
	      CLR 	COUNT     		
        ; Make Port M's PM5 & PM2   outputs.
        MOVB  #%00100100,DDRM     ; make PM5 & PM2 output 
        CLR   PTM                 ; ensure both are off
        ;CLI       ; unmask the interrupts in the CCR; ENABLE INTERRUPTS GLOBALLY
        
        MOVB  #%00000010,DDRT     ; make PT1 input (for input capture 1)


			bclr TIOS,BIT1	; Channel 1
			; Initialize IC1 for rising edge capture EDG1B=0, EDG1A=1
			bclr TCTL4,EDG1B
			bset TCTL4,EDG1A 
			; Reset C1F flag
			ldaa #BIT1
			staa TFLG1
			; Setup Data Direction on Port T: PT1 is input
			ldaa #BIT1
			staa DDRT
			; Setup pull-up on PT1   (pull-device & it's pull-up)
			bclr PPST,mPPST_PPST1	; Channel 1      ; 0 is pull-up, 1 is pull-down
			bset PERT,mPERT_PERT1   ; 1 is enabled pull device (up or down)


			; Clear the count variable
			CLR   count1            ; clear 1 byte
			CLR   count1+1          ; clear another byte
			; Unmask global interrupts
			cli
			
			
			; Wait for the first rising edge on channel 1
spin1:		
			brclr	TFLG1,BIT1,spin1    ; 
			
			LDAA  #%00000100			; LED on PM2 turns on
      STAA  PTM
		
			
			; Reset the C1F flag
			ldaa	#BIT1
			staa	TFLG1
			
			; Wait for the next rising edge
spin2:
			brclr	TFLG1,BIT1,spin2        ;  
			
			LDAA  #%00000000          ;  turn off LED on PM2
      STAA  PTM
			
			; Now do what you like with the count
			nop
			bra 	spin1
			
; - - - - -
; Interrupt Service Routines Defined here
;
; -- Interrupt Service Routine (ISR) for RTI to tun on PortM.5 (PM5)
; the program comes here because the RTI was activated.
RTI_ISR
        INC   COUNT           ; increment the count
        LDAA  COUNT         ; A = COUNT
        CMPA  #8            ; is it ~2 sec? (8x0.262144 sec)  
        BNE   OVER          ; if not clear RTIF and return
        LDAA  TEMP          ; get the last value
        EORA  #%00100000    ; toggle bit 5 on Port M
        STAA  TEMP          ; store the new value
        STAA  PTM           ; display on Port M
        CLR   COUNT
OVER    BSET  CRGFLG, %10000000 ; clear RTIF
        RTI                 ; return from interrupt

; ---------------------------------------------------------------          
; Interupt Vector Section 	              Interupt Vector Section
; ---------------------------------------------------------------  					

;**************************************************************
;*                 Interrupt Vectors                          *
;**************************************************************
           ORG   $FFFE
           DC.W  Entry           ; Reset Vector
         
           ORG 	$FFF0           ;Vector table location for RTI interupt
    	      DC.W 	RTI_ISR
    

