; Cady_LabS12CIntro20.asm
; Source: LABS12CINTRO20, Rev 1 by Fred Cady (Freescale Semiconductor) instructor handout
; Test program to demonstrate the timer
; input capture.
; Outputs a 2000 clock cycle period squarewave on PT2
; Connect PT1 to PT2 to measure the period
;******************************** 
; Define the entry points for the main program, ISRs, stack pointer & subroutines

; export symbols
            XDEF Entry, main, OC2_isr; _Startup            ; export 'Entry' symbol
            ABSENTRY Entry        ; for absolute assembly: mark this as application entry point


 ;             XDEF Entry, main, OC2_isr 
 ;             ;XREF __SEG_END_SSTACK 
 ;             ;XREF get_period
 ;             ; We are coding in "Absolute" assembly.  Therefore, include the following:
 ;             ABSENTRY  Entry, main, OC2_isr;, __SEG_END_SSTACK;, get_period      ; for absolute assembly: mark this as application entry point

; -   -   -   -   -   -   -   - 
BIT0:		EQU		%00000001		; Bit 0  (general purpose)
BIT1:		EQU		%00000010		; Bit 1  (general purpose)
BIT2:		EQU		%00000100		; Bit 2  (general purpose)
BIT3:		EQU		%00001000		; Bit 3  (general purpose)
BIT4:		EQU		%00010000		; Bit 4  (general purpose)
BIT5:		EQU		%00100000		; Bit 5  (general purpose)
BIT6:		EQU		%01000000		; Bit 6  (general purpose)
BIT7:		EQU		%10000000		; Bit 7  (general purpose)
EDG1B: 	EQU 	BIT3			; TIC1's `B' edge  in TCTL4
EDG1A: 	EQU 	BIT2			; TIC1's `A' edge  in TCTL4
TEN: 		EQU 	BIT7			; Timer enable bit in TSCR1
OM2:    EQU   BIT5
OL2:    EQU   BIT4
; Cady includes a number of other equates.  However, these are handled in mc9s12c32.inc

; Constants 
HALF_P: 	EQU 	$1000

; -   -   -   -   -   -   -   - 
; Include 9s12c32 derivative-specific definitions 
; If you use a different 9s12, then this needs to change.
          INCLUDE 'mc9s12c32.inc'
          
ROMStart    EQU  $4000  ; absolute address to place my code/constant data

; ---------------------------------------------------------------          
; Data Section 			Data Section			Data Section
; --------------------------------------------------------------- 
; variable/data section
; ---------------------------------------------------------------          
; Data Section 			Data Section			Data Section
; ---------------------------------------------------------------  			
;Data:		SECTION

 ifdef _HCS12_SERIALMON
            ORG $3FFF - (RAMEnd - RAMStart)
 else
            ORG RAMStart
 endif
 ; Insert here your data definition.
;Counter     DS.W 1
;FiboRes     DS.W 1
count1:		DS.w	1








; ---------------------------------------------------------------          
; Code Section 			Code Section			Code Section
; ---------------------------------------------------------------          
; code section
           ORG   ROMStart
;MyCode: 	SECTION 
Entry: 
main:
			;lds #__SEG_END_SSTACK	; Stack Pointer
;Entry:
;_Startup:
            ; remap the RAM &amp; EEPROM here. See EB386.pdf
 ifdef _HCS12_SERIALMON
            ; set registers at $0000
            CLR   $11                  ; INITRG= $0
            ; set ram to end at $3FFF
            LDAB  #$39
            STAB  $10                  ; INITRM= $39

            ; set eeprom to end at $0FFF
            LDAA  #$9
            STAA  $12                  ; INITEE= $9


            LDS   #$3FFF+1        ; See EB386.pdf, initialize the stack pointer
 else
            LDS   #RAMEnd+1       ; initialize the stack pointer
 endif
 			
; Use TC2 to output a squarewave with the period 2 x HALF_P cycles 
; Use IC1 to measure the period Set up timer channel 1 for input capture

			; Enable the timer
			bset TSCR1,TEN
			; Reset TIOS bit to enable input capture 
			bclr TIOS,BIT1	; Channel 1
			; Initialize IC1 for rising edge capture EDG1B=0, EDG1A=1
			bclr TCTL4,EDG1B
			bset TCTL4,EDG1A 
			; Reset C1F flag
			ldaa #BIT1
			staa TFLG1		
			; Set up time channel 2 for output compare
			; Enable Output Compare Channel 			
			bset TIOS,BIT2
			; Grab the value of the TCNT register
			ldd TCNT
			std TC2
			; Now have 8 msec to set up the system up the interrupts	
			ldaa #BIT2 
			staa TFLG1 ; Clear C2F	
			; Enable OC2 interrupts 
			bset TIE,BIT2
			; Set up output capture action to toggle
			; bit-2 (DDRT does not need to be set)
			bclr TCTL2,OM2          ; Bit 5
			bset TCTL2,OL2          ; Bit 4
			; Clear the count variable
			CLR   count1            ; clear 1 byte
			CLR   count1+1          ; clear another byte
			; Unmask global interrupts
			cli
			
			
			; Wait for the first rising edge on channel 1
spin1:		
			brclr	TFLG1,BIT1,spin1
			
			; Now, get the count that was latched
			ldd	TC1
			std	count1			; save the count in a variable		
			
			; Rest the C1F flag
			ldaa	#BIT1
			staa	TFLG1
			
			; Wait for the next rising edge
spin2:
			brclr	TFLG1,BIT1,spin2
			
			; Get the ending count
			ldd		TC1
			
			; calculate the period
			subd	count1		; subtract the first count
			
			; Now do what you like with the count
			nop
			bra 	spin1
			
; - - - - -
; Interrupt Service Routines Defined here

			; Output Compare, Chanel 2 ISR
			; Generate a square wave on Timer Channel 2
OC2_isr:
			; Set up TC2 for the next interrupt
			ldd 	TC2
			; Add the clock pulses
			addd	#HALF_P
			std		TC2
			; Clear the OC2 flag
			ldaa	#BIT2
			staa	TFLG1
			rti					; return from interrupt (to main code)
			
; ---------------------------------------------------------------          
; Data Section 			Data Section			Data Section
; ---------------------------------------------------------------  			
;Data:		SECTION
;count1:		DS.w	1			

;**************************************************************
;*                 Interrupt Vectors                          *
;**************************************************************
           ORG   $FFFE
           DC.W  Entry           ; Reset Vector

;;*****************************************************************
;;* This stationery serves as the framework for a                 *
;;* user application (single file, absolute assembly application) *
;;* For a more comprehensive program that                         *
;;* demonstrates the more advanced functionality of this          *
;;* processor, please see the demonstration applications          *
;;* located in the examples subdirectory of the                   *
;;* Freescale CodeWarrior for the HC12 Program directory          *
;;*****************************************************************
;
;; export symbols
;            XDEF Entry, _Startup            ; export 'Entry' symbol
;            ABSENTRY Entry        ; for absolute assembly: mark this as application entry point
;
;
;
;; Include derivative-specific definitions 
;		INCLUDE 'derivative.inc' 
;
;ROMStart    EQU  $4000  ; absolute address to place my code/constant data
;
;; variable/data section
;
; ifdef _HCS12_SERIALMON
;            ORG $3FFF - (RAMEnd - RAMStart)
; else
;            ORG RAMStart
; endif
; ; Insert here your data definition.
;Counter     DS.W 1
;FiboRes     DS.W 1
;
;
;; code section
;           ORG   ROMStart
;
;
;Entry:
;_Startup:
;            ; remap the RAM &amp; EEPROM here. See EB386.pdf
; ifdef _HCS12_SERIALMON
;            ; set registers at $0000
;            CLR   $11                  ; INITRG= $0
;            ; set ram to end at $3FFF
;            LDAB  #$39
;            STAB  $10                  ; INITRM= $39
;
;            ; set eeprom to end at $0FFF
;            LDAA  #$9
;            STAA  $12                  ; INITEE= $9
;
;
;            LDS   #$3FFF+1        ; See EB386.pdf, initialize the stack pointer
; else
;            LDS   #RAMEnd+1       ; initialize the stack pointer
; endif
;
;            CLI                     ; enable interrupts
;mainLoop:
;            LDX   #1              ; X contains counter
;couterLoop:
;            STX   Counter         ; update global.
;            BSR   CalcFibo
;            STD   FiboRes         ; store result
;            LDX   Counter
;            INX
;            CPX   #24             ; larger values cause overflow.
;            BNE   couterLoop
;            BRA   mainLoop        ; restart.
;
;CalcFibo:  ; Function to calculate fibonacci numbers. Argument is in X.
;            LDY   #$00            ; second last
;            LDD   #$01            ; last
;            DBEQ  X,FiboDone      ; loop once more (if X was 1, were done already)
;FiboLoop:
;            LEAY  D,Y             ; overwrite second last with new value
;            EXG   D,Y             ; exchange them -> order is correct again
;            DBNE  X,FiboLoop
;FiboDone:
;            RTS                   ; result in D
;
;**************************************************************
;*                 Interrupt Vectors                          *
;**************************************************************
;            ORG   $FFFE
;            DC.W  Entry           ; Reset Vector
