/*	Odd Functions for the FAT16 file system Code	*/

#include <hardwareIF.h>

#include "../MMCard/MMCard.h"
#include "FAT16.h"
#include "FAT16P.h"
#include "FAT16Man.h"
#include "FAT16DirMan.h"
//#include <DeviceManager.h>
#include <string.h>
 
extern struct BootDataType Boot;
extern struct FileDataType File;

uint16	FileNameMatch(uint8	*DirEntry);


/*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>*/ 
/*	Function to check if the FileSystem name is FAT16	
 */
uint16	BootSectorFound(void)
{
uint16	Result = 0;
uint16	i=0;
uint8 *Sector;

	Sector = File.LocalSector;

/*	Check if it is a Boot Sector	*/
	while((Sector[i+FAT16_FileSystemName] !=' ') && (i < 8))
		{Boot.FileSystemName[i] = Sector[FAT16_FileSystemName + i++];}
	Boot.FileSystemName[i]='\0';
	if(strcmp(Boot.FileSystemName, "FAT16") == 0)
		{Result = 1;}
	return Result;
}
/*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>*/ 
/*	Function to load the Boot data structure from the File.LocalSector	
 */
void	LoadBootInfo(void)
{
uint8 *Sector;

	Sector = File.LocalSector;

/*	LOAD	Must Convert from Little Endian to Big Endian	*/
	Boot.BytesPerSector = LittleCharToInt(&Sector[FAT16_BytesPerSector]);
	Boot.SectorsPerCluster = (uint32)Sector[FAT16_SectorsPerCluster];
	Boot.NumCopiesOfFAT = (uint32)Sector[FAT16_NumCopiesOfFAT];
	Boot.MaxRootDirEntries = LittleCharToInt(&Sector[FAT16_MaxRootDirEntries]);
	Boot.NumbOfSectorSmall = LittleCharToInt(&Sector[FAT16_NumbOfSectorSmall]);
	Boot.SectorPerFat = LittleCharToInt(&Sector[FAT16_SectorPerFat]);
		Boot.NumbOfSectorBig = LittleCharToLong(&Sector[FAT16_NumbOfSectorBig]);
	Boot.HiddenSectors = LittleCharToLong(&Sector[FAT16_HiddenSectors]);
/*	COPY	*/
	strncpy(Boot.VolumeName,&Sector[FAT16_VolumeNameStart],11);
/*	CALCULATE	*/
	Boot.RootDirStart = (uint32)Boot.BytesPerSector +  
				((uint32)Boot.NumCopiesOfFAT * (uint32)Boot.SectorPerFat * (uint32)Boot.BytesPerSector) + 
				((uint32)Boot.HiddenSectors * (uint32)Boot.BytesPerSector);
	Boot.RootDirSize =  Boot.MaxRootDirEntries * DIR_ENTRY_SIZE;
	Boot.Cluster2Start = Boot.RootDirStart + Boot.RootDirSize;
	Boot.ClusterSize = Boot.BytesPerSector * Boot.SectorsPerCluster;
}

/*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>*/ 
/*	Function to save the File.LocalSector 
 *	and the Directory data 
 *	This would be used for new files, and ones that have been modified	
 *	This uses the file buffer so after 
 *	execution the file buffer no long contains the open sector.
 *	If needed, it will have to be reloaded, with FileOpenAt, etc
 *
 *	Returns
 *		NoError
 *		
 */
uint16	SaveFileData(void)
{
uint16	ErrorCode = NoError;
uint32	SectAddr;

/*	Save the File.LocalSector at the address specified in the File.StartAddressOfLoaded address	*/
	SectAddr = File.StartAddressOfLoaded;
	ErrorCode = MMCardWriteSector(SectAddr, Boot.BytesPerSector, &File.LocalSector[0]);	

	ErrorCode = StoreFileDirEntry();
	return ErrorCode;
}


/*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>*/ 
uint16	FileNameMatch(uint8	*DirEntry)
{
uint16	Result = 0;
uint16	i = 0;
uint16	x = 0;

	while((File.FileName[i++] == DirEntry[x++]) && (i<8)){
		;}
	i = 0;	
	if(x==8){
		while((File.FileExt[i++] == DirEntry[x++]) && (i<3)){
			}
		}
	if((i == 3) && (x == 11)){
		Result = 1;
		}
	return Result;
}

/*****************************************************************
 *	Function to make a unsigned int that is in 
 *	Little Endian format as chars, to unsigned int
 *****************************************************************/
uint16	LittleCharToInt(uint8 *LittleEndianInt)
{
uint8 LSB,MSB;

	LSB = *LittleEndianInt;
	MSB = *(LittleEndianInt +1);
	return ((MSB <<8) | LSB);
}

/*****************************************************************
 *	Function to make a unsigned int that is in 
 *	Little Endian format as chars, to unsigned int
 *****************************************************************/
unsigned long	LittleCharToLong(char *LittleEndianLong)
{
unsigned long ULong;

	ULong = LittleEndianLong[0];
	ULong += (LittleEndianLong[1] * 0x00000100ul);
	ULong += (LittleEndianLong[2] * 0x00010000ul);
	ULong += (LittleEndianLong[3] * 0x01000000ul);

	return ULong;
}

/*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>*/ 
/*	A function to load the File structure, FileName and FileExt fields with the FileName
 */
void	LoadFileName(uint8 *FileName)
{
uint16	i=0, x=0;

	do{
		File.FileName[i++] = FileName[x++];
		}while((FileName[x] != '.') && (i<8));	/*	Copy bytes	*/

		while(i<8){
			File.FileName[i++] = ' ';			/*	Fill ther rest with spaces	*/
			}
	i=0;
	if(FileName[x] == '.'){
		x++;
		}
	do{
		if(FileName[i] == '\0'){
			File.FileExt[i++] = ' ';
			}
		else{
			File.FileExt[i++] = FileName[x++];
			}
		}while(i<3);
}

/*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>*/ 
/*	A function to get the FileName in 8.3 format from the File structure
 */
void	GetFileName(uint8 *FileName)
{
uint16	i=0,x=0;

	do{
		FileName[x++] = File.FileName[i++];
		}while((FileName[x] != ' ') && (i<8));	/*	Copy bytes	*/
	i=0;
	FileName[x++] = '.';
	while((FileName[x] != ' ') && (i<3)){
		FileName[x++] = File.FileExt[i++];
		}
}

/*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>*/ 
/*	A function to return the sata of the file system	*/
uint16	FileOpenOK(void)
{
uint16	Result = 0;
	Result = (File.Flags & OPENED_OK);
	return Result;
}

/*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>*/ 
/*	A function to load another sector of the open file	*/
uint16	LoadFileAt(uint32 *FilePtr)
{
uint16	ErrorCode = NoError;
uint16	ClusterNum = 0;
uint32	SectAddr = 0;

	ErrorCode = FindFileCluster(*FilePtr, &SectAddr, &ClusterNum);		/*	Function follows the FAT trail..		*/
	if(!ErrorCode){
		ErrorCode = MMCardReadSector(SectAddr, Boot.BytesPerSector, File.LocalSector);
		File.StartAddressOfLoaded = SectAddr;
		File.ClusterLoaded = ClusterNum;
		}
	if(File.LocalSector[0] != 0){
		SectAddr = 0;
	}
	return ErrorCode;
}

/*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>*/
/*	This function finds the directory entry for this 
 *	file and stores the file dir data
 */
uint16	StoreFileDirEntry(void)
{
uint16	ErrorCode = NoError;
uint16	DirSectCount = 0;
uint32	SectAddr;
uint16	i,x;
uint16	DirEntryCount;

/*	Get the sector of the directory entry for this file	*/
	do{	/*	Look into the sector	*/
		DirEntryCount = 0;
		SectAddr = Boot.RootDirStart + ((uint32)DirSectCount * (uint32)Boot.BytesPerSector);
		ErrorCode = MMCardReadSector(SectAddr, Boot.BytesPerSector, &File.LocalSector[0]);
		if(!ErrorCode){	
			i = 0;
			x = 0;
    		do{	/*	Look into the directory entry	*/
    			if(FileNameMatch(&File.LocalSector[(DirEntryCount * 32)])){
					ErrorCode = FOUND_ENTRY;	
					}
    			else{															
    				if(File.LocalSector[(DirEntryCount * 32)] == 0x00){			/*	Check if the first byte of the entry 	*/
    					ErrorCode = NO_FURTHER_ENTRIES;							/*	is the no-more-entries-marker			*/
    					}
    				DirEntryCount++;											/*	If not found, then point to the next	*/
    				}
	   			}while(!ErrorCode && (DirEntryCount < (Boot.BytesPerSector/DIR_ENTRY_SIZE)));
			DirSectCount++;
			}
		}while(!ErrorCode && (DirSectCount < Boot.RootDirSize));				/*	Do all of this while there is no result	*/
	if(ErrorCode == FOUND_ENTRY){
		StoreDirEntry(DirEntryCount);
		/*	now write that data to the card	*/
		ErrorCode = MMCardWriteSector(SectAddr, Boot.BytesPerSector, File.LocalSector);	
		}

	return ErrorCode;
}
