/*	Private functions for internal use of MMCard module	*/

#include "hardwareIF.h"
#include "MMCardP.h"

//#define MMCMDTimeOut	0x0020
//#define ReadDataTimeOut	0x2000
//#define ReadTimeOut 	0x0300
//#define WriteTimeOut	0xfff0

uint16	MMCMDTimeOut	= 0x0020;
uint16	ReadDataTimeOut	= 0x2000;
uint16	ReadTimeOut 	= 0x0300;
uint16	WriteTimeOut	= 0xfff0;


extern struct MMCARDType Card;
uint16	MMCardMemCMD(uint16 Command, uint32 *StartAdd);
struct CIDregister *CIDstruct;

/******************************************************
 *	Function to get MMCard talking properly.
 *	It seems that it is necessary to reset the card 
 *	if left alone for a while.
 ******************************************************/
uint16		MMCard_InitComs(void)
{
uint16 	ErrorCode = NoError;
uint16 	TimeOut = 0;
uint16	i;

	do{	/*	Send CMD0 then get a response of 0x01, then send CMD1 till it becomes 0x00	*/
		ResetMMCARD();
		ErrorCode = CMDMMCARD(GO_IDLE_STATE, 0x01);	/*	Send the CMD0 so that device initializes	*/
		if(ErrorCode == 0x0000){			/*	then the response was 0x01, so card is OK but busy*/
			i = 0;
			do{
				ErrorCode = CMDMMCARD(SEND_OP_COND, 0x00);
				i=10;
			}while((ErrorCode == (CMD1_Error | 0x0001)) && (i++ < 500));
		}						/*	Else check the timeout 			*/ 
		TimeOut++;					/*	and loop around and send the CMD0 again.*/
	}while(ErrorCode && TimeOut<=500);

	if(ErrorCode){						/*	If it end the above with a timeout 	*/
		Card.Flags = 0;					/*	then there must be an errorcode		*/
	}							/*	Then clear the flags....		*/
	else{
		Card.Flags BitOn CardIdle;
	}
	return ErrorCode;
}

/******************************************************
 *	Function to reset the MMCard 
 *	It seems that it is necessary to reset the card 
 *	if left alone for a while.
 ******************************************************/
void	ResetMMCARD(void)
{
sint16	i;
uint8 c;
/*	Send 10 SPI bytes to the SPI System and so the Card,
 *	Without ASSERTing the CS. Odd but necessary	*/
	for(i=0; i<=12; i++){
		c = SendGetMMCardSPI(0xff);
	}
}

/*****************************************************
 *****************************************************/
uint16		CMDMMCARD(uint16 CMD, uint8 ValidResponse)
{
sint16	ErrorCode = NoError;
sint16 	i=0;
uint8 Response;

/*	I don't know when the the response can come, 
 *	so check the response each transfer	*/
 	ASSERT_MMCard_CS;					/*	Start talking to the card		*/
	Response = SendGetMMCardSPI(CMD);			/*	send command				*/
	Response = SendGetMMCardSPIWord(0x0000);		/*	Args or Dummies for padding		*/
	Response = SendGetMMCardSPIWord(0x0000);		/*	Must be a 6 byte command sequence	*/
	Response = SendGetMMCardSPI(CMD0_CRC);			/*	CRC may or may not be required here	*/

	while((Response == 0xff) && (i <= MMCMDTimeOut)){	/*	Poll for the response R1 != 0xff	*/
		Response = SendGetMMCardSPI(0xff);		/*	As the response 0xff is 		*/
		i++;						/*	no response at all			*/
	}
	DEASSERT_MMCard_CS;
								/*	Now we may have a real response to check...	*/
	if(i>=MMCMDTimeOut){					/*	If it was a time out then error		*/
		ErrorCode = CMD_TimeOut | CMD;
		}
	if(Response != ValidResponse){				/*	Note erroneous response		*/
		ErrorCode = (CMD<<8) | Response;
	}							/*	Else it is the right response	*/
/*DEBUG CODE*/	
	if(Response == 0x80){	/*	Just a test to try and solve this problem	*/
		ErrorCode = NoError;
	}
	if(Response == 0xE0){	/*	Just a test to try and solve this problem	*/
		ErrorCode = NoError;
	}
/*END DEBUG CODE*/	
	

	Response = SendGetMMCardSPI(0xff);			/*	8 clocks for card to finish	*/
	return ErrorCode;
}

/******************************************************
 *	Function to read the CSD and CID form the MMCard
 *****************************************************/
uint16		MMCardReadCardData(uint8 CMD)
{
uint8 Response;
sint16 i=0;
sint16 ErrorCode = NoError;

/*	Select the card and send the SEND_CID or SEND_CSD byte
 */
	Response = SendGetMMCardSPI (0xff);		/*	A couple of clocks to fix it! (of what??)*/
	ASSERT_MMCard_CS;
	Response = SendGetMMCardSPI(CMD);		/*	 command	*/
	Response = SendGetMMCardSPIWord(0x0000u);	/*	Args or Dummies for padding	*/
	Response = SendGetMMCardSPIWord(0x0000u);
	Response = SendGetMMCardSPI(0xff);		/*	CRC may be required here	*/
							/*	Poll for the response R1 != 0xff	*/
	while((Response == 0xff) && (i <= MMCMDTimeOut)){
		Response = SendGetMMCardSPI(0xff);
		i++;
	}
	if(i >= MMCMDTimeOut){				/*	This is a time out, report Error	*/
		ErrorCode = ReadData_CMDTimeOut;
	}
	if(Response != 0x00){
		ErrorCode = ReadData_Error | Response; 
	}
/*	If this returns a response of 0x00 then OK else..?.*/
	if(!ErrorCode){
/*	Need to wait for a 0xfe Start Byte and then save the next 16 bytes	*/
		i=0;							/*	Reset counter	*/
		while((Response != 0xfe) && (i <= ReadDataTimeOut)){
			Response = SendGetMMCardSPI(0xff);
			i++;
		}
		if(i >= ReadDataTimeOut){/*	This is a time out, report Error	*/
			ErrorCode = ReadData_DataTimeOut;
		}
		else{/*	Now get the 16 bytes and store in structure	*/
			switch(CMD){
				case SEND_CSD:{
					for(i = 0; i<=16; i++){
						Card.CSD[i] = SendGetMMCardSPI(0xff);
					}
					break;
				}										
				case SEND_CID:{
					for(i = 0; i<=16; i++){
						Card.CID[i] = SendGetMMCardSPI(0xff);
					}
					CIDstruct = (struct CIDregister*)Card.CID;
					break;
				}
			}										
			Response = SendGetMMCardSPIWord(0xffffu);
		}		
	}
	DEASSERT_MMCard_CS;
	Response = SendGetMMCardSPI(0xff);	/*	8 clocks for card to finish	*/

	return ErrorCode;
}

/******************************************************
 *	Function to read the data from the flash card
 *	and returns data to the DataString array
 *****************************************************/
uint16		MMCardReadCardMem(uint32 StartAdd, uint16 Length, uint8 *DataString)
{
uint16 ErrorCode = NoError;
uint8 Response;
uint16 i;
//uint16	Delay;
uint16	AddressHW;
uint16	AddressLW;

	if(Card.Flags & CardOK){
		ErrorCode = MMCard_InitComs(); /*The 64 MB SD card works with, the 32MB Sd card works without!	*/
   		AddressHW = StartAdd >> 16;				/*	Setup a read data command 		*/
   		AddressLW = StartAdd;					/*	by writing the command and 		*/
//    		Response = SendGetMMCardSPI(0xff);			/*	A couple of clocks to fix it!		*/
//    		Response = SendGetMMCardSPI(0xff);			/*	A couple of clocks to fix it!		*/
//    		Response = SendGetMMCardSPI(0xff);			/*	A couple of clocks to fix it!		*/
   		ASSERT_MMCard_CS;					/*	start address 				*/
   		Response = SendGetMMCardSPI(READ_SINGLE_BLOCK);		/*	command					*/
   		Response = SendGetMMCardSPIWord(AddressHW);		/*	High Word of the address		*/
   		Response = SendGetMMCardSPIWord(AddressLW);		/*	Low Word of the address			*/
   		Response = SendGetMMCardSPI(0xff);			/*	CRC Not required here			*/
   		i=0;							/*	Poll for the response R1 != 0xff	*/
   		while((Response == 0xff) && (i <= MMCMDTimeOut)){	/*	Do this a set number of times to guard against	*/
   			Response = SendGetMMCardSPI(0xff); i++;		/*	locking up if no/faulty card		*/
		}
   		if(i >= MMCMDTimeOut){
   			ErrorCode = ReadMem_CMDTimeOut;			/*	This is a time out, report Error	*/
		}
		else{
			if(Response != 0x00){					/*	If this returns a response of 0x00 then OK else..?.*/	
				ErrorCode = ReadMem_Error | Response;		/*	Flag error and pass Response as part of the errorcode	*/
			}
		}

		if(!ErrorCode){	
			ASSERT_MMCard_CS;
			i=0;
			while((Response != 0xfe) && (i <= ReadTimeOut)){/*	Need to wait for a 0xfe Start Byte */
				Response = SendGetMMCardSPI(0xff);
				i++;
//				Delay = 2;
//				MMCardDelay(Delay);			/*	Insert a small delay here	*/
			}
			if(i >= ReadTimeOut){
				ErrorCode = ReadMem_DataTimeOut;	/*	This is a time out, report Error*/
			}
			else{						/*	Setup a loop to read the data required*/
				for(i=0; i<Length; i++){
					Response = SendGetMMCardSPI(0xff);
					DataString[i] = Response;
				}
				Response = SendGetMMCardSPI(0xff);	/*	8 clocks for card to finish		*/
			}
		}/*endif (!ErrorCode) */
		DEASSERT_MMCard_CS;
		Response = SendGetMMCardSPI(0xff);			/*	8 clocks for card to finish	*/
	}
	else{
		ErrorCode = FaultFlashCard;
	}
	return ErrorCode;
}

/******************************************************
 *	Function to write data to the flash card
 *	from the DataString for Length bytes
 *
 *	Can only write sectors(Blocks) at a time
 *	So use the passed Sector sized array
 *	And write that to the Card
 *****************************************************/

uint16		MMCardWriteCardMem(uint32 StartAdd,uint16 Length, uint8 *DataString)
{
sint16 ErrorCode = NoError,c;
uint16 AddressHW,AddressLW, i;
uint8 Response;

	if(Card.Flags & CardOK){
//		ErrorCode = MMCard_InitComs();
    	AddressHW = StartAdd >> 16;
    	AddressLW = StartAdd;
    	ASSERT_MMCard_CS;		/*	Setup a read data command by writing the command and start address */
    	Response = SendGetMMCardSPI(0xff);		/*	A couple of clocks to fix it!	*/
    	Response = SendGetMMCardSPI(WRITE_BLOCK);	/*	 command			*/
    	Response = SendGetMMCardSPIWord(AddressHW);	/*	High Word of the address	*/
    	Response = SendGetMMCardSPIWord(AddressLW);	/*	Low Word of the address		*/
    	Response = SendGetMMCardSPI (0xff);		/*	CRC Not required here		*/
		/*	Poll for the response R1 != 0xff
		*	Do this a set number of times to guard against
		*	locking up if no/faulty card			*/
    	Response = 0xff;
    	i=0;	/*	Reset counter	*/
    	while((Response == 0xff) && (i <= MMCMDTimeOut)){/*	Send Dummy to receive response byte	*/
    		Response = SendGetMMCardSPI(0xff);
    		i++;
    	}
    	if(i >= MMCMDTimeOut){				/*	This is a time out, report Error	*/
    		ErrorCode = WriteMem_CMDTimeOut;
    	}
    	else{
			if(Response != 0x00){
				ErrorCode = WriteMem_Error | Response ;
			}
    	}
		/*	If this returns a response of 0x00 then OK else..?.*/
		if(!ErrorCode){	/*	Send a byte as a delay then, Send 0xfe and the data block, 
						*	a two dummy CRC and then poll for the data reponse	
						*	if the data response is OK then wait until the end of the BUSY state before exiting	*/ 
			Response = SendGetMMCardSPI(0xff);
			Response = SendGetMMCardSPI(0xfe);
			for(i=0; i<=Length; i++){
				Response = SendGetMMCardSPI(DataString[i]);
			}
			/*	Now Poll for a Response != 0xff		*/
			i=0;							/*	Reset counter	*/
			Response = 0xff;
			while((Response == 0xff) && (i <= MMCMDTimeOut)){	/*	Send Dummy to receive response byte,*/
				Response = SendGetMMCardSPI(0xff);		/*the first 2 would be seen as the CRC byte	*/
				i++;
			}
			if(i >= MMCMDTimeOut){/*	This is a time out, report Error	*/
				ErrorCode = WriteMem_DataTimeOut;
			}
			else{
				/*	Check that the last response was a Data Response OK i.e. xxx0 0101 = OK xxx0 1011 = Not OK	*/
				if((Response & 0x1f) == 0x05){
					Response = 0x00;
					while((Response == 0x00) && (i <= WriteTimeOut)){	/*Now wait for the end of the Busy signal	*/
						Response = SendGetMMCardSPI(0xff);			
					}
				}
				else{
					ErrorCode = WriteMem_DataRejected;
				}
			}
		}
		DEASSERT_MMCard_CS;
		c = SendGetMMCardSPI(0xff);	/*	8 clocks for card to finish	*/
	}
	else{
		ErrorCode = FaultFlashCard;
	}
	return ErrorCode;
}

/*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>*/ 
/*	A function to Extract data from the CSD register string;	
 */
uint16	CSDataValue(uint16 FieldName)
{
uint16	ErrorCode = NoError;

	ErrorCode = FieldName;
	return ErrorCode;
}

/*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>*/ 
/*	A function to send a command to the card 	
 *	Returns ErrorCodes, 
 */
uint16	MMCardMemCMD(uint16 Command, uint32 *StartAdd)
{
uint16	ErrorCode = NoError;
uint16	i =0;
uint16	AddressHW;
uint16	AddressLW;
uint16	Response;
uint16	Trys = 0;
#define MaxTrys 3

	if(Card.Flags & CardOK){
		do{
			i = 0;
			ErrorCode = NoError;
			AddressHW = (uint8)(*StartAdd >> 16);			/*	Setup the address of the read or write	*/
			AddressLW = (uint8)(*StartAdd);				/*				 	*/
			Response = SendGetMMCardSPI(0xff);			/*	A couple of clocks to fix it!	*/
			
			ASSERT_MMCard_CS;					/*		 			*/
			Response = SendGetMMCardSPI(Command);			/*	command				*/
			Response = SendGetMMCardSPIWord(AddressHW);		/*	High Word of the address	*/
			Response = SendGetMMCardSPIWord(AddressLW);		/*	Low Word of the address		*/
			Response = SendGetMMCardSPI(0xff);			/*	CRC Not required here		*/
			i++;							/*	Poll for the response R1 != 0xff*/
			while((Response == 0xff) && (i <= MMCMDTimeOut)){	/*	Do this a set number of times to guard against	*/
				Response = SendGetMMCardSPI(0xff);
				i++;						/*	locking up if no/faulty card	*/
			}
			if(i >= MMCMDTimeOut){
				ErrorCode = ReadMem_CMDTimeOut;			/*	This is a time out, report Error	*/
				if(Trys < MaxTrys){				/*	If we haven't tried enough go again	*/
					ErrorCode = MMCard_InitComs();		/*	and reinit comms			*/
					Trys++;
				}
			}
		}while(ErrorCode && (Trys<3));
		DEASSERT_MMCard_CS;
		if(Response != 0x00){						/*	If this returns a response of 0x00 then OK else..?.*/	
			ErrorCode = ReadMem_Error | Response;	/*	Flag error and pass Response as part of the errorcode	*/
		}
	}
	else{
		ErrorCode = MMCardNotReady;
	}
	return ErrorCode;
}




