/* Sample project for the 9S12C32 32-pin DIP module from Technological Arts.
   The docking board for this DIP has 2 LED's connected to the 2
   least-significant bits of port T. This project will cause those
   2 LEDs to begin counting in binary. You must use a custom vector
   table to tell the chip what to do when it gets reset. The file vectors.s
   is used for this purpose. */
   
#include  <stdio.h>
#include  <string.h>
#include  "9s12c32.h"

int	  main(void);
void      delay(void);

unsigned short int  speed = 0xffff;

unsigned short int        start = 0x0000;
unsigned short int        end   = 0xffff;

int main()
{
    unsigned short int n;

    COPCTL = 0x08; /* disable COP watchdog timer */
    DDRT = 0xff; /* make all bits of port T outputs */

    while (1)
    {
        for (n = start; n < end; n++)
        {
          PORTT = n & 0x03;  /* send the 2 low order bits to port T */
          delay();
          delay();
        }
    }
    return  0; /* not used */
}

void delay()
{
  unsigned short int i;

  for (i = 0; i < speed; i++)
  {
     /* nothing */
  }
}


