// Filename: isr.c  ****************************************************
//
//

#include <9s12c32.h>
#include "isr.h"

static unsigned short TC6Delay;    // the delay used to reset TC6
static unsigned short TC6Count=0;  // interrupt counter for TC6
static unsigned short TC6Start=0;

// initialize TOC3 interrupts every
void TC6Init(WORD delay, WORD count){
  unsigned short n=0;
  DISABLE_INTERRUPTS;           // DO NOT INTERRUPT INIT ROUTINE
  TC6Delay=delay;
  TC6Count=count;
  TC6Start = count;
  TIOS |= bit(6);               // activate TC6 as output compare
  TIE  |= bit(6);               // arm TC6
  TC6   = TCNT + TC6Delay;      // Interrupt after delay counts
  ENABLE_INTERRUPTS;
}

// Interrupt Service Routine for TOC6
ISR TC6Isr(void){
    TFLG1 = bit(6);              // acknowledge interrupt from OC6
    TC3 += TC6Delay;             // Set new interrupt interval
    
    // Replace line below with your own routine
    //SCI_OutString (" 6 ");     // message to say we are here

    if (--TC6Count == 0 ){
       TC6Count = TC6Start;     // reset counter when it hits 0
       PORTT ^= bit(6);         // Toggle bit 6

    }
}

// initialize RTI interrupts every 4096us
void RTIInit(BYTE scale){
  DISABLE_INTERRUPTS;     // DO NOT INTERRUPT INIT ROUTINE
  CRGINT = bit(7);        // enable RTI
  RTICTL = scale;         // freq = 4MHz / 2^(RTICTL(6:4)) * 1024 / (RTICTL(3:0)+1)
                          // Note: (RTICTL(6:4) = 0 turns interrupts off
  ENABLE_INTERRUPTS;
}

// Interrupt Service Routine for RTI
ISR RTIIsr(){
   CRGFLG = 0x80;                 // acknowledge RTI

   // *************************
   // add your RTI routine here
   // *************************
   //PORTT ^=bit(7)+bit(5);
}


