/*
*********************************************************************************************************
*                                                uC/OS-II
*                                          The Real-Time Kernel
*
*                        (c) Copyright 1992-1998, Jean J. Labrosse, Plantation, FL
*                                           All Rights Reserved
*
*                                           Master Include File
*
* File : INCLUDES.H
* By   : Jean J. Labrosse
*
* Compiler Port : ICC12 V5.0
* Version       : 1.00
* By            : Andrew Bonneville
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                         PROCESSOR SPECIFICS
*********************************************************************************************************
*/

#define  CPU_FRT_FREQ         500000L       /* Free Running Timer rate (Hz)                            */

#define  OS_TICK_OC                 7       /* Output compare # used to generate a tick int.           */

                                            /* Number of FRT counts to produce an interrupt @tick rate */
#define  OS_TICK_OC_CNTS  (CPU_FRT_FREQ / OS_TICKS_PER_SEC)
//#define OS_TICK_OC_CNTS 5000
/*
*********************************************************************************************************
*                                           FILES TO INCLUDE
*********************************************************************************************************
*/

#include  <hc12.h>
#include  <stddef.h>
#include  "OS_CFG.H"
#include  "OS_CPU.H"

#include  "uCOS_II.H"
