/*
*********************************************************************************************************
*                                               uC/OS-II
*                                        The Real-Time Kernel
*
*                        (c) Copyright 1992-1998, Jean J. Labrosse, Plantation, FL
*                                          All Rights Reserved
*
*                                         M68HC12 Specific code
*                                            (COSMIC C V4.2F)
*
* File         : OS_CPU.H
* By           : Jean J. Labrosse
* Port Version : V1.01
*
* Compiler Port : ICC12 V5.0
* Version       : 1.00
* By            : Andrew Bonneville
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                              DATA TYPES
*********************************************************************************************************
*/

typedef unsigned char  BOOLEAN;
typedef unsigned char  INT8U;                    /* Unsigned  8 bit quantity                           */
typedef signed   char  INT8S;                    /* Signed    8 bit quantity                           */
typedef unsigned int   INT16U;                   /* Unsigned 16 bit quantity                           */
typedef signed   int   INT16S;                   /* Signed   16 bit quantity                           */
typedef unsigned long  INT32U;                   /* Unsigned 32 bit quantity                           */
typedef signed   long  INT32S;                   /* Signed   32 bit quantity                           */
typedef float          FP32;                     /* Single precision floating point                    */
typedef double         FP64;                     /* Double precision floating point                    */

#define BYTE           INT8S                     /* Define data types for backward compatibility ...   */
#define UBYTE          INT8U                     /* ... to uC/OS V1.xx                                 */
#define WORD           INT16S
#define UWORD          INT16U
#define LONG           INT32S
#define ULONG          INT32U

typedef unsigned char  OS_STK;                   /* Each stack entry is 8-bit wide                     */

/*
*********************************************************************************************************
*                                              CONSTANTS
*********************************************************************************************************
*/

#ifndef  FALSE
#define  FALSE    0
#endif

#ifndef  TRUE
#define  TRUE     1
#endif

/*
*********************************************************************************************************
*                                           Motorola 68HC12
*
* Method #1:  Disable/Enable interrupts using simple instructions.  After critical section, interrupts
*             will be enabled even if they were disabled before entering the critical section.
*
* Method #2:  Disable/Enable interrupts by preserving the state of interrupts.  In other words, if
*             interrupts were disabled before entering the critical section, they will be disabled when
*             leaving the critical section.
*
* NOTE(s)  :  The current version of the compiler does NOT allow method #2 to be used without changing
*             the processor independent portion of uC/OS-II.
*********************************************************************************************************
*/
#define  OS_CRITICAL_METHOD    1

#if      OS_CRITICAL_METHOD == 1
#define  OS_ENTER_CRITICAL()  asm("  sei\n")
#define  OS_EXIT_CRITICAL()   asm("  cli\n")
#endif

#if      OS_CRITICAL_METHOD == 2
#define  OS_ENTER_CRITICAL()  asm("  pshc\n  sei\n")
#define  OS_EXIT_CRITICAL()   asm("  pulc\n")
#endif


#define  OS_TASK_SW()         asm("  swi\n")

#define  OS_STK_GROWTH        1                  /* Define stack growth: 1 = Down, 0 = Up              */

#define  CPU_INT_DIS()        asm("  sei\n")    /* Disable interrupts                                 */
#define  CPU_INT_EN()         asm("  cli\n")    /* Enable  interrupts                                 */
