/*
*********************************************************************************************************
*                                               uC/OS-II
*                                         The Real-Time Kernel
*
*                         (c) Copyright 1998, Jean J. Labrosse, Plantation, FL
*                                          All Rights Reserved
*
*
*                                    68HC812 INTERRUPT VECTOR TABLE
*
* File : VECTORS.C
* By   : Jean J. Labrosse
*
* Compiler Port : ICC12 V5.0
* Version       : 1.00
* By            : Andrew Bonneville
*********************************************************************************************************
*/

#include "INCLUDES.H"

/*
*********************************************************************************************************
*                                              MC68HC812
*                                         INTERRUPT VECTOR TABLE
*
* Description: This is the interrupt vector table used by the MC68HC812 CPU.  Note that unused
*              interrupts are vectored to NULL.
* Notes      : 1) You MUST define the vector that defines the address of your startup code.
*********************************************************************************************************
*/
/* System interrupt handlers, not application specific */
extern void _start(void);   /* entry point in crt??.s */
extern void OSTickISR ();
extern void OSCtxSw ();

/* Application specific interrupt handlers */


/* 812A4 vectors starts at 0xff80, but most entries are not used
   if you use Key Wakeup H, change the start address to 0xffCE and
   add one entry to the beginning
 */
#pragma abs_address:0xffd0                  /* Interrupt vector table start address */
                                            /* MCU: 812A4,912B32 */
void (* const OSVectorTbl[])(void) = {      /* This table begins at 0xFF80                             */
//    (void (*)())NULL,                       /* 0xFFCE Key Wakeup H, reserved                                     */

    (void (*)())NULL,                       /* 0xFFD0 Key Wakeup J, BDLC                                     */
    (void (*)())NULL,                       /* 0xFFD2 ATD                                              */
    (void (*)())NULL,                       /* 0xFFD4 SCI 1, reserved                                            */
    (void (*)())NULL,                       /* 0xFFD6 SCI 0                                            */
    (void (*)())NULL,                       /* 0xFFD8 SPI Serial Transfer Complete                     */
    (void (*)())NULL,                       /* 0xFFDA Pulse Accumulator Input Edge                     */
    (void (*)())NULL,                       /* 0xFFDC Pulse Accumulator Overflow                       */
    (void (*)())NULL,                       /* 0xFFDE Timer Overflow                                   */

#if OS_TICK_OC == 7
    (void (*)())OSTickISR,                  /* 0xFFE0 Timer Channel 7                                  */
#else
    (void (*)())NULL,                       /* 0xFFE0 Timer Channel 7                                  */
#endif

#if OS_TICK_OC == 6
    (void (*)())OSTickISR,                  /* 0xFFE2 Timer Channel 6                                  */
#else
    (void (*)())NULL,                       /* 0xFFE2 Timer Channel 6                                  */
#endif

#if OS_TICK_OC == 5
    (void (*)())OSTickISR,                  /* 0xFFE4 Timer Channel 5                                  */
#else
    (void (*)())NULL,                       /* 0xFFE4 Timer Channel 5                                  */
#endif

#if OS_TICK_OC == 4
    (void (*)())OSTickISR,                  /* 0xFFE6 Timer Channel 4                                  */
#else
    (void (*)())NULL,                       /* 0xFFE6 Timer Channel 4                                  */
#endif

#if OS_TICK_OC == 3
    (void (*)())OSTickISR,                  /* 0xFFE8 Timer Channel 3                                  */
#else
    (void (*)())NULL,                       /* 0xFFE8 Timer Channel 3                                  */
#endif

#if OS_TICK_OC == 2
    (void (*)())OSTickISR,                  /* 0xFFEA Timer Channel 2                                  */
#else
    (void (*)())NULL,                       /* 0xFFEA Timer Channel 2                                  */
#endif

#if OS_TICK_OC == 1
    (void (*)())OSTickISR,                  /* 0xFFEA Timer Channel 1                                  */
#else
    (void (*)())NULL,                       /* 0xFFEA Timer Channel 1                                  */
#endif

#if OS_TICK_OC == 0
    (void (*)())OSTickISR,                  /* 0xFFEA Timer Channel 0                                  */
#else
    (void (*)())NULL,                       /* 0xFFEA Timer Channel 0                                  */
#endif

    (void (*)())NULL,                       /* 0xFFF0 Real Time Interrupt (RTI)                        */

    (void (*)())NULL,                       /* 0xFFF2 IRQ (External Pin) or Key Wakeup D               */

    (void (*)())NULL,                       /* 0xFFF4 XIRQ Pin (Pseudo Nonmaskable Interrupt)          */

    (void (*)())OSCtxSw,                    /* 0xFFF6 SWI                                              */

    (void (*)())NULL,                       /* 0xFFF8 Illegal Opcode Trap                              */

    (void (*)())NULL,                       /* 0xFFFA COP Failure (Reset)                              */

    (void (*)())NULL,                       /* 0xFFFC COP Clock Monitor Fail (Reset)                   */

    _start                                  /* 0xFFFE RESET                                            */
};
#pragma end_abs_address
