
;********************************************************************************************************
;                                          PUBLIC DECLARATIONS
;********************************************************************************************************
    .globl _PseudoVectorTbl

;********************************************************************************************************
;                                         EXTERNAL DECLARATIONS
;********************************************************************************************************

; extern void _OSTickISR ();
; extern void _OSCtxSw ();


;/**********************************************************************************************
; *                                  PseudoVectorTbl
; * Description: Setup pseudo interrupt vector table, used by TwinPeeks (v1.3c) monitor.
; *
; * Arguments:   none
; *
; * Returns:     Pseudo interrupt vector table created at 0xBB8 - 0xC00
; *
; * Note(s):     Source code must orginate at 0x8000 out of reset, or jump from 8000 to RAM.
; ***********************************************************************************************
; */

 _PseudoVectorTbl:

    ldaa    #$06            ;JMP opcode
    staa    $0BB8           ;Pseudo vector
    ldd     #_INULL               ;KWUH
    std    $0BB9           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BBB           ;Pseudo vector
    ldd     #_INULL               ;KWUJ
    std    $0BBC           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BBE           ;Pseudo vector
    ldd     #_INULL               ;ATD
    std    $0BBF           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BC1           ;Pseudo vector
    ldd     #_INULL               ;SCI1
    std    $0BC2           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BC4           ;Pseudo vector
    ldd     #_INULL               ;SCI0
    std    $0BC5           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BC7           ;Pseudo vector
    ldd     #_INULL               ;SPI
    std    $0BC8           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BCA           ;Pseudo vector
    ldd     #_INULL               ;Pulse Accu Input Edge
    std    $0BCB           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BCD           ;Pseudo vector
    ldd     #_INULL               ;Pulse Accu Overflow
    std    $0BCE           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BD0           ;Pseudo vector
    ldd     #_INULL               ;Timer Overflow
    std    $0BD1           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BD3           ;Pseudo vector
    ldd     #_OSTickISR     ;TC7, uCOS system tick
    std    $0BD4           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BD6           ;Pseudo vector
    ldd     #_INULL               ;TC6
    std    $0BD7           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BD9           ;Pseudo vector
    ldd     #_INULL               ;TC5
    std    $0BDA           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BDC           ;Pseudo vector
    ldd     #_INULL               ;TC4
    std    $0BDD           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BDF           ;Pseudo vector
    ldd     #_INULL               ;TC3
    std    $0BE0           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BE2           ;Pseudo vector
    ldd     #_INULL               ;TC2
    std    $0BE3           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BE5           ;Pseudo vector
    ldd     #_INULL               ;TC1
    std    $0BE6           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BE8           ;Pseudo vector
    ldd     #_INULL               ;TC0
    std    $0BE9           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BEB           ;Pseudo vector
    ldd     #_INULL               ;RTI
    std    $0BEC           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BEE           ;IRQ
    ldd     #_INULL               ;
    std    $0BEF           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BF1           ;Pseudo vector
    ldd     #_INULL               ;XIRQ
    std    $0BF2           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BF4           ;Pseudo vector
    ldd     #_OSCtxSw       ;SWI
    std    $0BF5           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BF7           ;Pseudo vector
    ldd     #_INULL               ;Illegal Opcode
    std    $0BF8           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BFA           ;Pseudo vector
    ldd     #_INULL               ;Cop Fail
    std    $0BFB           ;

    ldaa    #$06            ;JMP opcode
    staa    $0BFD           ;Clock Monitor Fail
    ldd     #_INULL               ;
    std    $0BFE           ;

;    /* Reset vector controlled by TwinPeeks */

    rts

;/**********************************************************************************************
; *
; * Description:
; *
; * Arguments:
; *
; * Returns:
; *
; * Note(s):
; ***********************************************************************************************
; */

 _INULL:
    jmp     _INULL      ;Loop forever
