;AUDIO.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.		DESCRIPTION
*
*January 29, 2001	V1.02			MIB test Routine
*
*Author: Exequiel A. Rarama
********************************************************************************
;
;Port A, OC4 is used to drive the speaker. The port pin is toggled on compare.
;
; ---------------------------
;       Audio Routines
; ---------------------------

	INCLUDE REG.INC                 ;register block starting address
	INCLUDE REGS.INC                ;register block addresses
	INCLUDE SYS.MAC

; Public Routines - These routines will be called externally
        
	PUBLIC	audio_int
	PUBLIC	audio_init
	PUBLIC	set_audio
	PUBLIC	check_audio
	PUBLIC	tn_power

; Public Variables - This variable will be used externally

	PUBLIC	audio_timer

        PAGE0

audio_period	ds	2               ;audio tone period
audio_timer	ds	1               ;audio tone duration timer
audio_ptr	ds	2               ;pointer to audio tone table

        CODE

audio_init
	ldaa	#00010000b              ;enable output compare
	staa	_TMSK1,x                ; 4 (audio) interrupts
	staa	_TFLG1,x                

	ldx     #tn_power               ;power on tone
	jsr     set_audio

	rts

;-----------
check_audio
	ldaa    audio_timer             ;exit if duration not counted down
	bne     audex                   ;  or infinite duration (FFH)
	ldx     audio_ptr

set_audio
	ldaa	0,x                     ; timer values
	staa	audio_timer
	ldd	1,x                     ;get next period value
	std	audio_period            ;set new audio tone period & duration
	beq	aud10                   ;  audio is off (=0)

	ldaa	#00000100b		;Toggle Port
	bra	aud20

aud10
	ldaa	#00001000b              ;Set Port to Zero

aud20
	pshx
	ldx	#REG                    ;base address 1000h
	staa	_TCTL1,x
	pulx

	inx                             ;increment and save audio table
	inx                             ;  pointer
	inx
	stx     audio_ptr

audex
	rts

;------------------------
; Audio Interrupt Routine
; -----------------------

audio_int
	ldx	#REG                    ;base address 1000h
	ldd	audio_period
	addd	_TOC4,x
	std	_TOC4,x
	ldaa	#00010000B
	staa	_TFLG1,x                ;clear flag
	rti

;power up tones
tn_power
	db	2,1,0, 2,1,64, 2,1,128, 2,1,192, 2,2,0, 2,2,64, 2,2,128
	db	2,2,192, 2,3,0, 2,3,64, 2,3,128, 2,3,196, 2,4,0
	db	-1,0,0

tn_s
	db	10,40,0, 40,48,0, 30,19,0
	db	-1,0,0


	END
