;DS1307.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.		DESCRIPTION
*
*January 29, 2001	V1.02			MIB test Routine
*
*Author: Exequiel A. Rarama
********************************************************************************

	INCLUDE REG.INC                 ;register block starting address
	INCLUDE REGS.INC                ;register block addresses
	INCLUDE SYS.MAC                 ;system macros

; Public Routines
	PUBLIC	SetTIME
	PUBLIC	Get_Time
	PUBLIC	OutByte
	PUBLIC	InByte

; Public Variables
	PUBLIC	second
	PUBLIC	minute
	PUBLIC	hour

; External Routines


	PAGE0

second		ds	1
minute		ds	1
hour		ds	1
		ds	4

	CODE

SDAbit          EQU     $08		;Port D bit 3
SCLbit          EQU     $10		;Port D bit 4
DWOM            EQU     $20		;Port D set for Wired Or Mode


SetTIME
	sei
	jsr	StartBit
	ldaa	#$D0
	jsr	OutByte
	bcs	ErrSlave01

	ldaa	#$00			;address = 0
	jsr	OutByte
	bcs	ErrAdd01

	ldaa	#$80
	jsr	OutByte
	bcs	ErrData01

	ldab	$#6
	ldy	#minute

SET_Loop
	ldaa	0,y
	jsr	OutByte
	bcs	ErrData01

	iny	
	decb
	bne	SET_Loop
	jsr	StopBit

	psha
	pula

	jsr	StartBit
	ldaa	#$D0
	jsr	OutByte
	bcs	ErrSlave02

	ldaa	#$00			;address 0
	jsr	OutByte
	bcs	ErrAdd02

	ldaa	second
	jsr	OutByte
	bcs	ErrData01
	jsr	StopBit
	cli
	rts

;------------------------------------------------------------------------------
Get_Time
	sei
	jsr	StartBit			;Start condition
	ldaa	#$D0			; slave add. & WR bit
	jsr	OutByte
	bcs	ErrSlave

	ldaa	#$00			;
	jsr	OutByte
	bcs	ErrAdd

	jsr	StartBit			;
	ldaa	#$D1			; slave add. & RD bit
	jsr	OutByte
	bcs	ErrSlave1

	ldy	#second			; Y point to buffer
	ldab	$#6			

RD_Loop
	jsr	InByte
	staa	0,y
	clr				; Carry=0 -> Acknoledge
	jsr	OutACKBit
	iny	
	decb
	bne	RD_Loop

	jsr	InByte
	staa	0,y
	sec
	jsr	OutACKBit

	jsr	StopBit			;Stop transfer
	cli
	rts

;------------------------------------------------------------------------------
OutByte
	ldx	#REG
	bset	_DDRD,x,#SDAbit		; change SDA direction
	sec				;Set C=1

OutByteNxt
	rola	
	bcc	OutByte0
	bset	_PORTD,x,#SDAbit
	bra	OutByte1

OutByte0
        bclr	_PORTD,x,#SDAbit

OutByte1
	jsr	ClockPulse
	cmpa	#%10000000
	clc				;clear Carry bit
	bne	OutByteNxt
	jmp	GetACKBit

;------------------------------------------------------------------------------
InByte
	ldx	#REG
	ldaa	#%00000001		;Rotate bit to Carry 8 times
	bclr	_DDRD,x,#SDAbit		; change SDA direction

InByteNxt
	jsr	ClockPulse
	rola				;Rotate C bit to Reg A
	bcc	InByteNxt		
	rts				;Receive byte in Reg A

;------------------------------------------------------------------------------
ClockPulse
	bset	_PORTD,x,#SCLbit
	nop
	nop
	clc				;clear carry
	brclr	_PORTD,x,#SDAbit,ClockPulseLo
	sec				;carry=1, SDA=1

ClockPulseLo
	bclr	_PORTD,x,#SCLbit
	rts				;Returns C = SDA

OutACKbit
	bcs	OutACK0			; test ACK bit
	bclr	_PORTD,x,#SDAbit		;
	bra	OutACK1

OutACK0
	bset	_PORTD,x,#SDAbit

OutACK1
	bset	_DDRD,x,#SDAbit		; change SDA direction
	jmp	ClockPulse

GetACKBit
	bclr	_DDRD,x,#SDAbit		; change SDA direction
	jsr	ClockPulse
	bset	_DDRD,x,#SDAbit		; change SDA direction
	rts				; Returns C = ACK bit

StartBit
	bset	_PORTD,x,#SDAbit		; force SDA hi
	bset	_PORTD,x,#SCLbit		; force SCL hi
	bclr	_PORTD,x,#SDAbit		; force SDA lo
	psha				; small delay
	pula
	psha
	pula

	bclr	_PORTD,x,#SCLbit		; force SCL lo
	rts

StopBit
	bclr	_PORTD,x,#SDAbit		; force SDA low
	bset	_PORTD,x,#SCLbit		; SCL hi
	psha				; small delay
	pula
	psha
	pula
	bset	_PORTD,x,#SDAbit		; Force SDA hi
	rts


	END