;INT.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.		DESCRIPTION
*
*January 29, 2001	V1.02			MIB test Routine
*
*Author: Exequiel A. Rarama
********************************************************************************
;
	INCLUDE REG.INC                 ;register block starting address
	INCLUDE REGS.INC                ;register block addresses
	INCLUDE SYS.MAC

; Public Routines

	PUBLIC	real_time_init          ;initialize real time parameters
	PUBLIC	real_time_int           ;real time interrupt routine
	PUBLIC	dummy_int

	PUBLIC	SerInputInt
	PUBLIC	SendByte
	PUBLIC	SendString

	PUBLIC	irq_int
	PUBLIC	xirq_int

; Public Variables
	PUBLIC	state_timer
	PUBLIC	wait_timer
	PUBLIC	delay_timer

	PUBLIC	ad1			;Buffalo
	PUBLIC	ad2			;Light
	PUBLIC	ad3			;Temperature
	PUBLIC	ad4			;Potentiometer
	PUBLIC	ad5			;DAC channel 1
	PUBLIC	ad6			;DAC channel 2
	PUBLIC	ad7			;DAC channel 3
	PUBLIC	ad8			;DAC channel 4
	PUBLIC	pushbutton_count

; Public Messages
	PUBLIC	clr_MSG

; External Routines
	EXTERN	check_audio
	EXTERN	set_audio
	
	EXTERN	dstr
	EXTERN	drow
	EXTERN	disp_menu1
	
	PAGE0

; External Variables
 
	EXTERN	COMMAND
	EXTERN	COMMAND_PENDING

	EXTERN	lcd_timer
	EXTERN	lcd_state
	EXTERN	drow_var

	EXTERN	audio_timer

	EXTERN	LDisplay_timer


;local variables
ad1		ds	1               ;A/D channel 1:
ad2		ds	1               ;A/D channel 2: 
ad3		ds	1               ;A/D channel 3:
ad4		ds	1               ;A/D channel 4:
ad5		ds	1               ;A/D channel 5:
ad6		ds	1               ;A/D channel 6: 
ad7		ds	1               ;A/D channel 7:
ad8		ds	1               ;A/D channel 8:
chnl_flg		ds	1
pushbutton_count	ds	1

delay_timer	ds	2
state_timer	ds	2
wait_timer	ds	2

	CODE

SPIF	EQU	$80             ;Mask for SPIF flag bit
SW2	equ	$40
CCF	equ	$80

;=============================================================================
; Initialize Real Time Parameters
; -------------------------------

real_time_init
	ldx	#REG
	ldaa	#%00110000		;initialize A/D (2nd set of channels,
	staa	_ADCTL,X			;  continuous scan & multiple channel)

	ldaa	#%10001010		;DDRA7,DDRA3=output
	staa	_PACTL,x			;set real-time interrupt rate (16.096ms)

	bset	_TMSK2,X,%01000000	;  & enable interrupts

	clr	COMMAND
	clr	chnl_flg
	clr	pushbutton_count

	ldx	#00
	stx	delay_timer

	ldx	#00
	stx	wait_timer

	rts

;=============================================================================
; Real-Time Interrupt Routine
; ---------------------------

real_time_int
	ldx	#REG
	bset	_TFLG2,X,%01000000	;clear real-time interrupt flag
	brclr	_ADCTL,x,CCF,*		;Loop here for 100us until conversion is done

	cli

	ldaa	chnl_flg
	bne	read_2nd_chnl

	ldaa	_ADR1,x
	staa	ad1
	ldaa	_ADR2,x
	staa	ad2
	ldaa	_ADR3,x
	staa	ad3
	ldaa	_ADR4,x
	staa	ad4

	ldaa	#%00110100		;set A/D to 2nd set of channels
	staa	_ADCTL,x			;  (single scan/multiple channel)

	ldaa	#1			;Set flag for next channel
	staa	chnl_flg

	bra	time10

read_2nd_chnl
	ldaa	_ADR1,x
	staa	ad5
	ldaa	_ADR2,x
	staa	ad6
	ldaa	_ADR3,x
	staa	ad7
	ldaa	_ADR4,x
	staa	ad8

	ldaa	#%00110000		;restore A/D to 1st set of channels
	staa	_ADCTL,x			;  (continuous scan/multiple channel)

	ldaa	#0			;Set flag for next channel
	staa	chnl_flg

time10
	ldx	LDisplay_timer
	beq	time20
	dex
	stx	LDisplay_timer

time20
	ldx	lcd_timer
	beq	time30
	dex
	stx	lcd_timer

time30
	jsr     check_audio

time40
	ldaa	audio_timer             ;decrement audio duration timer
	beq	time50                   ;  if not already timed out
	inca
	beq	time50
	dec	audio_timer

time50
	ldx	state_timer
	beq	time60
	dex
	stx	state_timer

time60
	ldx	wait_timer
	beq	time70
	dex
	stx	wait_timer

time70
	ldx	delay_timer
	beq	time80
	dex
	stx	delay_timer

time80
	ldx	wait_timer
	bne	time90

	ldx	#REG
	brset	SW2,x,%10000000,time90	;check if SW2 button is pushed

	ldx	#sw2_power
	jsr	set_audio

	ldaa	pushbutton_count
	inca	
	cmpa	#$4
	bhi	init_count

	staa	pushbutton_count

	ldx	#61*1
	stx	wait_timer

	bra	time90		

init_count
	clr	pushbutton_count
	ldx	#disp_menu1
	stx	lcd_state

time90	


timex

	
dummy_int
	rti



irq_int
	ldx	#irq_power
	jsr	set_audio

	ldaa	#0
	staa	drow_var
	jsr	drow
	ldx	#irq_MSG
	jsr	dstr
	bra	xirq10

xirq_int
	ldx	#xirq_power
	jsr	set_audio

	ldaa	#0
	staa	drow_var
	jsr	drow
	ldx	#xirq_MSG
	jsr	dstr

xirq10
	ldaa	#1
	staa	drow_var
	jsr	drow
	ldx	#clr_MSG
	jsr	dstr

	ldx	#61*2
	stx	lcd_timer
	rti


irq_power
	db	5,5,0, 8,1,32, 20,6,128
	db	2,2,100, 20,3,0, 2,30,64
	db	-1,0,0


xirq_power
	db	4,4,0, 5,1,79, 6,7,240 
	db	3,3,180, 10,9,0, 7,9,40
	db	-1,0,0

sw2_power
	db	4,10,0, 5,10,79, 6,70,240 
	db	-1,0,0

;=============================================================================
*  SCI Input Interrupt Handler

*  Gets bytes from SCI.  Sets COMMAND_PENDING flag.

SerInputInt 
	ldy	#REG
	ldaa	_SCSR,y            ;clear RDRF
	ldaa	_SCDR,y
	staa	COMMAND
	rti

*       x contains starting address of string

SendString
	ldaa	0,X             ;$0 denotes end of string
	beq	RVX
	bsr	SendByte
	inx
	bra	SendString

RVX
	rts	

*  Transmits a byte, contained in register A, to the serial device via the SCI.

SendByte
	ldy	#REG
	ldab	_SCSR,y  ;wait for transmit data register empty (TDRE)
	bpl	SendByte
	staa	_SCDR,y  ;send byte
	rts



irq_MSG		db     '-irq pushbutton-',0
clr_MSG		db     '                ',0
xirq_MSG		db     ' xirq pushbutton',0

	END

sw2_MSG		db     '-SW2 pushbutton-',0		

	ldaa	#0
	staa	drow_var
	jsr	drow
	ldx	#sw2_MSG
	jsr	dstr

	ldaa	#1
	staa	drow_var
	jsr	drow
	ldx	#clr_MSG
	jsr	dstr

	ldx	#61*2
	stx	lcd_timer