;lcd.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.		DESCRIPTION
*
*January 29, 2001	V1.02			MIB test Routine
*
*Author: Exequiel A. Rarama
********************************************************************************
;

	INCLUDE REG.INC                 ;register block starting address
	INCLUDE REGS.INC                ;register block addresses
	INCLUDE SYS.MAC

;Public subroutines

	PUBLIC	LCD_init
	PUBLIC	disp_update
	PUBLIC	disp_menu1
	PUBLIC	dstr
	PUBLIC	disp_clear

;Public variables

	PUBLIC	lcd_timer
	PUBLIC	dcol_var
	PUBLIC	drow_var
	PUBLIC	drow
	PUBLIC	lcd_state
	PUBLIC	disp_buffer
	PUBLIC	disp_flag
	PUBLIC	disp_ptr

	PUBLIC	disp_buff

;External subroutines

	EXTERN	HTOD			;HEX TO DECIMAL ROUTINES
	EXTERN	delay
	EXTERN	small_delay  
	EXTERN	state_timer
	EXTERN	wait_timer
	EXTERN	SB1

; External Messages
	EXTERN	clr_MSG

	PAGE0

	EXTERN	cnv_str
	EXTERN	timer_counter
	EXTERN	states

	EXTERN	ad1			;Buffalo
	EXTERN	ad2			;Light
	EXTERN	ad3			;Temperature
	EXTERN	ad4			;Potentiometer
	EXTERN	ad5			;DAC channel 1
	EXTERN	ad6			;DAC channel 2
	EXTERN	ad7			;DAC channel 3
	EXTERN	ad8			;DAC channel 4
	EXTERN	pushbutton_count


; Memory Allocation
disp_buffer	ds	32              ;display buffer (2 lines of 16 chars)
disp_ptr		ds	2               ;pointer to display buffer
disp_flag	ds	1               ;1 = update; 0 = home; -1 = done
drow_var		ds	1
temp		ds	1
lcd_state	ds	2
temp_h		ds	1
TEMP1		ds	1
TEMP2		ds	1
lcd_timer	ds	2
dcol_var		ds	1
dig_lenght	ds	1
l_flag		ds	1

disp_buff	ds	3

        CODE

; Local Constants
lcd_ctrl		equ	$46		;Port A bit 4 = 0 - Instruction in
lcd_data		equ	$45		;Port A bit 4 = 0 - Data in
BL		equ	$20
EOT		equ	$04		;end of text/table

;-----------------------------------------------------------------------------
; Display Initialization
; ----------------------

LCD_init
	clr	drow_var
	clr	disp_flag

	jsr	delay

	ldx	#REG
	ldaa	#%00110000
	staa	lcd_ctrl,x

	jsr	small_delay

	ldaa	#%00111000		;8 data bits, 2 display lines, 0
	staa	lcd_ctrl,x

	jsr	small_delay

	ldaa	#%1100			;display on, cursor off, blink off
	staa	lcd_ctrl,x

	jsr	small_delay

	ldaa	#%1			;Clear display and return cursor to home
	staa	lcd_ctrl,x

	jsr	small_delay

	ldaa	#%01000000
	staa	lcd_ctrl,x

	jsr	small_delay

	ldaa	#%10000000
	staa	lcd_ctrl,x

	jsr	small_delay

	ldx	#disp_menu1
	stx	lcd_state

	ldx	#61*1
	stx	lcd_timer

	rts

disp_menu1
	ldx	lcd_timer
	bne	lcd_ex1

	ldaa	#0
	staa	drow_var
	jsr	drow
	ldx	#MSG1
	jsr	dstr

	ldaa	#1
	staa	drow_var
	jsr	drow
	ldx	#MSG2
	jsr	dstr

	ldx	#61*2
	stx	lcd_timer

	ldx	#disp_menu2
	stx	lcd_state
        
lcd_ex1
	jsr	go_ready
	rts

disp_menu2
	ldx	lcd_timer
	bne	lcd_ex2

	ldaa	#0
	staa	drow_var
	jsr	drow
	ldx	#MSG3
	jsr	dstr

	ldaa	#1
	staa	drow_var
	jsr	drow
	ldx	#MSG4
	jsr	dstr

	ldx	#61*2
	stx	lcd_timer

	ldx	#disp_menu1
	stx	lcd_state

lcd_ex2
	jsr	go_ready
	rts

;-----------------------------------------------------------------------------

; Clear Display
; -------------

disp_clear
	ldx	#disp_buffer		;starting address of display buffer
	stx	disp_ptr			;home cursor
	ldab	#32			;number of characters
	ldaa	#BL

dcl10
	staa	0,x			;fill buffer with spaces
	inx
	decb
	bne	dcl10
	ldaa	#1			;set flag for immediate display
	staa	disp_flag		;  update

	rts

;-----------------------------------------------------------------------------

; Set Display Position
; --------------------
; This routine sets the display buffer pointer to the selected row
; and column position.  Values are assumed to be valid:  no range checking
; is performed.
;	Entry:	A contains row number (0 - 1)
;		B contains column number (0 - 15)

disp_pos
	ldx	#disp_buffer		;starting address of display buffer
	abx				;add column number
	ldab	#16
	mul
	abx				;add 16 x row number
	stx	disp_ptr
	rts
;-----------------------------------------------------------------------------

; Display Character
; -----------------
;	Entry:	A contains character to be displayed
;		B contains number of occurences (DISP_REP only)

disp_chr
	ldy	disp_ptr			;store character in display buffer
	cmpa	#$a6
	bne	dsc10
	ldaa	#4
dsc10
	staa	0,y
	iny
	bra	dispex

disp_rep
	ldy	disp_ptr
	cmpa	#$a6
	bne	drp10
	ldaa	#4

drp10	staa	0,y			;store character, decrement counter
	iny				;  and loop until done
	decb
	bne	drp10

dispex
	cpy	#disp_buffer+32
	blo	dsp10
	ldy	#disp_buffer
dsp10
	sty	disp_ptr
	ldaa	#1			;set flag for immediate display
	staa	disp_flag		;  update
	rts
;-----------------------------------------------------------------------------

; Display String
; --------------

disp_str
	ldy	disp_ptr

dst10
	ldaa	0,x
	beq	dst20
	cmpa	#$a6
	bne	dst15
	ldaa	#4

dst15
	staa	0,y
	inx
	iny
	bra	dst10

dst20
	inx
	bra	dispex

;--------
disp_strn
	ldy	disp_ptr

dsn10
	ldaa	0,x
	cmpa	#$a6
	bne	dsn15
	ldaa	#4

dsn15
	staa	0,y
	inx
	iny
	decb
	bne	dsn10

	bra	dispex
;-----------------------------------------------------------------------------

; Update Display
; --------------
;	This routine updates the LCD display from the display image in
; 	 memory whenever the update flag is set.

disp_update
	ldy	#REG

	ldaa	disp_flag		;exit if display update flag is not
	bmi	dupex			;  set
	dec	disp_flag
	beq	dup10

	ldaa	#%00000010		;home cursor
	staa	lcd_ctrl,y

	bra	dupex

dup10
	ldab	#16			;number of characters per line
	ldx	#disp_buffer		;display 1st line
	jsr	line_update

	ldaa	#%11000000
	staa	lcd_ctrl,y

	jsr	small_delay

	ldab	#16
	ldx	#disp_buffer+16		;display 2nd line
	jsr	line_update

	ldaa	#%1100			;display on, cursor off, blink off
	staa	lcd_ctrl,y

dupex
        rts

;----------------------------------------------------------------------------
line_update
	pshb				;save character count

lup10
	ldaa	0,x			;write character to display
	cmpa	#'0'			;  (substitue O for 0)
	bne	lup15
	ldaa	#'O'

lup15					;Display Char to LCD
	staa	lcd_data,y

	jsr	small_delay

	inx				;advance to next character, decrement
	decb				;  count & loop if not done
	bne	lup10
	pulb				;restore character count

	rts

;==============================================================================

; Set Cursor Position
; -------------------
;       A contains row number
;       B contains column number

drow
	ldaa	drow_var			;drow_var = 0 =>1st line
					;drow_var = 1 =>2nd line
	ldab	#0
	jsr	disp_pos
	rts

; Display String
; --------------
;       X contains address of string to be displayed
;       B contains length of string (if absent:  nul terminates string)

dstr    
        jsr     disp_str
        rts

dstrn    
        jsr     disp_strn
        rts

;Lcd Messages
MSG1            db     '>>>>TechArts<<<<',0

MSG2            db     'MIB Test Routine',0

MSG3            db     'This is a TEST..',0

MSG4            db     '----------------',0

;------------------------------------------------------------------------------
go_ready				;check for command
	ldaa	pushbutton_count
	beq	go_ready_ex

	cmpa	#1		;check light
	bne	check_temp	
	ldx	#display_light	;display light LED and LCD
	stx	lcd_state
	bra	go_ready_ex

check_temp
	cmpa	#2		;check temperature
	bne	check_pot
	ldx	#display_temp
	stx	lcd_state
	bra	go_ready_ex

check_pot
	cmpa	#3		;check adjustable pot
	bne	check_DAC
	ldx	#display_pot
	stx	lcd_state
	bra	go_ready_ex

check_DAC
	cmpa	#4
	bne	go_ready_ex
	ldx	#display_DAC
	stx	lcd_state

go_ready_ex
	rts

;------------------------------------------------------------------------------
display_light
	ldx	lcd_timer
	bne	dispexit

	ldaa	pushbutton_count
	cmpa	#1
	bne	change_state1	

	ldaa	#0
	staa	drow_var
	jsr	drow
	ldx	#LMSG1
	jsr	dstr

	jsr	clr_display

	ldaa	ad2
	jsr	display_val

dispexit
	rts

change_state1
	ldx	#disp_menu1
	stx	lcd_state
	rts

LMSG1	db     'Light Intensity ',0


;------------------------------------------------------------------------------
display_temp
	ldx	lcd_timer
	bne	tempex

	ldaa	pushbutton_count
	cmpa	#2
	bne	change_state2

	ldaa	#0
	staa	drow_var
	jsr	drow
	ldx	#TMSG1
	jsr	dstr
	
	jsr	clr_display

	ldaa	ad3
	jsr	display_val

tempex
	rts

change_state2
	ldx	#disp_menu1
	stx	lcd_state
	rts

TMSG1	db     'Temperature     ',0

;------------------------------------------------------------------------------
display_pot
	ldx	lcd_timer
	bne	potex

	ldaa	pushbutton_count
	cmpa	#3
	bne	change_state3

	ldaa	#0
	staa	drow_var
	jsr	drow
	ldx	#PMSG1
	jsr	dstr
	
	jsr	clr_display

	ldaa	ad4
	jsr	display_val

potex
	rts

change_state3
	ldx	#disp_menu1
	stx	lcd_state
	rts

PMSG1	db     'Potentiometer   ',0

;------------------------------------------------------------------------------
display_DAC
	ldx	lcd_timer
	bne	DACex

	ldaa	pushbutton_count
	cmpa	#4
	bne	change_state4

	ldaa	#0
	staa	drow_var
	jsr	drow
	ldx	#DMSG1
	jsr	dstr
	
	jsr	clr_display

	ldaa	ad5
	jsr	display_val

DACex
	rts

change_state4
	ldx	#disp_menu1
	stx	lcd_state
	rts

DMSG1	db     'DAC Channel 1   ',0

;------------------------------------------------------------------------------
display_val
	ldx	#disp_buff
	lsra
	lsra
	lsra
	lsra
	anda	#$0f
	cmpa	#$9
	bhi	add7_10
	adda	#$30
	bra	addnormal10

add7_10
	adda	#$37

addnormal10
	staa	0,x			;1st Value
	ldaa	ad2
	anda	#$0f
	cmpa	#$9
	bhi	add7_20
	adda	#$30
	bra	addnormal20

add7_20
	adda	#$37

addnormal20
	staa	1,x			;2nd Value
	clr	2,x			;make to zero endbuff
	jsr	dstr			;Go display values to LCD
	
	setx	lcd_timer,#61*1
	rts


clr_display
	ldaa	#1
	staa	drow_var
	jsr	drow
	ldx	#clr_MSG
	jsr	dstr

	ldaa	#1			;Initialize to 2nd line
	staa	drow_var
	jsr	drow
	rts

        END

