;MAIN.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.		DESCRIPTION
*
*January 29, 2001	V1.02			MIB test Routine
*
*Author: Exequiel A. Rarama
********************************************************************************

	INCLUDE REG.INC                 ;register block starting address
	INCLUDE REGS.INC                ;register block addresses

;Public function
	PUBLIC	delay
	PUBLIC	small_delay

;Public variables
	PUBLIC	states
	PUBLIC	COMMAND
	PUBLIC	COMMAND_PENDING

;External subroutines
	EXTERN	spi_init
	EXTERN	real_time_init
	EXTERN	real_time_int
	EXTERN	SerInputInt
	EXTERN	go_power
	EXTERN	SendByte
	EXTERN	SendString
	EXTERN 	msg_command

	EXTERN	LCD_init
	EXTERN	lcd_state
	EXTERN	disp_update

	EXTERN	audio_init
	EXTERN	audio_int
	EXTERN	check_audio
	EXTERN	Led_init

	EXTERN	irq_int
	EXTERN	xirq_int

	EXTERN	tone_run


		PAGE0

	EXTERN	Led_state

states			ds	2
COMMAND		ds	1       ;used by ProcessCommand
COMMAND_PENDING	ds	1       ;used by ProcessCommand

		CODE

bdmsk96	equ	%00110000	;(baud) 9600 baud with 8 MHz crystal
bdmsk24	equ	%00110010	;(baud) 2400 baud with 8 MHz crystal
bdmsk12	equ	%00110011	;(baud) 1200 baud with 8 MHz crystal
ptdmsk	equ 	%00000010	;(ddrd)portd data direction: input, except txd
sc2msk2	equ	%00101100	;(sccr2)enable tx & rx and Rx Interrupt
;

;-----------------
; Start of Program
; ----------------
reset
	sei				;disabel interrupt
	lds	#$ff			;initialize stack to top of ram
	ldx	#REG			;base address 1000h
	ldaa	#%10111011		;start A/D converter, set IRQ to edge,
	staa	_OPTION,x		;  disable clock monitor, COP timer

	ldaa	#bdmsk96			;baud=9600
	staa	_BAUD,x
	ldaa	#sc2msk2
	staa	_SCCR2,x			;enable SCI rcvr. & xmtr. & rx int.
	ldaa	_SCDR,x			;dummy read to flush receive buffer

	jsr	real_time_init		;initialize RTI and other interrupts
	jsr	audio_init
	jsr	Led_init
	jsr	LCD_init

	cli				;enable interrupts
	clra
	tap

;                        *******************
;                        *Main Program Loop*
;                        *******************
main
	ldx	#REG
	ldaa	#$55			;reset watchdog timer
	staa	_COPRST,x
	ldaa	#$0aa
	staa	_COPRST,x
	ldx	Led_state
	jsr	0,x

	ldx	lcd_state
	jsr	0,x

	jsr	disp_update
	jsr	tone_run

	bra	main

msg_test

;-----------------------------------------------------------------------------

delay
	pshy
	ldy	#0
	bra	dsi10

small_delay
	pshy
	ldy	#$333

dsi10
	dey
	bne	dsi10
	puly
	rts

;=============================================================================
VECT    SECTION
	ORG	$ffd6

	dw	SerInputInt		;SCI Receiver Interrupt
	dw	reset			;SPI
	dw	reset			;Pulse Accumulator Input Edge
	dw	reset			;Pulse Accumulator Overflow
	dw	reset			;Timer Overflow

	dw	reset			;Timer Output Compare 5
                           		; or Timer Input Capture 4

	dw	audio_int		;Timer Output Compare 4
	dw	reset			;Timer Output Compare 3
	dw	reset			;Timer Output Compare 2
	dw	reset			;Timer Output Compare 1

	dw	reset			;Timer Input Capture 3
	dw	reset			;Timer Input Capture 2
	dw	reset			;Timer Input Capture 1
	dw	real_time_int		;Real Time Interrupt

	dw	irq_int			;IRQ Pin
	dw	xirq_int			;XIRQ Pin
	dw	reset			;SWI
	dw	reset			;Illegal Opcode Trap
	dw	reset			;COP Failure
	dw	reset			;Clock Monitor Fail
	dw	reset			;RESET

	END
