
; Define Register Block Addresses

_PORTA		EQU	00h		;I/O port A
_PORTB		EQU	04h		;output port B
_PORTC		EQU	03h		;I/O port C
_DDRC		EQU	07h		;data direction for port C (1=output, 0=input)
_PORTD		EQU	08h		;I/O port D
_DDRD		EQU	09h		;data direction for port D
_PORTE		EQU	0ah		;I/O port E

_TCNT		EQU	0eh		;timer counter register

_TOC1		EQU	16h		;output compare 1 register
_TOC1_HI	EQU	_TOC1		;  high byte
_TOC1_LO	EQU	_TOC1+1		;  low byte
_TOC2		EQU	18h		;output compare 2 register
_TOC2_HI	EQU	_TOC2		;  high byte
_TOC2_LO	EQU	_TOC2+1		;  low byte
_TOC3		EQU	1ah		;output compare 3 register
_TOC3_HI	EQU	_TOC3		;  high byte
_TOC3_LO	EQU	_TOC3+1		;  low byte
_TOC4		EQU	1ch		;output compare 4 register
_TOC4_HI	EQU	_TOC4		;  high byte
_TOC4_LO	EQU	_TOC4+1		;  low byte
_TOC5		EQU	1eh		;output compare 5 register
_TOC5_HI	EQU	_TOC5		;  high byte
_TOC5_LO	EQU	_TOC5+1		;  low byte

_TCTL1		EQU	20h		;timer control register 1
_TCTL2		EQU	21h		;timer control register 2
_TMSK1		EQU	22h		;main timer interrupt mask register 1
_TFLG1		EQU	23h		;main timer interrupt flag register 1
_TMSK2		EQU	24h		;main timer interrupt mask register 2
_TFLG2		EQU	25h		;main timer interrupt flag register 2

_PACTL		EQU	26h		;port A control port

_SPCR           EQU     28h             ;SPI Control Register
_SPSR           EQU     29h             ;SPI Status Register
_SPDR           EQU     2Ah             ;SPI Data Register

_BAUD		EQU	2bh		;baud rate register
_SCCR1		EQU	2ch		;SCI control register 1
_SCCR2		EQU	2dh		;SCI control register 2
_SCSR		EQU	2eh		;SCI status register
_SCDR		EQU	2fh		;SCI data register

_ADCTL		EQU	30h		;A/D control/status register
_ADR1		EQU	31h		;A/D result register 1
_ADR2		EQU	32h		;A/D result register 2
_ADR3		EQU	33h		;A/D result register 3
_ADR4		EQU	34h		;A/D result register 4

_BPROT		EQU	35h		;block protect register

_OPTION		EQU	39h		;system configuration options
_COPRST		EQU	3ah		;arm/reset COP timer
_PPROG		EQU	3bh		;EEPROM programming register
_HPRIO		EQU	3ch		;highest priority interrupt
_INIT		EQU	3dh		;ram - I/O mapping register
_CONFIG		EQU	3fh		;configuration control register


PORTA		EQU	REG+_PORTA
PORTB		EQU	REG+_PORTB
PORTC		EQU	REG+_PORTC
DDRC		EQU	REG+_DDRC
PORTD		EQU	REG+_PORTD
DDRD		EQU	REG+_DDRD
PORTE		EQU	REG+_PORTE

TCNT		EQU	REG+_TCNT

TOC1		EQU	REG+_TOC1
TOC1_HI		EQU	REG+_TOC1_HI
TOC1_LO		EQU	REG+_TOC1_LO
TOC2		EQU	REG+_TOC2
TOC2_HI		EQU	REG+_TOC2_HI
TOC2_LO		EQU	REG+_TOC2_LO
TOC3		EQU	REG+_TOC3
TOC3_HI		EQU	REG+_TOC3_HI
TOC3_LO		EQU	REG+_TOC3_LO
TOC4		EQU	REG+_TOC4
TOC4_HI		EQU	REG+_TOC4_HI
TOC4_LO		EQU	REG+_TOC4_LO
TOC5		EQU	REG+_TOC5
TOC5_HI		EQU	REG+_TOC5_HI
TOC5_LO		EQU	REG+_TOC5_LO

TCTL1		EQU	REG+_TCTL1
TCTL2		EQU	REG+_TCTL2
TMSK1		EQU	REG+_TMSK1
TFLG1		EQU	REG+_TFLG1
TMSK2		EQU	REG+_TMSK2
TFLG2		EQU	REG+_TFLG2

PACTL		EQU	REG+_PACTL

BAUD		EQU	REG+_BAUD
SCCR1		EQU	REG+_SCCR1
SCCR2		EQU	REG+_SCCR2
SCSR		EQU	REG+_SCSR
SCDR		EQU	REG+_SCDR

ADCTL		EQU	REG+_ADCTL
ADR1		EQU	REG+_ADR1
ADR2		EQU	REG+_ADR2
ADR3		EQU	REG+_ADR3
ADR4		EQU	REG+_ADR4

BPROT		EQU	REG+_BPROT

OPTION		EQU	REG+_OPTION
COPRST		EQU	REG+_COPRST
PPROG		EQU	REG+_PPROG
HPRIO		EQU	REG+_HPRIO
INIT		EQU	REG+_INIT
CONFIG		EQU	REG+_CONFIG
