;TLC5620.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.		DESCRIPTION
*
*January 29, 2001	V1.02			MIB test Routine
*
*Author: Exequiel A. Rarama
********************************************************************************

	INCLUDE REG.INC                 ;register block starting address
	INCLUDE REGS.INC                ;register block addresses
	INCLUDE SYS.MAC                 ;system macros

;Public Function
	PUBLIC	dac_write
	PUBLIC	spi_init

	PUBLIC	Dac_Test

;Public Variables
 	PUBLIC	dac_write_var


;External Function
	EXTERN	SendByte
	EXTERN	SendString
	
	EXTERN	go_ready

		PAGE0

	EXTERN	states

dac_write_var		ds	2


;Required Rams variables

		CODE

;Dac modes

SSPIN		EQU  	%00100000	;Port D bit 5 is SS* pin
					;* 0,0,SS*,SCK;MOSI,MISO,TxD,RxD
					;(RxD & TxD direction controlled by SCI)
					;* For EVBU w/ RTC use
					;$38 -> SS,SCK,and MOSI=OUTS, rest=INS

SPCR		EQU	$28		;SPI control register
					;* SPIE,SPE,DWOM,MSTR;CPOL,CPHA,SPR1,SPR0

SPSR		EQU	$29		;SPI status register
					;* SPIF,WCOL,-,MODF;-,-,-,-

SPIF		EQU	$80		;Mask for SPIF flag bit

DACLoad	equ	SSPIN		;Chip select 
LDAC_address	equ	$47		;Chip select o/p at Address $1047
LDAC		equ	$01

DACA		equ	$00
DACB		equ	$01
DACC		equ	$02
DACD		equ	$03
RNG		equ	$00

spi_init				;Initialize spi bus
	ldx	#REG			;Point at start of register block

	ldaa	#$00
	staa	_PORTD,x		;Initial port D data

	ldaa	#%00111000		;SS,SCK,and MOSI=OUTS, others=INS
	staa	_DDRD,x		;Set directions for port D pins

	bset	_PORTD,x,DACLoad	;De-select DAC

	ldaa	#%01011000		;THE CPOL=1, CPHA=0
					;SPIE,SPE,DWOM,MSTR;CPOL,CPHA,SPR1,SPR0
	staa	_SPCR,x		;SPI On, Master, CPOL:CPHA=1:0, 1MHz
	ldaa	_SPSR,x
	ldaa	_SPDR,x		;Clear SPIF

	rts


dac_write
	ldx	#REG			;Point at start of register block

	bset	_PORTD,x,DACLoad	;De-select DAC
	ldaa	dac_write_var		;Which DAC channel to write to
	staa	_SPDR,x		;Write byte to DAC
	brclr	_SPSR,x,SPIF,*	;Wait for SPIF

	ldaa	_SPSR,x
	ldaa	_SPDR,x		;Read returning DATA

	ldaa	dac_write_var+1	;Write actual data
	staa	_SPDR,x		;Write byte to DAC
	brclr	_SPSR,x,SPIF,*	;Wait for SPIF

	ldaa	_SPSR,x
	ldaa	_SPDR,x		;Read returning DATA

	bclr	_PORTD,x,DACLoad	;Strobe Data to Latch
	nop
	bset	_PORTD,x,DACLoad	;De-select DAC
	nop
	bclr	LDAC_address,x,LDAC  ;output data to outside world	

	rts


Dac_Test
	ldaa	#DACA			;load channel A address
	lsla				;shift for RNG
	ldab	#255			;mid level number
	std	dac_write_var		;store for dump

	bsr	dac_write		;go dump to DAC

	ldaa	#DACB			;load channel B address
	lsla				;shift for RNG
	ldab	#128			;mid level number
	std	dac_write_var		;store for dump

	bsr	dac_write		;go dump to DAC

	ldaa	#DACC			;load channel C address
	lsla				;shift for RNG
	ldab	#64			;mid level number
	std	dac_write_var		;store for dump

	bsr	dac_write		;go dump to DAC

	ldaa	#DACD			;load channel D address
	lsla				;shift for RNG
	ldab	#32			;mid level number
	std	dac_write_var		;store for dump

	bsr	dac_write		;go dump to DAC


	rts


	END