;STATES.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.		DESCRIPTION
*
*January 29, 2001	V1.02			MIB test Routine
*
*Author: Exequiel A. Rarama
********************************************************************************

	INCLUDE REG.INC                 ;register block starting address
	INCLUDE REGS.INC                ;register block addresses
	INCLUDE SYS.MAC                 ;system macros

; Public Routines

	PUBLIC	go_power                ;enter POWER ON state
	PUBLIC	go_ready

;	PUBLIC msg_command


; Public Variables

	PUBLIC	state_timer             ;general purpose state timer
	PUBLIC	wait_timer

; Extern Routines
	EXTERN	SendByte
	EXTERN	SendString

	EXTERN	go_get_seconds
	EXTERN	READ_TIME_SEC
	EXTERN	RTC_DEFAULT

	EXTERN	Dac_Test

	PAGE0

; External Variables
	EXTERN	states
	EXTERN	COMMAND

state_timer	ds	2               ;general purpose state timer
wait_timer	ds	2

	CODE

;=============================================================================

; Power-On State
; --------------
;       This state is entered only upon initial power up.

go_power
	setx	state_timer,#0  ;initialize timers
	setx	wait_timer,#0

	chgstt	#go_ready        ;go wait for command from SCI
	clr	COMMAND

	rts

go_ready                        ;check for command
	ldaa	COMMAND
;	bne	proc_command
	rts



	END

;------------------------------------------------------------------------------ 

proc_command
	cmpa	#'S'
	bne	Get_Minutes
	clr	COMMAND
	chgstt	#READ_TIME_SEC

	ldx	#time_msg1
	jsr	SendString
	rts

Get_Minutes
	cmpa	#'M'
	bne	Get_Hours
	clr	COMMAND

	chgstt	#go_get_minutes
	rts

Get_Hours
	cmpa	#'H'
	bne	Get_Day
	clr	COMMAND

	chgstt	#go_get_hours
	rts

Get_Day
	cmpa	#'D'
	bne	Get_Date
	clr	COMMAND

	chgstt	#go_get_day
	rts


Get_Date
	cmpa	#'d'
	bne	Get_Months
	clr	COMMAND

	chgstt	#go_get_date
	rts


Get_Months
	cmpa	#'M'
	bne	Get_Years
	clr	COMMAND

	chgstt	#go_get_months
	rts


Get_Years
	cmpa	#'Y'
	bne	rtc_init
	clr	COMMAND

	chgstt	#go_get_years
	rts

rtc_init
	cmpa	#'I'
	bne	Test_DAC
	clr	COMMAND
	chgstt	#RTC_DEFAULT
	rts

Test_DAC
	cmpa	#'T'
	bne	go_ex
	clr	COMMAND

	jsr	Dac_Test

go_ex
	ldx	#msg_command
	jsr	SendString

	clr	COMMAND
	rts


go_get_years
go_get_months
go_get_date
go_get_day
go_get_hours
go_get_minutes

	chgstt	#go_ready        ;go wait for command from SCI
	rts



;------------------------------------------------------------------------
time_msg1
	db	$0a,$0d,"Time is - ",$0

msg_command
	db	$0a,$0d
	db	"S - Second - ",$0a,$0d
	db	"m - Minute - ",$0a,$0d
	db	"H - Hour - ",$0a,$0d
	db	"D - Day - ",$0a,$0d
	db	"d - Date - ",$0a,$0d
	db	"M - Month - ",$0a,$0d
	db	"Y - Year - ",$0a,$0d
	db	"I - Default - ",$0a,$0d

	db	$0a,$0d,"T - Test DAC - ",$0a,$0d,0

CrLf	db	$0a,$0d,0

	END