/*
*filename: candemo.c
*******************************************************************************
*REVISION HISTORY:
*
* DATE		REV. NO.	DESCRIPTION
*
* 4/18/94	1.0		    Initial release in assambler by CARL BARNES
* 3/9/2000				Incorporate CAN board and LCD board in C by JEFF YUAN
*
*
*******************************************************************************
*TECHNOLOGICAL ARTS
*
*DEMO SOFTWARE FOR ADAPT11C24 AND MICROCORE11

*Function: 	The CAN board's default status is a recevier.
			The CAN board can be set as a sender by menu.
			The sender connects PC. The receiver connects to an LCD board.
			As a sender, the CAN board sends a string of 'Technological Arts'.
			As a receiver, the CAN board receives the string and shows it on the LCD.  

*/


#include <stdio.h>

#if defined(_HC11)
#include <hc11.h>
#elif defined(_HC12)
#include <hc12.h>
#elif defined(_HC16)
#include <hc16.h>
#else
#error "no target defined"
#endif



/*  Operational Parameters	*/

#define _100MS		25
#define _250MS		61
#define _500MS		125
#define _1SECOND	250
#define _2SECONDS	500
#define _3SECONDS	750
#define _5SECONDS	1250
#define _10SECONDS	2500
#define _25SECONDS	6250
#define _60SECONDS	15000
#define _2MIN		30000

#define TONE_2K		500		/* frequencies in Hertz for tone generation	*/
#define TONE_1K		1000
#define TONE_440	2272
#define TONE_220	4545
#define TONE_180	3000
#define TONE_110	9090
#define TONE_60		16666


/*	Operational Constants	*/

#define TRUE    0xFF
#define FALSE   0x00
#define CR		0x0D
#define	BL		0x20


#define opts  	0xB0	/* a/d on , IRQ low-going edge sensitive*/
#define admask1	0x30	/* (adctl)continuous conversion, AD0 thru AD3		*/
#define admask2	0x34	/* (adctl)continuous conversion, AD4 thru AD7		*/
#define tmask	0x40	/* (tmsk2)no timer prescale, RTI enabled			*/
#define rtimsk	0x88	/* (pactl) 4.1 msec interrupt with 8 MHz xtal,	enable PA7 output	*/
#define tc1msk	0x40	/*	OC2 in toggle mode								*/

#define clrmsk	0xC0	/*	mask for clearing timer flags					*/
#define ptdmsk	0x3A	/*	output: ss, sck, mosi, txd; input: miso, rxd  	*/
#define sc2msk2 0x2C	/*	(sccr2)enable tx & rx and Rx Interrupt			*/

#define spimsk	0x50	/*	SPE,MSTR=1, CPOL,SWOM,CPHA=0 ; 1MHz				*/
#define scbw	0x81	/*	write data to 82527	*/
#define scbr	0x01	/*	read data from 82527	*/
#define encan	0x5F	/* 	select 82527	*/
#define discan	0x80	/*	not select 82527	*/



unsigned char disp_buffer[80];		 /*	display buffer (4 lines of 20 chars)	*/
unsigned char *disp_ptr ;         	 /*	pointer to display buffer	*/
unsigned char disp_flag ;         	 /*	1 = update; 0 = home; -1 = done	*/

unsigned char ta[20] = " Technological Arts ";
unsigned char CONTINUOUS, CAN_FLAG, HEAD_FLAG;




#pragma	interrupt_handler SCIHandler;
#pragma	interrupt_handler OC2Handler;
#pragma	interrupt_handler RTIHandler;
#pragma	interrupt_handler CanHandler;

void PulseXToneB(unsigned short x, unsigned short y, unsigned short z);
void EnableToneX(unsigned short x);
void ProcessCommand(void);
void Pcc(void);
void Pcad(unsigned char x, char *s);
void ShowAnalog(void);
void ToggleOutLine(int i);
void ShowMenu(void);
void Init_can_s(void);
void Init_can_g(void);
void Send_can(unsigned char x, unsigned char z );
unsigned char Read_can(unsigned char x);
unsigned char Can_spi(unsigned char x);
void TestCan(void);


void Init_lcd(void);
void Disp_updata(void);
void Disp_menu(void);
void Toggle_lcd_ctrl(char x);
void Toggle_lcd_data(char x);
void Disp_clear(void);
void Dump_spi_data(char x);
void Delay(void);
void Small_delay(void);

void Small_delay(void);

/* System Variables	*/

volatile unsigned char COMMAND, COMMAND_PENDING,w;
volatile unsigned short TIMER, HALF_PERIOD;




void main(void)
	{
	
	unsigned char x,y;
		
	INTR_OFF();			/*	disable interrupts */
	
	OPTION = opts ;		/*	define system option	*/
	ADCTL = admask1 ;	/*	set A/D to scan AD0 thru AD3 continuously	*/        
	
	PACTL = rtimsk;		/*	initialize RTI rate, enable PA7 output	*/
	
	PORTA |= discan ;	/*	make can select_line(PA7) high level	*/
	
	TMSK2 = tmask ;		/*	enable real-time interrupt (RTI)	*/
	
	DDRD = ptdmsk ;		/*	initialize PORTD	*/
	
	setbaud(BAUD2400);	/*	SCI baud=2400	*/
	SCCR2 = sc2msk2;	/*	enable SCI rcvr. & xmtr. & rx int. */
	/* getchar(); */
	
	SPCR = spimsk ; 	/*	SPE,MSTR=1, CPOL,SWOM,CPHA=0; 1MHz	*/
	
	/*Init_can() ;*/		/*	initialize AN82527	*/
	
	COMMAND = 0 ;
	CONTINUOUS = 0 ;
	TIMER = 0 ;
	CAN_FLAG = 0 ;
	

	
	puts("ok");
	
	
	Init_can_g() ;		/*	initialize AN82527	*/
	
	Init_lcd();
	
	INTR_ON();			/*	enable interrupts */
	
	
	/* PulseXToneB(2, TONE_440, _100MS); */
	
	
		
	x = Read_can(0x01);
		
	x &= 0xEF ;
			
	Send_can(0x01, x);
		
	
	while(1)
		{
				
		ProcessCommand();
		
							
		if(CONTINUOUS)
			{
			ShowAnalog();
			}		
		}
	}





/* x contains number of beeps desired
   y contains tone frequency
   z contains tone duration (eg. if y=1  => duration=4.1 ms; y=255 => 1 sec)
*/
void PulseXToneB(unsigned short x, unsigned short y, unsigned short z)
	{
	unsigned short i;
	
	for(i=0; i<x; i++)
		{
	
		EnableToneX(y);		/* tone generated via outputCompare	*/
		
		TIMER = z ;
	
		while(TIMER) ;
	
		TMSK1 = 0 ;
		TCTL1 = 0 ;
	
		TIMER = z ;
		while(TIMER) ;
		
		}
		
	}
	 
	
	
void EnableToneX(unsigned short x)
	{
		
	INTR_OFF();
	HALF_PERIOD = x ;
	TCTL1 = tc1msk ;
	TFLG1 = tc1msk ;
	TMSK1 = tc1msk ;
	INTR_ON();
	
	}


void ProcessCommand(void)
	{
		
	if(COMMAND_PENDING)
		{
			
		COMMAND_PENDING = 0;
		CONTINUOUS = 0;
		putchar('\n'); 
		COMMAND |= 0X20;
			
		switch(COMMAND)
			{  
			
			case 'a':
				
				Pcad(PORTA, "	PORTA = ");				
				break ;
				
			case 'c':
			
				Pcc();
				break ;
				
			case 'd':
			
				Pcad(PORTD, "	PORTD = ");
				break ;
				
			case 'r':
			
				CONTINUOUS = TRUE ;	/* set continuous a/d display flag*/
				break ;
			
			case 's':
			
				puts("	>>> BEEP! <<<");
				PulseXToneB(2, TONE_440, _100MS);
				break ; 
					
			case '4':
				
				puts("	PA4 toggled");
				ToggleOutLine(4) ;
				break ;
			
			case '5':
			
			
				puts("	PA5 toggled");			
				ToggleOutLine(5) ;
				break ;
				
			case '6':
			
				puts("	PA6 toggled");
				ToggleOutLine(6);
				break ;			
				
			case 't':
			
				CAN_FLAG = TRUE ;
				Init_can_s();
				puts("	I send 'Technological Arts'");
				TestCan();
				break ;			
					
			default:
			
				ShowMenu();
			
			}
		}
	}
	






void Pcad(unsigned char x, char *s)
	{
	
	unsigned char y;
	int i;
	
	for (i = 0; *s; i++, s++){putchar(*s);}

	
	for(i=7; i>=0; i--)
		{
		y = (x>>i) & 0x01 ;
		y += 0x30 ;				
		putchar(y);
		}
		
	putchar('\n');
	
	}	
	
	
void Pcc(void)
	{
	
	PORTA = 0 ;
	puts("	PORTA OUTPUTS CLEARED");
	
	}
	
	
void ShowAnalog(void)
	{
	
		
	ADCTL = admask1 ;
	
	printf("  AN0=%3d",ADR1);
	printf("  AN1=%3d",ADR2);
	printf("  AN2=%3d",ADR3);
	printf("  AN3=%3d",ADR4);
	
	ADCTL = admask2 ;
	
	printf("  AN4=%3d",ADR1);
	printf("  AN5=%3d",ADR2);
	printf("  AN6=%3d",ADR3);
	printf("  AN7=%3d",ADR4);
	
	putchar(CR);
	
	}


	
void ToggleOutLine(int i)
	{
	
	int x;
	x = 0x01 << i;
	PORTA ^= x ;
	
	} 	
 
void ShowMenu(void)
	{
	
	puts("\n	_________________________________________\n");	
	puts(" 	MICROCORE-11 DEMO PROGRAM COMMAND MENU" );
	puts("	_________________________________________");	
		
	puts("	A  => SHOW PORT A STATUS");
	puts("	C  => CLEAR PORT A OUTPUTS");
	puts("	D  => SHOW PORT D STATUS");
	puts("	R  => SHOW REAL-TIME ANALOG VALUES");
	puts("	S  => BEEP SPEAKER (CONNECT TO PA6)");
	puts("	T  => TEST CAN BUS");
	puts("	4 TO 6 => TOGGLE THE SELECTED PORTA OUTPUT\n");
	putchar('?');
	
	}




/* 	Disables CLKOUT
	Sets SCLK = XTAL/2 and MCLK = SCLK/2
	Sets CAN bus rate to 250 kBits/s
	Sets message 1 to transmit
	Sets message 2 to receive
	
*/
/*	set CAN board as a sender	*/
	
void Init_can_s(void)
	{
	
	int t,x,i;
	
															
	while( (Read_can(0x02)) & 0x80 ) ;
	
		
	Send_can(0x02, 0x60) ;						/*	Set the CPU Interface Register
													to 40:
													SCLK = XTAL/2, MCLK = SCLK/2, 
	    											disables the CLKOUT signal.*/
	
	
		
	x = Read_can(0x0) ;
	x |= 0x41 ;
	Send_can(0x0, x) ;							/*	Sets the CCE (change configuration
													enable) bit in the Control Register	*/
							
													
	Send_can(0x2F, 0x48) ;						/*	Sets the Bit Configuration Register to 48.
													This bypasses the input comparator, sets
													logical one as recessive, and disables the
													TX1 driver. DCR0 and DCR1 are don't cares
													(set to 0 in this case)	*/
													
	
		
	Send_can(0x3F, 0x41) ;
	
	Send_can(0x4F, 0x67) ;						/*	Define the CAN bus frquency as 250kBits/s
													and the sampling mode.	*/
	
	Send_can(0x0, 0x01) ; 						/*	Clear the CCE bit, preventing write access
													of configuration redisters	*/										
									

	for(t = 0x10; t <= 0xf0; t = t + 0x10)
		{
		
		Send_can(t, 0x55) ;
		
		Send_can(t+1, 0x55) ;
		
		}										/*	This loop resets Control Register 0
													and 1	*/
	
		
	for(t = 0x06; t <= 0x0B; t++)
		{
		
		
		Send_can(t, 0xFF) ;
		
		}										/*	This loop sets the Global Mask (Standard
													and Extended) to must match	*/ 
			
	
	Send_can(0x16, 0x8C) ;
	Send_can(0x26, 0x84) ;						/*	Sets the Message Configure Registers for 
													message 1 and 2. This sets message 1 to 
													transmit eight bytes using an extended 
													identifier and sets message 2 to receive 
													eight bytes using an extended identifier*/
	
	
				
	for(x = 2 ; x <= 5 ; x++)
		{
		
		Send_can((0x10 + x), 0x8C) ;
			
		}										/*	Loads $8C into the arbitration registers*/
		
			
	for(x = 2 ; x <= 5 ; x++)
		{

		Send_can((0x20 + x), 0xC8) ;
		
		}										/*	Loads $C8 into the arbitration registers*/
	
	
	Send_can(0x10, 0x95) ;						/*	message1 valid	*/
	
	
	
	Send_can(0x20, 0x95) ;						/*	message2 vaild 	*/
	
	
	Send_can(0x0, 0x0) ;						/*	out of reset, irq	*/
		
	

	for(t = 1 ; t <= 4 ; t++); 
	
			                         
	}



/*	set CAN board as a receiver	*/

void Init_can_g(void)
	{
	
	int t,x,i;
	
															
	while( (Read_can(0x02)) & 0x80 ) ;
	
		
	Send_can(0x02, 0x60) ;						/*	Set the CPU Interface Register
													to 40:
													SCLK = XTAL/2, MCLK = SCLK/2, 
	    											disables the CLKOUT signal.*/
	
	
		
	x = Read_can(0x0) ;
	x |= 0x41 ;
	Send_can(0x0, x) ;							/*	Sets the CCE (change configuration
													enable) bit in the Control Register	*/
							
													
	Send_can(0x2F, 0x48) ;						/*	Sets the Bit Configuration Register to 48.
													This bypasses the input comparator, sets
													logical one as recessive, and disables the
													TX1 driver. DCR0 and DCR1 are don't cares
													(set to 0 in this case)	*/
													
	
		
	Send_can(0x3F, 0x41) ;
	
	Send_can(0x4F, 0x67) ;						/*	Define the CAN bus frquency as 250kBits/s
													and the sampling mode.	*/
	
	Send_can(0x0, 0x01) ; 						/*	Clear the CCE bit, preventing write access
													of configuration redisters	*/										
									

	for(t = 0x10; t <= 0xf0; t = t + 0x10)
		{
		
		Send_can(t, 0x55) ;
		
		Send_can(t+1, 0x55) ;
		
		}										/*	This loop resets Control Register 0
													and 1	*/
	
		
	for(t = 0x06; t <= 0x0B; t++)
		{
		
		
		Send_can(t, 0xFF) ;
		
		}										/*	This loop sets the Global Mask (Standard
													and Extended) to must match	*/ 
			
	
	Send_can(0x16, 0x8C) ;
	Send_can(0x26, 0x84) ;						/*	Sets the Message Configure Registers for 
													message 1 and 2. This sets message 1 to 
													transmit eight bytes using an extended 
													identifier and sets message 2 to receive 
													eight bytes using an extended identifier*/
	
	
				
	for(x = 2 ; x <= 5 ; x++)
		{
		
		Send_can((0x10 + x), 0xC8) ;
			
		}										/*	Loads $8C into the arbitration registers*/
		
			
	for(x = 2 ; x <= 5 ; x++)
		{

		Send_can((0x20 + x), 0x8C) ;
		
		}										/*	Loads $C8 into the arbitration registers*/
	
	
	Send_can(0x10, 0x95) ;						/*	message1 valid	*/
	
	
	
	Send_can(0x20, 0x99) ;						/*	message2 vaild, enable interrupt 	*/
	
	
	Send_can(0x0, 0x02) ;						/*	out of reset, irq	*/
		
	

	for(t = 1 ; t <= 4 ; t++); 
	
			                         
	}













/*	x:82527address; z:data	*/

void Send_can(unsigned char x, unsigned char z )
	{
	
	unsigned char y, i;
	
	PORTA &= encan ;
	
		
	while(Can_spi(x) != 0)
		{ 
	
		for(i = 0; i < 0x0F; i++)
			{
		
			Can_spi(0xFF);
			putchar('p');	
			}
		}
		
		
	while(Can_spi(scbw) != 0)
		{ 
	
		for(i = 0; i < 0x0F; i++)
			{
		
			Can_spi(0xFF);
			putchar('p');	
			}
		}
	
	
	Can_spi(z) ;
		
	PORTA |= discan ;
		
	}
	
	

/*	x:82527address; z:data	*/

unsigned char Read_can(unsigned char x)
	{
	
	unsigned char y, i;
	
	PORTA &= encan ;
	
	
	while(Can_spi(x) != 0)
		{
				
		for(i = 0; i < 0x0F; i++)
			{
	
			Can_spi(0xFF);
			putchar('p');
			}
		}



	while(Can_spi(scbr) != 0)
		{ 
	
		for(i = 0; i < 0x0F; i++)
			{
		
			Can_spi(0xFF);
			putchar('p');	
			}
		}



	y = Can_spi(0x11) ;

	PORTA |= discan ;
		
	return(y);

	}


/*	write data to CAN	*/

unsigned char Can_spi(unsigned char x)
	{
	
	unsigned y;
	
			
	y = SPSR ;
	y = SPDR ;					/*	clear flag and buffer	*/
		
				
	SPDR = x ; 
	
	while((SPSR & 0X80) == 0) ;
	
		
	
	y = SPSR ;
	y = SPDR ;			/*	clear flag and buffer	*/
	
	
	return(y);
	
	}	
	


void TestCan(void)
	{
	unsigned char i,x;
	
	Send_can(0x17, 0xFF);
	Send_can(0x11, 0x66);
	while((Read_can(0x01) & 0x10)==0);
	x = Read_can(0x01);
	x &= 0xEF;
	Send_can(0x01,x);
	
	for(i=0; i<20; i++)
		{
				
		Send_can(0x17, ta[i]);
		Send_can(0x11, 0x66);
		while((Read_can(0x01) & 0x10)==0);
		
		x = Read_can(0x01);
		
		x &= 0xEF;
		
		Send_can(0x01,x);
		
		}
	
	Send_can(0x17, 0x0);
	Send_can(0x11, 0x66);
	while((Read_can(0x01) & 0x10)==0);
	x = Read_can(0x01);
	x &= 0xEF;
	Send_can(0x01,x);
	
	}
















void Init_lcd(void)
	{
	
	unsigned char x;
	unsigned short i;
	
	PORTD &= 0xDF ;			/*	clear d5	*/
	
	x = SPSR ;
	x = SPDR ;		  	  /* clear flag and buffer	*/
	
	disp_flag = 0 ;
	disp_ptr = &disp_buffer[0] ;
	
	Delay();
	Delay();
	Delay();
	
	Toggle_lcd_ctrl(0x30);	/*	8 data bits, 2 display lines, 0	*/
	
	Small_delay();
	
	Toggle_lcd_ctrl(0x38);	/*	8 data bits, 2 display lines, 0	*/
	
	Small_delay();
	
	Toggle_lcd_ctrl(0x0C);	/*	display on, cursor off, blink off	*/
	
	Small_delay();
	
	Toggle_lcd_ctrl(0x01);	/*	Clear display and return cursor to home	*/
	
	Small_delay();	
	
	Toggle_lcd_ctrl(0x40);
	
	Small_delay();
	
	Toggle_lcd_ctrl(0x80);
	Small_delay();
	
	Disp_clear() ;
	
	Toggle_lcd_ctrl(0x02);
	Small_delay() ;
	
	Disp_updata() ;
	
	Delay();
	
	Toggle_lcd_ctrl(0x02);
	
	Delay();
	
	Toggle_lcd_data('o');
	
	Delay();
	
	Toggle_lcd_data('k');

	
	
	}
	
	
	
	
void Disp_clear(void)
	{
	
	unsigned char i ;
	 
	for( i=0 ; i < 80 ; i++)
		{
		
		disp_buffer[i] = BL ;	/*	fill buffer with spaced	*/
		
		}
		
		disp_flag = TRUE ;		/*	set flag for immediate display	*/
		
	}
	
	
void Dump_spi_data(char x)
	{
	
	char y;
	
	y = SPSR ;
	y = SPDR ;					/*	clear flag and buffer	*/
	
	SPDR = x ;
	
	while((SPSR & 0X80) == 0) ;
	
	y = SPSR ;
	y = SPDR ;
	
	}
		
	
	
void Delay(void)
	{
	
	unsigned short x;
	
	for(x=0 ; x < 0x2000; x++);
	
	}
	
void Small_delay(void)
	{
	
	unsigned short x ;
	for(x=0 ; x < 0x8; x++);
	
	}


void Toggle_lcd_ctrl(char x)
	{
	
	char i ;
	
	Dump_spi_data(x) ;
	
	PORTD |= 0x20 ;   	  	   /*	DRIVE SELECT OF 74HC595 HI	*/
	
	for(i=0 ; i < 4 ; i++);
	
	PORTD &= 0xDF ;	  	   	   /*	DRIVE SELECT OF 74HC595 LO	*/

	
	PORTA &= 0xBF ;			   /*	DIS_RS low	*/				
	    
	
	for(i=0 ; i < 4 ; i++);
	
	PORTA |= 0x20 ;	  	   	   /*	Pulse lcd enable	*/
	
	for(i=0 ; i < 4 ; i++);	
	
	PORTA &= 0xDF ;
	
	}
	

void Toggle_lcd_data(char x)
	{
	
	char i ;
	
	Dump_spi_data(x) ;
	
	PORTD |= 0x20 ;   	  	   /*	DRIVE SELECT OF 74HC595 HI	*/
	
	for(i=0 ; i < 4 ; i++);
	
	PORTD &= 0xDF ;	  	   	   /*	DRIVE SELECT OF 74HC595 LO	*/

	
	PORTA |= 0x40 ;			   /*	DIS_RS high	*/
	
	for(i=0 ; i < 4 ; i++);
	
	PORTA |= 0x20 ;	  	   	   /*	Pulse lcd enable	*/
	
	for(i=0 ; i < 4 ; i++);	
	
	PORTA &= 0xDF ;
	
	}
	

/*	update display
	This routine updates the LCD display from the display image in
	memory whenever the update flag is set.
*/
void Disp_updata(void)
	{
	
	unsigned i ;
	
	if(disp_flag)
		{
		
		Toggle_lcd_ctrl(0x02) ;	/*	home cursor	*/
		
		Delay();
		
		for(i=0 ; i < 20 ; i++)
			{
			Toggle_lcd_data(disp_buffer[i]) ;
			Small_delay();
			}
		for(i=0 ; i < 20 ; i++)
			{
			Toggle_lcd_data(disp_buffer[40+i]) ;
			Small_delay();
			}
		
		for(i=0 ; i < 20 ; i++)
			{
			Toggle_lcd_data(disp_buffer[20+i]) ;
			Small_delay();
			}
		
		for(i=0 ; i < 20 ; i++)
			{
			Toggle_lcd_data(disp_buffer[60+i]) ;
			Small_delay();
			}
				
				
		Toggle_lcd_ctrl(0x0C);	/*	display on, cursor off, blink off	*/
						
		}
		
		disp_flag = FALSE ;
		
		Toggle_lcd_ctrl(0x02) ;	/*	home cursor	*/
		Small_delay();
	}	






























/*  SCI Input Interrupt Handler

	Gets bytes from SCI.  Sets COMMAND_PENDING flag.	*/


void SCIHandler(void)
	{
		
	unsigned char x,y ;
	
		
	COMMAND = getchar();
	COMMAND_PENDING = TRUE ;

			
	x = SCSR;
	x = SCDR;
	
	}


/*  Output Compare Interrupt Handler	*/

void OC2Handler(void)
	{
		
	TOC2 += HALF_PERIOD ;
	TFLG1 = tc1msk ; 
	
	
	}
	
	
	


/*	Real-time Interrupt Routine	*/

void RTIHandler(void)
	{
	
	TFLG2 = 0x40 ;		/*	clear real-time interrupt flag	*/
	if(TIMER) TIMER--;
	
			
	}	



/*	interrupt service rountine for CAN arriving messages	*/

void CanHandler(void)
	{
	
	unsigned char x;
	
	
	x = Read_can(0x27);
	
	
	Send_can(0x21, 0x55) ;
	Send_can(0x20, 0xFD) ;					/*	reset IntPnd	*/
	
		
	if(HEAD_FLAG)
		{
		
		if(!x)
			{
	
			HEAD_FLAG = FALSE ;
			disp_flag = TRUE ;
			Disp_updata();
			
			}
			
		else
			{
			
				
			if(((disp_ptr - (&disp_buffer[0])) - 80) == 0)
				{
		
				Disp_clear();
		
				disp_ptr = &disp_buffer[0] ;
		
				}
			
			*disp_ptr = x ;
				
			disp_ptr++ ;
			
			}
		}
	
	else
		{
		
		if(!(x - 0xFF))
			{
			
			HEAD_FLAG = TRUE ;
			
			}
		}	
			
	if(!CAN_FLAG)
		{
		
		Send_can(0x17, x);
		Send_can(0x11, 0x66);
		
		}									/* if CAN board is a receiver, send the data back*/

	}




/* As is, all interrupts except reset jumps to 0xffff, which is most
 * likely not going to useful. To replace an entry, declare your function,
 * and then change the corresponding entry in the table. For example,
 * if you have a SCI handler (which must be defined with 
 * #pragma interrupt_handler ...) then in this file:
 * add
 *	extern void SCIHandler();
 * before th table.
 * In the SCI entry, change:
 *	DUMMY_ENTRY,
 * to
 *  SCIHandler, 
 */
extern void _start(void);	/* entry point in crt??.s */
extern void SCIHandler(void);
extern void OC2Handler(void);
extern void RTIHandler(void);

#define DUMMY_ENTRY	(void (*)(void))0xFFFF

#ifdef _HC12
#pragma abs_address:0xffd0
#else	/* HC11 */
#pragma abs_address:0xffd6
#endif

/* change the above address if your vector starts elsewhere
 */
void (*interrupt_vectors[])(void) = 
	{
	/* to cast a constant, say 0xb600, use
	   (void (*)())0xb600
	 */
#ifdef _HC12
	/* 812A4 vectors starts at 0xff80, but most entries are not used 
	   if you use Key Wakeup H, change the start address to 0xffCE and
	   add one entry to the beginning */
	DUMMY_ENTRY,	/* BDLC */			/* Key Wakeup J */
	DUMMY_ENTRY,	/* ATD */			/* ATD */
	DUMMY_ENTRY,	/* RESERVED */		/* SCI 1 */
#endif
	SCIHandler,	/* SCI */
	DUMMY_ENTRY,	/* SPI */
	DUMMY_ENTRY,	/* PAIE */
	DUMMY_ENTRY,	/* PAO */
	DUMMY_ENTRY,	/* TOF */
	DUMMY_ENTRY,	/* TOC5 */	/* HC12 TC7 */
	DUMMY_ENTRY,	/* TOC4 */	/* TC6 */
	DUMMY_ENTRY,	/* TOC3 */	/* TC5 */
	OC2Handler,	/* TOC2 */	/* TC4 */
	DUMMY_ENTRY,	/* TOC1 */	/* TC3 */
	DUMMY_ENTRY,	/* TIC3 */	/* TC2 */
	DUMMY_ENTRY,	/* TIC2 */	/* TC1 */
	DUMMY_ENTRY,	/* TIC1 */	/* TC0 */
	RTIHandler,	/* RTI */
	CanHandler,	/* IRQ */
	DUMMY_ENTRY,	/* XIRQ */
	DUMMY_ENTRY,	/* SWI */
	DUMMY_ENTRY,	/* ILLOP */
	DUMMY_ENTRY,	/* COP */
	DUMMY_ENTRY,	/* CLM */
	_start	/* RESET */
	};
#pragma end_abs_address













