*FILENAME:  B8S19.ASM (run convert for 1K; offset 65535)
*BOOTSTRAP DOWNLOADER PROGRAM
*Programs an S-record file into internal EEPROM, after doing bulk erase,
*via SCI at 1200 baud; for 8MHz 68HC811E2
*11 March 1998

* system addresses

rbase		equ	$1000		;power up register base address
STACK		equ	$00FF		;put stack at top of ram

DELAY		equ	$0D00		;10 ms for 8 MHz clock rate

*
* standard registers equates
*

portb	equ	rbase+$04	;output port
portd	equ	rbase+$08	;portd, serial communications
ddrd  	equ	rbase+$09	;data direction register, portd
tcnt  	equ	rbase+$0e  	;timer count
toc1  	equ	rbase+$16	;output compare, register 1 
toc2  	equ	rbase+$18	;output compare, register 2
tflg1	equ	rbase+$23	;main timer interrupt flags
tmsk2	equ	rbase+$24	;timer interrupt mask register, prescaler
baud  	equ	rbase+$2b	;sci baud rate control
sccr2	equ	rbase+$2d	;sci control register 2
scsr  	equ	rbase+$2e	;sci status register
scdr  	equ	rbase+$2f	;sci data, read (rdr) and write (tdr)
adctl	equ	rbase+$30	;a/d control register, not used
adr1  	equ	rbase+$31	;a/d channel 1 register, not used
bprot	equ	rbase+$35	;EEPROM block protect register
option 	equ	rbase+$39	;system options  	
pprog	equ	rbase+$3b	;EEPROM program control register
hprio	equ	rbase+$3c	;misc. control register
config	equ	rbase+$3f	;system configuration register

opts  	equ	%00011011	;a/d off, stop delay, clock monitor, 1 s COP

tmask	equ	%00000011	;timer prescale mask: E/16    
onmsk	equ	%10000000	;mask for timer flag, on time over
offmsk	equ	%11000000	;mask for timer flag, off time over

bdmsk12	equ	%00110011	;1200 baud with 8 MHz crystal

ptdmsk	equ 	%00000010	;portd data direction: input, except txd
sc2msk2	equ	%00001100	;mask to enable both transmit and receive
tdremsk	equ	%10000000	;transmitter ready flag
rdrfmsk	equ	%00100000	;receiver ready flag

	org	#$ffff

	fill	$ff,1		;send $FF to indicate bootstrap baudrate


TEMP1:		rmb	1	;note that variables overwrite boot code
TEMP2:		rmb	1

	org	0

init:
	clr	bprot		;enable programming of EEPROM & CONFIG reg.
	ldaa	#opts		;load in system options
	staa	option
	lds	#STACK	 	;initialize stack

	ldaa	#bdmsk12	;baud = 1200
	staa	baud
	ldaa	#sc2msk2	;disable interrupts, enable rcvr. & xmtr.
	staa	sccr2

F800
	ldx	#$f800		;do bulk erase of EEPROM
	bsr	EraseEEPROM	;erase internal EEPROM block

M0:
	bsr	GetChar		;look for S record
	cmpa	#'S
	bne	M0
	bsr	GetChar
	cmpa	#'1		;if not S1 record then
	beq	Load1

	cmpa	#'9		;if S9 record then
	bne	M0
	bsr	GetByte		;get byte count
	tab
	subb	#2
	bsr	GetAddress	;get execution address
Load9:
	bsr	GetByte		;get checksum byte (and ignore it)
	decb
	bne	Load9
	cpy	#0
	beq	*
	jmp	0,Y		;start execution at user address


Load1:

	bsr	GetByte		;S1 record so get byte count
	tab
	subb	#3		;adjust for address and checksum bytes
	bsr	GetAddress	;get address
	dey			;adjust address for L1B loop
	bra	L1B

L1B:

	bsr	GetByte		;repeat
	iny			;  get a byte and write it to EEPROM
	jsr	Write		;  increment EEPROM address
	decb			;  decrement # of bytes
	bne	L1B		;until all bytes in record programmed
	bra	M0		;get next S-record

***********************************************************************
*Procedure Definitions:
***********************************************************************

EraseEEPROM:

*  Performs bulk erase on HC11 internal EEPROM starting at address in x

	ldab	#$10	;unprotect EEPROM
	stab	bprot
	ldab	#$6
	stab	pprog	;select bulk erase mode
	stab	0,x	;write to EEPROM location
	ldab	#$7
	stab	pprog	;turn on programming voltage
	bsr	Delay_10_ms
	clr	pprog	;turn off programming voltage
	rts


GetChar:

*  Fetches one character from the SCI, 
*  and returns it in register A.  

GC1:

	ldaa	scsr		;get sci flags
	anda	#rdrfmsk	;mask off irrelevant bits
	beq	GC1		;loop until character found
	ldaa	scdr		;get character
	rts

GetByte:

*  Converts 2 hex characters to a single byte value, 
*  and returns it in register A.

GB1:
	bsr	GetChar
	bsr	Hex2Bin
	lsla
	lsla
	lsla
	lsla
	staa	TEMP1
	bsr	GetChar
	bsr	Hex2Bin
	oraa	TEMP1
	rts


Hex2Bin:

*  Converts an ASCII hex character in register A
*  to a binary nibble and returns it in register A.

	cmpa	#'9
	bls	HEX
	adda	#9
HEX:	anda	#$f
	rts

GetAddress:

* Extracts load address and returns it in register Y.

	pshb			;preserve byte count
	bsr	GetByte
	staa	TEMP2
	bsr	GetByte
	tab
	ldaa	TEMP2
	xgdy
	pulb
	rts	
	

Write:

*  Writes the value contained in register A to the address pointed to
*  by register Y.

	pshb			;preserve byte count
	ldab	#$02
	stab	pprog
	staa	0,Y
	ldab	#$03
	stab	pprog
	jsr	Delay_10_ms
	clr	pprog
	pulb
	rts


Delay_10_ms:
	ldx	#DELAY
D1:
	dex
	bne	D1
	rts

