* FILENAME:  B75S19R1.ASM (run convert for 1K; offset 65535)
* 68HC11 MICRO-CONTROLLER BOOTLOADER FOR XICOR X68C75 EEPROM
* Rev. 1
* 6 February 1997
*
* Summary of changes:
*
* 1)  Sets stack pointer to $ff to permit use with HC11s having only 256 bytes
*     of RAM (eg. 68HC811E2)
* 2)  Disables SDP, writes file to EEPROM, & re-locates SFRM to $8400, auto-
*     matically enabling SDP.
*
* FUNCTION:
* Disables SDP;  programs an S-record file into X68C75 EEPROM (via 68HC11 A-
* or E- series chip running in BOOT mode at 8 MHz). Relocates the Special
* Function Register block of the X68C75 to $8400.  This automatically
* re-enables SDP.  If desired, SDP can be disabled via sdpoff.bat.
*
* DESCRIPTION:
* The X68C75 EEPROM bytes take up to 5 ms to be written.  With s-record
* files, two ASCII character are transmitted for each byte of data to be
* programmed.  This gives ample time to decode and write each location.
* Note that it is up to the user to make sure the target locations specified
* in the S-records match the actual EEPROM location in the memory map.  The
* default is $e000 - $ffff, as shipped from the factory.  See Xicor datasheet
* for further information on relocating the EEPROM, enabling Block Protect, and
* enabling SDP.
*
* Revision 1
* COPYRIGHT 1997 TECHNOLOGICAL ARTS
* 7 February 1997
*
* This program is freely distributable as long as it remains intact and
* includes the copyright notice.
*
* Our mailing address:
* Technological Arts
* 1644 Bayview Ave., Suite 1704
* Toronto, Ontario, Canada  M4G 3C2
* Voice/fax:  (416) 963-8996
* email:  techart@interlog.com
* URL:  http://www.interlog.com/~techart

* system addresses

rbase		equ	$1000		;68HC11 power-up register base address
STACK		equ	$00FF		;ensure compatibility with 68HC811E2
DELAY		equ	$0100		;about 1 ms for 8 MHz clock rate

sdphi55		equ	$f555		;special addresses for SDP
sdplo55		equ	$e555
sdphiaa		equ	$faaa
sdploaa		equ	$eaaa
sfrm		equ	$a1		;value to write for $8400

*
* registers
*

portd	equ	rbase+$08	;portd, serial communications
ddrd  	equ	rbase+$09	;data direction register, portd
tcnt  	equ	rbase+$0e  	;timer count
toc1  	equ	rbase+$16	;output compare, register 1 
toc2  	equ	rbase+$18	;output compare, register 2
tflg1	equ	rbase+$23	;main timer interrupt flags
tmsk2	equ	rbase+$24	;timer interrupt mask register, prescaler
baud  	equ	rbase+$2b	;sci baud rate control
sccr2	equ	rbase+$2d	;sci control register 2
scsr  	equ	rbase+$2e	;sci status register
scdr  	equ	rbase+$2f	;sci data, read (rdr) and write (tdr)
option 	equ	rbase+$39	;system options  	
hprio	equ	rbase+$3c	;highest priority I-bit interrupt & misc.
config	equ	rbase+$3f	;68HC11 system configuration register

ptdmsk	equ 	%00000010	;portd data direction: input, except txd
sc2msk2	equ	%00001100	;SCI mask to enable both transmit and receive
tdremsk	equ	%10000000	;transmitter ready flag
rdrfmsk	equ	%00100000	;receiver ready flag
bdmsk24	equ	%00110010	;(baud) 2400 baud with 8 MHz crystal
bdmsk12	equ	%00110011	;(baud) 1200 baud with 8 MHz crystal


	org	#$ffff

	fill	$ff,1		;$FF requiured to start bootstrap comm.


BYTES_LEFT:	rmb	2	;note that variables overwrite boot code
NEXT_BYTE:	rmb	2
TEMP1:		rmb	1
TEMP2:		rmb	1
ADDRESS:	rmb	2

	org	0

init:
	lds	#STACK	 	;initialize stack
	ldaa	#$20		;put MCU in expanded mode
	staa	hprio

	ldaa	#bdmsk12	;set baud rate to 1200
	staa	baud
	ldaa	#sc2msk2
	staa	sccr2		;enable rcvr. & xmtr. for polled operation

main:
	jsr	SDP_Disable
M0:
	bsr	GetChar		;look for S record
	cmpa	#'S
	bne	M0
	bsr	GetChar
	cmpa	#'1		;if not S1 record then
	beq	Load1

	cmpa	#'9		;if S9 record then
	bne	M0
	bsr	GetByte		;  get byte count
	tab
	subb	#2
	bsr	GetAddress	;  get execution address
Load9:
	bsr	GetByte		;  get checksum byte (and ignore it)
	decb
	bne	Load9
	jsr	WriteHiPre
	jsr	WriteSFRM
	beq	*		;  loop waiting for user reset

Load1:
	bsr	GetByte		;S1 record so get byte count
	tab
	subb	#3		;adjust for address and checksum bytes
	bsr	GetAddress	;get address
	dey			;adjust address for L1B loop

L1B:
	bsr	GetByte		;repeat
	iny			;  get a byte and write it to EEPROM
	bsr	Write		;  increment EEPROM address
	decb			;  decrement # of bytes
	bne	L1B		;until all bytes in record programmed
	bra	M0		;get next S-record

***********************************************************************
*Procedure Definitions:
***********************************************************************


GetChar:

*  Fetches one character from the SCI, 
*  and returns it in register A.  

GC1:
	ldaa	scsr		;get sci flags
	anda	#rdrfmsk	;mask off irrelevant bits
	beq	GC1		;loop until character found
	ldaa	scdr		;get character
	rts


GetByte:

*  Converts 2 hex characters to a single byte value, 
*  and returns it in register A.

GB1:
	bsr	GetChar
	bsr	Hex2Bin
	lsla
	lsla
	lsla
	lsla
	staa	TEMP1
	bsr	GetChar
	bsr	Hex2Bin
	oraa	TEMP1
	rts


Hex2Bin:

*  Converts an ASCII hex character in register A
*  to a binary nibble and returns it in register A.

	cmpa	#'9
	bls	HEX
	adda	#9
HEX:	anda	#$f
	rts


GetAddress:

* Extracts load address from S-record and returns it in register Y.

	pshb			;preserve byte count
	bsr	GetByte
	staa	TEMP2
	bsr	GetByte
	tab
	ldaa	TEMP2
	xgdy
	pulb
	rts	
	

Write:

*  Writes the value contained in register A to the (EEPROM) address pointed to
*  by register Y.  Note that this will also work with RAM but the Enable
*  function has no effect.

	staa	0,y
	jsr	Delay_ms
	rts


WriteHiPre:

	ldab	#$aa
	stab	sdphi55

	ldab	#$55
	stab	sdphiaa

	ldab	#$a0
	stab	sdphi55

	ldab	#$aa
	stab	sdphi55

	ldab	#$d0
	stab	sdphiaa

	rts


WriteSFRM:

	ldab	#sfrm		;write new SFRM value to any address
	stab	sdphiaa
	jsr	Delay_ms
	rts


SDP_Disable:

* Writes special byte sequence to disable SDP in both 4K planes

	ldab	#$aa
	stab	sdplo55

	ldab	#$55
	stab	sdploaa

	ldab	#$a0
	stab	sdplo55

	ldab	#$aa
	stab	sdplo55

	ldab	#$80
	stab	sdploaa

	jsr	Delay_ms

	jsr	WriteHiPre

	ldab	#$80
	stab	sdphiaa

	jsr	Delay_ms
	rts


Delay_ms:
	ldx	#DELAY
D1:
	dex
	bne	D1
	rts
