* FILENAME:  BPOFF.ASM (run convert for 1K; offset 65535)
* 68HC11 MICRO-CONTROLLER BOOTLOADER FOR XICOR X68C75 EEPROM
* Rev. 0
* 15 February 1997
*
*
* FUNCTION:
* Unprotects all blocks of the EEPROM in the X68C75 chip.
*
* Revision 0
* COPYRIGHT 1997 TECHNOLOGICAL ARTS
* 15 February 1997
*
* This program is freely distributable as long as it remains intact and
* includes the copyright notice.
*
* Our mailing address:
* Technological Arts
* 1644 Bayview Ave., Suite 1704
* Toronto, Ontario, Canada  M4G 3C2
* Voice/fax:  (416) 963-8996
* email:  techart@interlog.com
* URL:  http://www.interlog.com/~techart

* system addresses

rbase		equ	$1000		;68HC11 power-up register base address
STACK		equ	$00FF		;ensure compatibility with 68HC811E2
DELAY		equ	$0100		;about 1 ms for 8 MHz clock rate

sdphi55		equ	$f555		;special addresses for block protect
sdplo55		equ	$e555
sdphiaa		equ	$faaa
sdploaa		equ	$eaaa

*
* registers
*

portd	equ	rbase+$08	;portd, serial communications
ddrd  	equ	rbase+$09	;data direction register, portd
tcnt  	equ	rbase+$0e  	;timer count
toc1  	equ	rbase+$16	;output compare, register 1 
toc2  	equ	rbase+$18	;output compare, register 2
tflg1	equ	rbase+$23	;main timer interrupt flags
tmsk2	equ	rbase+$24	;timer interrupt mask register, prescaler
baud  	equ	rbase+$2b	;sci baud rate control
sccr2	equ	rbase+$2d	;sci control register 2
scsr  	equ	rbase+$2e	;sci status register
scdr  	equ	rbase+$2f	;sci data, read (rdr) and write (tdr)
option 	equ	rbase+$39	;system options  	
hprio	equ	rbase+$3c	;highest priority I-bit interrupt & misc.
config	equ	rbase+$3f	;68HC11 system configuration register

ptdmsk	equ 	%00000010	;portd data direction: input, except txd
sc2msk2	equ	%00001100	;SCI mask to enable both transmit and receive
tdremsk	equ	%10000000	;transmitter ready flag
rdrfmsk	equ	%00100000	;receiver ready flag
bdmsk24	equ	%00110010	;(baud) 2400 baud with 8 MHz crystal
bdmsk12	equ	%00110011	;(baud) 1200 baud with 8 MHz crystal


	org	#$ffff

	fill	$ff,1		;$FF requiured to start bootstrap comm.


	org	0

init:
	lds	#STACK	 	;initialize stack
	ldaa	#$20		;put MCU in expanded mode
	staa	hprio

main:
	jsr	Unprotect	;clear block protect register

	bra	*		;wait for reset

***********************************************************************
*Procedure Definitions:
***********************************************************************

Unprotect:

* Writes special byte sequence to clear the Block Protect Register (BPR)

	ldab	#$aa
	stab	sdplo55
	ldab	#$55
	stab	sdploaa
	ldab	#$a0
	stab	sdplo55
	ldab	#$aa
	stab	sdplo55
	ldab	#$c0
	stab	sdploaa
	ldab	#$00		;write desired BPR value to any address
	stab	sdploaa
	bsr	Delay_ms

	ldab	#$aa
	stab	sdphi55
	ldab	#$55
	stab	sdphiaa
	ldab	#$a0
	stab	sdphi55
	ldab	#$aa
	stab	sdphi55
	ldab	#$c0
	stab	sdphiaa
	ldab	#$00		;write desired BPR value to any address
	stab	sdploaa
	bsr	Delay_ms
	rts


Delay_ms:
	ldx	#DELAY
D1:
	dex
	bne	D1
	rts
