* FILENAME:  BSDPOFF1.ASM (run convert for 1K; offset 65535)
* 68HC11 MICRO-CONTROLLER BOOTLOADER FOR XICOR X68C75 EEPROM
* Rev. 1
* 30 May 1997
*
*
* FUNCTION:
* Disables Software Data Protection (SDP) of the EEPROM in the X68C75 chip.
* Now works with any 1K SFR block address and EEPROM at any 8K boundary
*
* Revision 1
* COPYRIGHT 1997 TECHNOLOGICAL ARTS
*
* This program is freely distributable as long as it remains intact and
* includes the copyright notice.
*
* Our mailing address:
* Technological Arts
* 1644 Bayview Ave., Suite 1704
* Toronto, Ontario, Canada  M4G 3C2
* Voice/fax:  (416) 963-8996
* email:  techart@interlog.com
* URL:  http://www.interlog.com/~techart

* system addresses

rbase		equ	$1000		;68HC11 power-up register base address
STACK		equ	$00FF		;ensure compatibility with 68HC811E2
DELAY		equ	$0100		;about 1 ms for 8 MHz clock rate

*
* registers
*

portd	equ	rbase+$08	;portd, serial communications
ddrd  	equ	rbase+$09	;data direction register, portd
tcnt  	equ	rbase+$0e  	;timer count
toc1  	equ	rbase+$16	;output compare, register 1 
toc2  	equ	rbase+$18	;output compare, register 2
tflg1	equ	rbase+$23	;main timer interrupt flags
tmsk2	equ	rbase+$24	;timer interrupt mask register, prescaler
baud  	equ	rbase+$2b	;sci baud rate control
sccr2	equ	rbase+$2d	;sci control register 2
scsr  	equ	rbase+$2e	;sci status register
scdr  	equ	rbase+$2f	;sci data, read (rdr) and write (tdr)
option 	equ	rbase+$39	;system options  	
hprio	equ	rbase+$3c	;highest priority I-bit interrupt & misc.
config	equ	rbase+$3f	;68HC11 system configuration register

ptdmsk	equ 	%00000010	;portd data direction: input, except txd
sc2msk2	equ	%00001100	;SCI mask to enable both transmit and receive
tdremsk	equ	%10000000	;transmitter ready flag
rdrfmsk	equ	%00100000	;receiver ready flag
bdmsk24	equ	%00110010	;(baud) 2400 baud with 8 MHz crystal
bdmsk12	equ	%00110011	;(baud) 1200 baud with 8 MHz crystal


	org	#$ffff

	fill	$ff,1		;$FF requiured to start bootstrap comm.


	org	0

TEMP	rmb	2		;note that variables will overwrite code
EEM	rmb	1		; that has already been executed
LO55	rmb	2
HI55	rmb	2
LOAA	rmb	2
HIAA	rmb	2

	org	0

init:
	lds	#STACK	 	;initialize stack
	ldaa	#$20		;put MCU in expanded mode
	staa	hprio

main:
	jsr	Find_EEPROM	;determine EEM bits

	ldd	#$1555		;set up special addresses for SDP
	oraa	EEM
	std	HI55
	ldd	#$0555
	oraa	EEM
	std	LO55
	ldd	#$1aaa
	oraa	EEM
	std	HIAA
	ldd	#$0aaa
	oraa	EEM
	std	LOAA

	jsr	SDP_Disable	;turn off SDP

	bra	*		;wait for reset

***********************************************************************
*Procedure Definitions:
***********************************************************************

Find_EEPROM:
	ldx	#0
Find_SFRM:
	ldaa	0,x		;search memory in 1K increments for SFR block
	coma			;extract upper 5-bits of SFRM address
	asla
	asla
	clrb
	std	TEMP
	cpx	TEMP		;if they match then SFRM has been found
	beq	Read_EEM	;  else
	xgdx			;    increment compare address by 1K
	adda	#$04
	xgdx
	bra	Find_SFRM	;    and try again

Read_EEM:
	ldaa	$38,x		;read the EEM register
	coma
	asla
	asla
	asla
	asla
	asla
	staa	EEM		;high order address of 8K EEPROM block
	rts


SDP_Disable:

* Writes special byte sequence to disable SDP in both 4K planes

	ldy	LO55
	ldab	#$aa
	stab	0,y

	ldy	LOAA
	ldab	#$55
	stab	0,y

	ldy	LO55
	ldab	#$a0
	stab	0,y

	ldy	LO55
	ldab	#$aa
	stab	0,y

	ldy	LOAA
	ldab	#$80
	stab	0,y

	jsr	Delay_ms

	ldy	HI55
	ldab	#$aa
	stab	0,y

	ldy	HIAA
	ldab	#$55
	stab	0,y

	ldy	HI55
	ldab	#$a0
	stab	0,y

	ldy	HI55
	ldab	#$aa
	stab	0,y

	ldy	HIAA
	ldab	#$80
	stab	0,y

	bsr	Delay_ms
	rts


Delay_ms:
	ldx	#DELAY
D1:
	dex
	bne	D1
	rts
