*filename: c75demo1.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE		REV. NO.	DESCRIPTION
*
* 6/21/96	0		Initial release
* 12/10/96	1		corrected reading of portc pins (68C75 port b)
*
*******************************************************************************
*TECHNOLOGICAL ARTS
*ADAPT-11C75 & ADAPT-11C75DX DEMO SOFTWARE
*21 JUNE 1996
*by CARL BARNES

* System Addresses

XEEPROM		equ	$e000		;X68C75 EEPROM
SFRbase		equ	$8400		;X68C75 special register block
XRAM		equ	SFRbase+$0200	;16-byte RAM block in X68C75

SRAM	equ	$0000		;external SRAM (ADAPT-11C75DX only)

* 68HC11 internal RAM & reg. blocks will be remapped as follows by altering
* the init register to $89 within the first 64 clock cycles after reset

RAM	equ	$8000		;68HC11E0 internal RAM
rbase	equ	$9000		;68HC11E0 register block
STACK	equ	RAM+$1FF	;put stack at top of internal ram

*  Operational Parameters

_100MS		equ	25
_250MS		equ	61
_500MS		equ	125
_1SECOND	equ	250
_2SECONDS	equ	500
_3SECONDS	equ	750
_5SECONDS	equ	1250
_10SECONDS	equ	2500
_25SECONDS	equ	6250
_60SECONDS	equ	15000
_2MIN		equ	30000

* Operational Constants

TRUE		equ	$FF
FALSE		equ	$00
CR		equ	$D
LF		equ	$A
SP		equ	$20

	org	RAM

* System Variables

COMMAND		rmb	1	;used by ProcessCommand

H		rmb	1	;used in binary to decimal conversion
TO		rmb	1

DURATION	rmb	2	;used for tone generation
HALF_PERIOD	rmb	2

TIMER		rmb	2	;software timers using RTI
TIMER1		rmb	2

* Boolean Variables

COMMAND_PENDING	rmb	1	;used by ProcessCommand

CONTINUOUS	rmb	1	;flag for real-time a/d screen update

TONE_2K		equ	500	;frequencies in Hertz for tone generation
TONE_1K		equ	1000
TONE_440	equ	2272
TONE_220	equ	4545
TONE_180	equ	3000
TONE_110	equ	9090
TONE_60		equ	16666

* registers

**********************************************************************
*	PORT ASSIGNMENTS for this program

porta	equ	rbase+0		;input/output port of 68HC11E0

*	PA0	spare		;input only
*	PA1	spare		;input only
*	PA2	spare		;input only
*	PA3	spare		;input or output
*	PA4	spare		;output only
*	PA5	spare		;output only
*	PA6	SPEAKER		;output only
*	PA7	spare		;input or output
**********************************************************************

* X68C75 registers

* Note:  for consistent nomenclature among ADAPT-11 modules, and since
* the 68HC11 already has a porta, the two I/O ports of the X68C75 (PORTA
* & PORTB) are renamed portb and portc, respectively.

pdrb	equ	SFRbase+$10	;portb data reg. (X68C75 PORTA)
pdrc	equ	SFRbase+$08	;portc data reg. (X68C75 PORTB)
pprb	equ	SFRbase+$30	;portb pins reg. (X68C75 PORTA)
pprc	equ	SFRbase+$28	;portc pins reg. (X68C75 PORTB)
isr	equ	SFRbase+$18	;X68C75 interrupt status register
cr	equ	SFRbase+$20	;X68C75 configuration register

* HC11 registers

pioc	equ	rbase+$02	;parallel i/o control register
portd	equ	rbase+$08	;portd, serial communications
ddrd  	equ	rbase+$09	;data direction register, portd
oc1m	equ	rbase+$0c	;output compare 1 mask register, porta
tcnt  	equ	rbase+$0e  	;timer count
toc1  	equ	rbase+$16	;output compare register 1 
toc2  	equ	rbase+$18	;output compare register 2
toc3  	equ	rbase+$1A	;output compare register 3
toc4  	equ	rbase+$1C	;output compare register 4
tctl1	equ	rbase+$20	;timer control register
tmsk1	equ	rbase+$22	;OC/IC interrupt mask register
tflg1	equ	rbase+$23	;main timer interrupt flags
tmsk2	equ	rbase+$24	;timer interrupt mask register, prescaler
tflg2	equ	rbase+$25	;timer interrupt flag register 2
pactl	equ	rbase+$26	;real time interrupt prescaler, pulse accum.
baud  	equ	rbase+$2b	;sci baud rate control
sccr1	equ	rbase+$2c	;sci control register 1
sccr2	equ	rbase+$2d	;sci control register 2
scsr  	equ	rbase+$2e	;sci status register
scdr  	equ	rbase+$2f	;sci data, read (rdr) and write (tdr)

*Analog-to-Digital Converter

adctl	equ	rbase+$30	;a/d control register
adr1  	equ	rbase+$31	;a/d channel 1 register
adr2  	equ	rbase+$32	;a/d channel 2 register
adr3  	equ	rbase+$33	;a/d channel 3 register
adr4  	equ	rbase+$34	;a/d channel 4 register

option 	equ	$1039		;system options  	
pprog	equ	rbase+$3b	;EEPROM program control register
hprio	equ	rbase+$3c	;highest priority interrupt
init	equ	$103d		;RAM & register block mapping

* Masks
opts  	equ	%10010000	;a/d on
admask1	equ	%00110000	;(adctl)continuous conversion, AD0 thru AD3
admask2	equ	%00110100	;(adctl)continuous conversion, AD4 thru AD7
tmask	equ	%01000000	;(tmsk2)no timer prescale, RTI enabled
rtimsk	equ	%00001000	;(pactl) 4.1 msec interrupt with 8 MHz xtal
tc1msk	equ	%01000000	;OC2 in toggle mode

clrmsk	equ	%11000000	;mask for clearing timer flags
bdmsk96	equ	%00110000	;(baud) 9600 baud with 8 MHz crystal
bdmsk24	equ	%00110010	;(baud) 2400 baud with 8 MHz crystal
bdmsk12	equ	%00110011	;(baud) 1200 baud with 8 MHz crystal
ptdmsk	equ 	%00000010	;(ddrd)portd data direction: input, except txd
sc2msk2	equ	%00101100	;(sccr2)enable tx & rx and Rx Interrupt

********************************** Program *******************************

	org	XEEPROM

start:

	sei			;this is where the RESET vector points

*NOTE-  These instructions must be executed within 64 E-cycles of reset.

	ldaa	#opts		;define system options
	staa	option
	ldaa	#$89		;move HC11 RAM & register block
	staa	init		; to $8000 & $9000, respectively


	lds	#STACK	 	;initialize stack pointer

	ldaa	#admask1	;set A/D to scan AD0 thru AD3 continuously
	staa	adctl
	ldaa	#tmask		;enable real-time interrupt (RTI)
	staa	tmsk2

	ldaa	#rtimsk		;initialize RTI rate
	staa	pactl

	ldaa	cr		;initialize portb as output port
	oraa	#%00001000
	staa	cr

	ldaa	#ptdmsk		;initialize PORTD
	staa 	ddrd
	ldaa	#bdmsk24	;baud=2400
	staa	baud
	ldaa	#sc2msk2
	staa	sccr2		;enable SCI rcvr. & xmtr. & rx int.
	ldaa	scdr		;dummy read to flush receive buffer

	clr	COMMAND_PENDING
	clr	CONTINUOUS

	cli			;unmask interrupts

	ldx	#TONE_440	;generate two 100 millisecond beeps @ 440 Hz
	ldab	#2		; (connect speaker to PA6)
	ldy	#_100MS
	jsr	PulseXToneB

main:

	jsr	ProcessCommand		;this is the program loop
	ldaa	CONTINUOUS
	beq	NotCont
	jsr	ShowAnalog

NotCont
	bra	main


***********************************************************************
*Procedure Definitions:
***********************************************************************

WaitX:
	stx	TIMER1		;delays a length of time defined by x
W1	ldx	TIMER1		; (note that whenever TIMER1 is non-zero,
	bne	W1		; it is decremented in the RTI interrupt
	rts			; service routine)

PulseXToneB:

* b contains number of beeps desired
* x contains tone frequency
* y contains tone duration (eg. if y=1  => duration=4.1 ms; y=255 => 1 sec)

	sty	DURATION
rpt
	jsr	EnableToneX	;tone generated via OutputCompare feature
	ldy	DURATION
	sty	TIMER
d2_1	ldy	TIMER
	bne	d2_1
	clr	tmsk1		;turn off tone
	clr	tctl1
	ldy	DURATION
	sty	TIMER
d2_2	ldy	TIMER
	bne	d2_2
	decb
	bne	rpt
	rts


ProcessCommand:

	ldaa	COMMAND_PENDING		;commands received via SCI interrupt
	cmpa	#TRUE
	beq	Process
	jmp	PCX
Process
	clr	COMMAND_PENDING	
	clr	CONTINUOUS
	jsr	PutNewLine
	ldaa	COMMAND

	cmpa	#'A
	beq	PCA
	cmpa	#'a
	beq	PCA

	cmpa	#'B
	beq	PCB
	cmpa	#'b
	beq	PCB

	cmpa	#'C
	beq	PCC
	cmpa	#'c
	beq	PCC

	cmpa	#'D
	beq	PCD
	cmpa	#'d
	beq	PCD

	cmpa	#'R
	beq	PCR
	cmpa	#'r
	beq	PCR

	cmpa	#'S
	beq	PCS
	cmpa	#'s
	beq	PCS

	cmpa	#'0
	blo	PCM
	cmpa	#'7
	bhi	PCM
	jsr	ToggleBLine
	bra	PCX

PCM
	jsr	ShowMenu
	bra	PCX

PCA
	ldx	#M_PORTA
	jsr	SendString
	ldab	porta
	clra
	jsr	SendDecByte
	jsr	PutNewLine
	bra	PCX

PCB
	clr	pdrb
	ldx	#M_BOFF
	jsr	SendString
	jsr	PutNewLine
	bra	PCX

PCC
	ldx	#M_PORTC
	jsr	SendString
	ldab	pprc
	clra
	jsr	SendDecByte
	jsr	PutNewLine
	bra	PCX
	
PCD
	ldx	#M_PORTD
	jsr	SendString
	ldab	portd
	clra
	jsr	SendDecByte
	jsr	PutNewLine
	bra	PCX

PCR
	staa	CONTINUOUS	;set continuous a/d display flag
	bra	PCX

PCS
	ldx	#M_BEEP		;beep speaker (if connected to PA6)
	jsr	SendString
	jsr	PutNewLine
	ldx	#TONE_440	;generate two 100 millisecond beeps @ 440 Hz
	ldab	#2
	ldy	#_100MS
	jsr	PulseXToneB
*	bra	PCX

PCX
	rts


ToggleBLine:

	ldab	#1		;number is between 0 and 7
	suba	#'0		;convert ASCII digit to binary number
	beq	TBL1
TBL0
	aslb			;set the appropriate mask bit
	deca
	bne	TBL0
TBL1
	bitb	pdrb		;if designated port bit is 1
	beq	TBM1		;  then make it 0
	comb
	bra	TBM0
TBM1
	orab	pdrb
	stab	pdrb
	rts
TBM0
	andb	pdrb
	stab	pdrb	
	rts


ShowMenu:
	jsr	PutDblLine
	ldx	#M_UNDLN
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_HEADER1
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_UNDLN
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_LINE1
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_LINE2
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_LINE3
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_LINE4
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_LINE5
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_LINE6
	jsr	SendString
	jsr	PutNewLine	
	ldx	#M_LINE7
	jsr	SendString
	jsr	PutDblLine	
	ldx	#M_PROMPT
	jsr	SendString
	rts

ShowAnalog:

	ldaa	#admask1
	staa	adctl

	ldx	#M_AD0
	jsr	SendString
	ldab	adr1
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldx	#M_AD1
	jsr	SendString
	ldab	adr2
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldx	#M_AD2
	jsr	SendString
	ldab	adr3
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldx	#M_AD3
	jsr	SendString
	ldab	adr4
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldaa	#admask2
	staa	adctl

	ldx	#M_AD4
	jsr	SendString
	ldab	adr1
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldx	#M_AD5
	jsr	SendString
	ldab	adr2
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldx	#M_AD6
	jsr	SendString
	ldab	adr3
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldx	#M_AD7
	jsr	SendString
	ldab	adr4
	clra
	jsr	SendDecByte

	ldaa	#CR
	jsr	SendByte
	rts


HexByte2Dec:

*		Supply hex value to be converted in B register
	clra
	ldx	#100	;numerator in D, denominator in X
	idiv
*		remainder in D, quotient in X
*		B is lo-order byte
	xgdx
	stab	H	;8 bit quotient in B
	xgdx
	ldx	#10	;H=0X  TO=packed BCD
	idiv
	stab	TO
	xgdx
	aslb
	aslb
	aslb
	aslb
	orab	TO
	stab	TO
	rts

SendDecByte:

* value is in B

	clra
	jsr	HexByte2Dec
	ldaa	H
	adda	#'0
	jsr	SendByte
	ldaa	TO
	jsr	SendASCIIHex
	rts

SendASCIIHex:
*	value in A

	psha
	anda	#$F0
	lsra
	lsra
	lsra
	lsra
	cmpa	#$A
	blt	SAH1
	suba	#$A
	adda	#'A
	bra	SAH2
SAH1:
	adda	#'0
SAH2:
	jsr	SendByte
	pula
	psha
	anda	#$0F
	cmpa	#$A
	blt	SAH3
	suba	#$A
	adda	#'A
	bra	SAH4
SAH3:
	adda	#'0
SAH4:
	jsr	SendByte
	pula
	rts


SendByte:

*  Transmits a byte, contained in register A, to the serial device via the SCI.

SB1
	ldab	scsr	;wait for transmit data register empty (TDRE)
	bpl	SB1
	staa	scdr	;send byte
	rts

PutNewLine:

	ldaa	#CR
	jsr	SendByte
	ldaa	#LF
	jsr	SendByte
	rts

PutDblLine:

	ldaa	#CR
	jsr	SendByte
	ldaa	#LF
	jsr	SendByte
	ldaa	#LF
	jsr	SendByte
	rts


SendString:

*	x contains starting address of string
RV1:
	ldaa	0,X		;$FF denotes end of string
	cmpa	#$FF
	beq	RVX
	jsr	SendByte
	inx
	bra	RV1
RVX:
	rts	


EnableToneX:

	sei			;tone generation done via OutputCompare
	stx	HALF_PERIOD
	ldaa	#tc1msk
	staa	tctl1
	staa	tflg1
	staa	tmsk1
	cli
	rts


*******************************************************************************
*  Interrupt Routines
*******************************************************************************

* Real-time Interrupt Routine

RealTimeInt:

RTI_1
	ldx	TIMER
	beq	RTI_2
	dex
	stx	TIMER
RTI_2
	ldx	TIMER1
	beq	RTI_3
	dex
	stx	TIMER1
RTI_3
	ldaa	#%01000000		;clear real-time interrupt flag
	staa	tflg2
	rti

*  SCI Input Interrupt Handler

*  Gets bytes from SCI.  Sets COMMAND_PENDING flag.

SerInputInt:

	ldaa	scsr		;clear RDRF
	ldaa	scdr
	staa	COMMAND
	ldaa	#TRUE
	staa	COMMAND_PENDING
SIIX:
	rti


*  Output Compare Interrupt Handler

OC2Int
	ldd	HALF_PERIOD
	addd	toc2
	std	toc2
	ldx	#rbase
	bclr	$23,x $bf
	rti

*******************************************************************************
* Messages

M_LINE1		fcc	'A  => SHOW PORT A STATUS'
		fcb	$ff
M_LINE2		fcc	'B  => CLEAR PORT B OUTPUTS'
		fcb	$ff
M_LINE3		fcc	'C  => SHOW PORT C STATUS'
		fcb	$ff
M_LINE4		fcc	'D  => SHOW PORT D STATUS'
		fcb	$ff
M_LINE5		fcc	'R  => SHOW REAL-TIME ANALOG VALUES'
		fcb	$ff
M_LINE6		fcc	'S  => BEEP SPEAKER (CONNECT TO PA6)'
		fcb	$ff
M_LINE7		fcc	'0 TO 7 => TOGGLE THE SELECTED B PORT LINE'
		fcb	$ff
M_PROMPT	fcc	'?'
		fcb	$ff
M_HEADER1	FCC	'   ADAPT-11 DEMO PROGRAM COMMAND MENU'
		FCB	$FF
M_UNDLN		FCC	'_________________________________________'
		FCB	$FF
M_AD0		fcc	'AD0='
		fcb	$ff
M_AD1		fcc	'AD1='
		fcb	$ff
M_AD2		fcc	'AD2='
		fcb	$ff
M_AD3		fcc	'AD3='
		fcb	$ff
M_AD4		fcc	'AD4='
		fcb	$ff
M_AD5		fcc	'AD5='
		fcb	$ff
M_AD6		fcc	'AD6='
		fcb	$ff
M_AD7		fcc	'AD7='
		fcb	$ff
M_PORTA		fcc	'PORTA='
		fcb	$ff
M_PORTC		fcc	'PORTC='
		fcb	$ff
M_PORTD		fcc	'PORTD='
		fcb	$ff
M_BOFF		FCC	'PORT B CLEARED'
		FCB	$FF
M_BEEP		FCC	'>>> BEEP! <<<'
		FCB	$FF


*******************************************************************************

	org	$FFD6

*  Interrupt and reset vectors.

SCI_VECT	FDB	SerInputInt
SPI_VECT	FDB	start
PAI_VECT	FDB	start
PAO_VECT	FDB	start
TOF_VECT	FDB	start

TOC5_VECT	FDB	start
TOC4_VECT	FDB	start
TOC3_VECT	FDB	start
TOC2_VECT	FDB	OC2Int
TOC1_VECT	FDB	start
TIC3_VECT	FDB	start
TIC2_VECT	FDB	start
TIC1_VECT	FDB	start

RTI_VECT	FDB	RealTimeInt
IRQ_VECT	FDB	start
XIRQ_VECT	FDB	start
SWI_VECT	FDB	start
TRAP_VECT	FDB	start
COP_FAIL_VECT	FDB	start
COP_CMF_VECT	FDB	start

*location $fffe,$ffff	your program will not work without a reset vector

RESET_VECT	FDB	start	;this vector points to start of program