;Keybrd.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*February 4, 1999         V1.00
*Written by Exequiel Rarama for the ADAPT 812
********************************************************************************

LEFT    equ     1
RIGHT   equ     2
UP      equ     3
DOWN    equ     4

DEL     equ     7
_BS     equ     8
_CR      equ    $13
ESC     equ     $1b
ALT     equ     $11
CTRL    equ     $14
F1      equ     $05

ENTER   equ     _CR
EXIT    equ     ESC

;Keyboard variables are define in "MAIN.ASM"
;keybd_char      ds      1
;keybd_value     ds      6
;keybd_count     ds      1
;keybd_flag      ds      1
;keybd_timer     ds      1
;release_flag    ds      1
;keybd_state     ds      1
;key_char_flag   ds      1
;key_state       ds      2


; Keyboard Routines
; -----------------

keybd_init
        bset    PORTT,%0100             ;Port T bit 2 is Keyboard Reset
        bset    DDRT,%0100              ;                    

        bclr    TIOS,%10                ;Bit 1 of Port T use as Input capture
        bset    TMSK1,%10               ;Enable input capture 1
        bset    TFLG1,%10               ;Clear input capture 1 interrupt

        bset    TCTL4,%1000             ;Capture on Falling edge
        bclr    TCTL4,%0100             ;Capture on Falling edge

        movb    #11,keybd_count

        ldx     #0
        stx     keybd_value
        stx     keybd_timer

clear_key
        clr     keybd_flag
        clr     release_flag
        clr     keybd_state
        clr     key_char_flag

        ldx     #get_key
        stx     key_state
        rts

;-----------------------------------------------------------------------------
get_key
        ldaa    keybd_flag
        beq     gky50

        ldx     #keybd_value+2-1

        sei
        ldab    keybd_flag
        abx
        ldab    0,x
        dec     keybd_flag
        cli

        cmpb    #$e0                   ;skip if alternate? prefix
        beq     gky50

        cmpb    #$f0                   ;skip if release prefix
        bne     gky10

        inc     release_flag
        bra     gky50

gky10   ldaa    release_flag
        beq     gky20

        clr     release_flag
        cmpb    #ALT
        bne     gky15

        bclr    keybd_state,%10
        bra     gky50

gky15   cmpb    #CTRL
        bne     gky50
        bclr    keybd_state,%01
        bra     gky50

gky20   tstb
        bmi     gky50
 
gky30
        ldx     #key_table_at
        abx
        ldaa    0,x                     ;Reg A contain keyboard value

        staa    keybd_char
;       jsr     SB1
        movb    #1,key_char_flag

        bra     gkyex

gky50   clra
        staa    keybd_char

gkyex
        rts
;-----------------------------------------------------------------------------

;BS      equ     8
;CR      equ     13h
;ESC     equ     1bh
;ALT     equ     11h
;CTRL    equ     14h
;F1      equ     05h
 
key_table_at
        db      0,0,0,0,0,F1,0,0,0,0,0,0,0,0,0,0
;
        db      0,ALT,0,0,CTRL
        fcc     'Q1'
        db      0,0,0
        fcc     'ZSAW2'
        db      0
;
        db      0
        fcc     'CXDE43'
        db      0,0
        fcc     ' VFTR5'
        db      0
;
        db      0
        fcc     'NBHGY6'
        db      0,0,0
        fcc     'MJU78'
        db      0
;
        db      0
        fcc     ',KIO09'
        db      0,0
        fcc     './L;P-'
        db      0
;
        db      0,0,0,0
        fcc     '[='
        db      0,0,0,0,_CR
        fcc     ']'
        db      0,0,0,0
;
        db      0,0,0,0,0,0,_BS,0,0,0,0,0,0,0,0,0
        db      0,0,0,0,0,0,ESC,0,0,0,0,0,0,0,0,0

        fcc     'ABCDEFGHIJKLMNOPQRSTUVWXYZ'





;=============================================================================
