;812demo3.asm
;MC68HC812A4 MAIN ROUTINE
;REGS.INC CONTAINS ALL REGISTERS
;
;REGS.INC, AUDIO.ASM and RTC.ASM ARE EXTERNAL FILES
;
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*June 14, 1997          1.00            Initial Release
*
*Revised by Exequiel Rarama for the ADAPT 812
*Revised June 16, 1998 by Carl Barnes for ADAPT-812 MX1
*Revised July 10, 1998 by Exequiel Rarama for ADAPT-812 MX1 Real Time Clock
*Revised Jan  17, 1999 by Exequiel Rarama for ADAPT-812 MX1 & DX Real Time Clock
*******************************************************************************
;
; ---------------------------
; Demo - Main Routine
; ---------------------------

#include REGS.INC

*  Operational Parameters

_100MS          equ     25
_250MS          equ     61
_500MS          equ     125
_1SECOND        equ     250
_2SECONDS       equ     500
_3SECONDS       equ     750
_5SECONDS       equ     1250
_10SECONDS      equ     2500
_25SECONDS      equ     6250
_60SECONDS      equ     15000
_2MIN           equ     30000

;Audio Variables are define in "AUDIO.ASM" file
;TONE_2K         equ     500     ;frequencies in Hertz for tone generation
;TONE_1K         equ     1000
;TONE_440        equ     2272
;TONE_220        equ     4545
;TONE_180        equ     3000
;TONE_110        equ     9090
;TONE_60         equ     16666

RAM     equ     $0800           ;68HC812A4 internal RAM
STACK   equ     $0c00           ;Stack at top of internal ram
rbase   equ     $0000           ;68HC812A4 register block
FLASH	equ	$8000		;external Flash
EEPROM  equ     $f000           ;68HC812A4 internal EEPROM
SRAM	equ	$7000		;start of external SRAM, when enabled
DWIN	equ	$7000		;start of data window
ENDDWIN	equ	$7fff		;end of data window
PWIN	equ	$8000		;start of program window
ENDPWIN	equ	$bfff		;end of program window
LDP128	equ	$1f		;last 4K page of 128K data space
LDP512	equ	$7f		;last 4K page of 512K data space
LPP128	equ	$07		;last 16K page of 128K program space
LPP512	equ	$1f		;last 16K page of 512K program space

PAGE0   equ     0
PAGE1   equ     1
PAGE2   equ     2
PAGE3   equ     3
PAGE4   equ     4
PAGE5   equ     5
PAGE6   equ     6
PAGE7   equ     7

* Operational Constants

TRUE            equ     $FF
FALSE           equ     $00
CR              equ     $D
LF              equ     $A
BS              equ     $F
SPACE           equ     $20

**********************************************************************
*       PORT ASSIGNMENTS for this program

;PORTT is initialize in REGS.INC
_PORTT  equ     PORTT           ;input capture/output compare port of 68HC812A4

*       PT0     spare           ;I/O
*       PT1     spare           ;I/O
*       PT2     spare           ;I/O
*       PT3     spare           ;I/O
*       PT4     spare           ;I/O
*       PT5     spare           ;I/O
*       PT6     SPEAKER         ;I/O
*       PT7     spare           ;I/O
**********************************************************************

* Masks
;OC Variables are define in "AUDIO.ASM" file
;OC6mask1        equ     %01000000       ;IOS6 = 1, Bit 6 as output compare
;OC6mask2        equ     %01000000       ;C6I = 1, Enable Interrupt
;OC6mask3        equ     %00010000       ;OM6 = 0, OL6 = 1, toggel OC output line
;OC6flag         equ     %01000000       ;C6F = 1 to clear Interrupt flag

;ATD Variables
admask2         equ     %11000000       ;AFFC,ADPU=1 - Enable Analog to Digital
admask3         equ     %00000000       ;FRZ1,FRZ0=0
admask4         equ     %00000001       ;SMP1,SMP0 = 0, PRS0=1 - Select Sample time
admask5         equ     %01110000       ;S8CM = 1, SCAN = 1, MULT = 1
SCFflag         equ     %10000000       ;SCF - Sequence Complete flag

;RTI Variables
clrmask         equ     %11000000       ;mask for clearing timer flags
rtimask1        equ     %10000001       ;M=8Mhz, 1.024 msec interrupt with 16 MHz xtal
rtimask2        equ     %10000010       ;M=8Mhz, 2.048 msec interrupt with 16 MHz xtal
rtimask3        equ     %10000011       ;M=8Mhz, 4.096 msec interrupt with 16 MHz xtal
rtimask4        equ     %10000100       ;M=8Mhz, 8.196 msec interrupt with 16 MHz xtal
rtimask5        equ     %10000101       ;M=8Mhz, 16.384 msec interrupt with 16 MHz xtal
rtimask6        equ     %10000110       ;M=8Mhz, 32.768 msec interrupt with 16 MHz xtal
rtimask7        equ     %10000111       ;M=8Mhz, 65.536 msec interrupt with 16 MHz xtal
rtiflag         equ     %10000000

;SCI Variables
scimask         equ     %00101100       ;RIE - SCI Interrupt enable
                                        ;RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
;MCLK=8Mzh
BAUD110         equ     4545    ;(baud) 110 baud with 16 Mhz crystal
BAUD300         equ     1667    ;(baud) 300 baud with 16 Mhz crystal
BAUD600         equ     833     ;(baud) 600 baud with 16 Mhz crystal
BAUD1200        equ     417     ;(baud) 1200 baud with 16 Mhz crystal
BAUD2400        equ     208     ;(baud) 2400 baud with 16 Mhz crystal
BAUD4800        equ     104     ;(baud) 4800 baud with 16 Mhz crystal
BAUD9600        equ     52      ;(baud) 9600 baud with 16 Mhz crystal
BAUD14400       equ     35      ;(baud) 14400 baud with 16 Mhz crystal
BAUD19200       equ     26      ;(baud) 19200 baud with 16 Mhz crystal
BAUD38400       equ     13      ;(baud) 19200 baud with 16 Mhz crystal

        org     RAM

* System Variables
CURPAGE		rmb	1	;current page counter
MEM_SIZE	rmb	2	;memory size (128 or 512)
LAST_PPAGE	rmb	1	;last page of Flash
LAST_DPAGE	rmb	1	;last page of RAM

COMMAND         rmb     1       ;used by ProcessCommand

H               rmb     1       ;used in binary to decimal conversion
TO              rmb     1

DURATION        rmb     2       ;used for tone generation
HALF_PERIOD     rmb     2

TIMER           rmb     2       ;software timers using RTI
TIMER1          rmb     2
COUNTER         rmb     1
dummy           rmb     1

;ATD ram variables
atd_var
ad0             rmb     1
ad1             rmb     1
ad2             rmb     1
ad3             rmb     1
ad4             rmb     1
ad5             rmb     1
ad6             rmb     1
ad7             rmb     1

;-------------------
* Boolean Variables

COMMAND_PENDING rmb     1       ;used by ProcessCommand
CONTINUOUS      rmb     1       ;flag for real-time a/d screen update

;
;-------------
;RTC Variables
;-------------
TEMP1                   ds      1
TEMP2                   ds      1

spi_read                ds      1
spi_write               ds      1

rtc_reg_address         ds      1
read_write_flag         ds      1               ;if bit 0 is 0 then write else read
ack_flag                ds      1               ;acknowledged flag

;time variables

time_flag               ds      1
date_flag               ds      1

time_temp
time_seconds_hundred    ds      1
time_seconds            ds      1
time_minutes            ds      1
time_hours              ds      1
time_days               ds      1
time_months             ds      1
leap_var                ds      1
rtc_buf                 ds      1
sci_rtc_buf_flag        ds      1
time_state              ds      2
DBUFR                   ds      5

result                  ds      4
operand                 ds      2

; Memory Allocation for LC Display routine
disp_buffer     ds      32              ;display buffer (2 lines of 16 chars)
disp_ptr        ds      2               ;pointer to display buffer
disp_flag       ds      1               ;1 = update; 0 = home; -1 = done
drow_var        ds      1
temp            ds      1
lcd_state       ds      2
lcd_timer       ds      2
spi_int_flag    ds      1
u_delay_var     ds      2
dig_lenght      ds      1
dcol_var        ds      1

;Keyboard variables
keybd_char      ds      1
keybd_value     ds      6
keybd_count     ds      1
keybd_flag      ds      1
keybd_timer     ds      1
release_flag    ds      1
keybd_state     ds      1
key_state       ds      2
key_char_flag   ds      1

        org     $7000

time_years              ds      2       ;this variable is save in external ram
leap_year               ds      1


***************************** Program *******************************

        org     $c000

RESET1                          ;This is where the RESET vector points to

;Set up external memory control registers
;       movb    #$04,PEAR       ;enable read/write signal
;       movb    #$b0,MODE       ;normal exp. narrow
;       movb    #$c0,WINDEF     ;enable data & program windows
;       movb    #$07,MXAR       ;enable A16, A17, A18
;       movb    #$30,CSCTL0     ;enable CSD & CSP0
;       movb    #$10,CSCTL1     ;CSD covers lower half of memory map

;Initialize Stack
        lds     #STACK          ;initialize stack pointer
        clr     PPAGE
        jmp     _init

;Interrupt test traps
RESET
        sei
        movb    #$55,COPRST
        movb    #$AA,COPRST

;Bit 5 of PORTT is toggled
        jsr     delay
        jsr     delay
        bclr    PORTT,%00100000
        jsr     delay
        jsr     delay
        bset    PORTT,%00100000

        bra     RESET

;------------------------
;Start of Initialization
;------------------------
first_org       equ     *
;
;
;       org     PPAGE
;       fcb     $0
;       org     $8000

_init

;Initialize Real Time Interrupt
        movb    #rtimask3,RTICTL        ;Enable RTI and initialize RTI rate 
        movb    #rtiflag,RTIFLG    

;Initialize COP
        movb    #%10000111,COPCTL       ;COP is enabled and is armed to
                                        ; reset in 1 second.

;Initialize Analog To Digital
        movb    #admask2,ATDCTL2        ;enable ATD
        movb    #admask4,ATDCTL4        ;Select Sample rate
        movb    #admask5,ATDCTL5        ;Select 8 channel mode, Continuous scan
                                        ;and Multichannel

;Initialize Serial Communication Interface
        movb    #scimask,SC0CR2         ;enable SCI 0 rcvr. & xmtr. & rx int
        movb    #0,SC0CR1    
        movb    #BAUD9600,SC0BDL        ;Set baud rate to 9600    
        ldaa    SC0SR1                  ;read register to clear flag RDRF
        ldaa    SC0DRL                  ;dummy read to flush receive buffer

;Initialize PORTT
        movb    #%01100000,DDRT         ;Bit 6,5 of PORTT are Output
        bclr    PORTT,%01100000

        jsr     audio_init      ;Initialize bit 6 of PORTT as OC for audio o/p
        jsr     RTC_INIT        ;Initialize Clock
        jsr     keybd_init      ;Initialize keyboard

        clr     COMMAND_PENDING
        clr     CONTINUOUS

        cli                     ;unmask interrupts

;do 4 BEEPS
        ldx     #TONE_440       ;generate two 100 millisecond beeps @ 440 Hz
        ldab    #$4             ; (connect speaker to PA6)
        ldy     #_100MS
        jsr     PulseXToneB     ;power tones

        jsr     disp_init       ;Initialize Lcd

;-----------------------------------------------------------------------------
;Main loops
;
Main
        movb    #$55,COPRST     ;Reset COP
        movb    #$AA,COPRST

        jsr     ProcessCommand  ;From SCI command
        ldaa    CONTINUOUS
        beq     Main10
        jsr     ShowAnalog

Main10
        jsr     Kb_Command      ;From Keyboard command
        ldaa    CONTINUOUS
        beq     Main20
        jsr     ShowAnalog
Main20

;This is where time command are process in the Main loop
        ldx     time_state
        jsr     0,x

;This is where LCD command are process in the Main loop
        ldx     lcd_state
        jsr     0,x

        jsr     disp_update

;This is where keyboard command are process in the Main loop
        ldx     key_state
        jsr     0,x

;       jsr     get_key

;        movb    #$30,PORTJ
;        jsr     toggle_lcd_data

        bra     Main

;-----------------------------------------------------------------------------
delay
        pshy
        ldy     #0
        bra     dly

small_delay
        pshy
        ldy     #10    

dly
        dbne    y,dly
        puly
        rts

***********************************************************************
*Procedure Definitions:
***********************************************************************

WaitX
        stx     TIMER1          ;delays a length of time defined by x
W1      ldx     TIMER1          ; (note that whenever TIMER1 is non-zero,
        bne     W1              ; it is decremented in the RTI interrupt
        rts                     ; service routine)

;-----------------------------
;Choose which one to process
Kb_Command
        ldaa    key_char_flag
        bne     Kb_process
        jmp     PCX

Kb_process
        clr     key_char_flag
        clr     CONTINUOUS
        jsr     PutNewLine
        ldaa    keybd_char
        bra     kb_p

ProcessCommand:
        ldaa    COMMAND_PENDING         ;commands received via SCI interrupt
        cmpa    #TRUE
        beq     Process
        jmp     PCX
Process
        clr     COMMAND_PENDING
        clr     CONTINUOUS
        jsr     PutNewLine
        ldaa    COMMAND
kb_p
        cmpa    #'A'
        lbeq    PCA
        cmpa    #'a'
        lbeq    PCA

        cmpa    #'B'
        lbeq    PCB
        cmpa    #'b'
        lbeq    PCB

        cmpa    #'C'
        lbeq    PCC
        cmpa    #'c'
        lbeq    PCC

        cmpa    #'D'
        lbeq    PCD
        cmpa    #'d'
        lbeq    PCD

        cmpa    #'E'
        lbeq    PCE
        cmpa    #'e'
        lbeq    PCE

        cmpa    #'F'
        lbeq    PCF
        cmpa    #'f'
        lbeq    PCF

        cmpa    #'G'
        lbeq    PCG
        cmpa    #'g'
        lbeq    PCG

        cmpa    #'H'
        lbeq    PCH
        cmpa    #'h'
        lbeq    PCH

        cmpa    #'I'    ;Display Time
        lbeq    PCI
        cmpa    #'i'
        lbeq    PCI

        cmpa    #'J'
        lbeq    PCJ
        cmpa    #'j'
        lbeq    PCJ

        cmpa    #'K'    ;Display Date
        lbeq    PCK
        cmpa    #'k'
        lbeq    PCK

        cmpa    #'R'
        lbeq    PCR
        cmpa    #'r'
        lbeq    PCR

        cmpa    #'S'
        lbeq    PCS
        cmpa    #'s'
        lbeq    PCS

        cmpa    #'T'
        lbeq    PCT
        cmpa    #'t'
        lbeq    PCT

        cmpa    #'Y'
        lbeq    PCY
        cmpa    #'y'
        lbeq    PCY

        cmpa    #'L'
        lbeq    PCL
        cmpa    #'l'
        lbeq    PCL

        cmpa    #'0'
        lblo    PCM
        cmpa    #'7'
        lbhi    PCM

        jsr     ToggleJLine
        lbra    PCXX

;----------------------------
;X register points to routine
;----------------------------

PCA
        ldx     #PPCA
        jsr     0,x             ;go execute routine
        bra     PCX
PCB
        ldx     #PPCB
        jsr     0,x             ;go execute routine
        bra     PCX
PCC
        ldx     #PPCC
        jsr     0,x             ;go execute routine
        bra     PCX
PCD
        ldx     #PPCD
        jsr     0,x             ;go execute routine
        bra     PCX
PCE
        ldx     #PPCE
        jsr     0,x             ;go execute routine
        bra     PCX
PCF
        ldx     #PPCF
        jsr     0,x             ;go execute routine
        bra     PCX
PCG
        ldx     #PPCG
        jsr     0,x             ;go execute routine
        bra     PCX
PCH
        ldx     #PPCH
        jsr     0,x             ;go execute routine
        bra     PCX
PCI                             ;Display Time
        ldx     #PPCI
        jsr     0,x             ;go execute routine
        bra     PCX
PCJ
        ldx     #PPCJ
        jsr     0,x             ;go execute routine
        bra     PCX
PCK                             ;Display Date
        ldx     #PPCK
        jsr     0,x             ;go execute routine
        bra     PCX
PCL
        ldx     #PPCL
        jsr     0,x             ;go execute routine
        bra     PCX
PCM
        ldx     #PPCM
        jsr     0,x             ;go execute routine
        bra     PCX
PCR
        ldx     #PPCR
        jsr     0,x             ;go execute routine
        bra     PCX
PCS
        ldx     #PPCS
        jsr     0,x             ;go execute routine
        bra     PCX
PCT
        ldx     #PPCT
        jsr     0,x             ;go execute routine
        bra     PCX
PCY
        ldx     #PPCY
        jsr     0,x             ;go execute routine
        bra     PCX

PCX
PCXX
        RTS
;----------------------------------------------

PPCA
        ldx     #M_PORTA
        jsr     SendString
        ldab    PORTA
        clra
        jsr     SendDecByte
        jsr     PutNewLine

        ldx     #disp_menu0
        stx     lcd_state

        movb    #0,drow_var
        jsr     drow
        ldx     #L_PORTA
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_PROMPT
        jsr     dstr

        lbra    PCXX
PPCB
        ldx     #M_PORTB
        jsr     SendString
        ldab    PORTB
        clra
        jsr     SendDecByte
        jsr     PutNewLine

        ldx     #disp_menu0
        stx     lcd_state

        movb    #0,drow_var
        jsr     drow
        ldx     #L_PORTB
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_PROMPT
        jsr     dstr

        lbra    PCXX
PPCC
        ldx     #M_PORTC
        jsr     SendString
        ldab    PORTC
        clra
        jsr     SendDecByte
        jsr     PutNewLine

        ldx     #disp_menu0
        stx     lcd_state

        movb    #0,drow_var
        jsr     drow
        ldx     #L_PORTC
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_PROMPT
        jsr     dstr

        lbra    PCXX
PPCD
        ldx     #M_PORTD
        jsr     SendString
        ldab    PORTD
        clra
        jsr     SendDecByte
        jsr     PutNewLine

        ldx     #disp_menu0
        stx     lcd_state

        movb    #0,drow_var
        jsr     drow
        ldx     #L_PORTD
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_PROMPT
        jsr     dstr

        lbra    PCXX
PPCE
        ldx     #M_PORTE
        jsr     SendString
        ldab    PORTE
        clra
        jsr     SendDecByte
        jsr     PutNewLine

        ldx     #disp_menu0
        stx     lcd_state

        movb    #0,drow_var
        jsr     drow
        ldx     #L_PORTE
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_PROMPT
        jsr     dstr

        lbra    PCXX
PPCF
        ldx     #M_PORTF
        jsr     SendString
        ldab    PORTF
        clra
        jsr     SendDecByte
        jsr     PutNewLine

        ldx     #disp_menu0
        stx     lcd_state

        movb    #0,drow_var
        jsr     drow
        ldx     #L_PORTF
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_PROMPT
        jsr     dstr

        lbra    PCXX
PPCG
        ldx     #M_PORTG
        jsr     SendString
        ldab    PORTG
        clra
        jsr     SendDecByte
        jsr     PutNewLine

        ldx     #disp_menu0
        stx     lcd_state

        movb    #0,drow_var
        jsr     drow
        ldx     #L_PORTG
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_PROMPT
        jsr     dstr

        lbra    PCXX
PPCH
        ldx     #M_PORTH
        jsr     SendString
        ldab    PORTH
        clra
        jsr     SendDecByte
        jsr     PutNewLine

        ldx     #disp_menu0
        stx     lcd_state

        movb    #0,drow_var
        jsr     drow
        ldx     #L_PORTH
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_PROMPT
        jsr     dstr

        lbra    PPCX

PPCI                            ;Display Time
        inc     time_flag
        lbra    PPCX

PPCJ
        clr     PORTJ
        ldx     #M_JOFF
        jsr     SendString
        jsr     PutNewLine

        ldx     #disp_menu0
        stx     lcd_state

        movb    #0,drow_var
        jsr     drow
        ldx     #L_JOFF 
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_PROMPT
        jsr     dstr

        lbra    PPCX

PPCK                            ;Display Date
        inc     date_flag
        lbra    PPCX

PPCM
        jsr     ShowMenu

        ldx     #disp_menu1
        stx     lcd_state

        lbra    PPCX
PPCR
        staa    CONTINUOUS      ;set continuous a/d display flag
        lbra    PPCX
PPCS
        ldx     #M_PORTS
        jsr     SendString
        ldab    PORTS
        clra
        jsr     SendDecByte
        jsr     PutNewLine

        ldx     #disp_menu0
        stx     lcd_state

        movb    #0,drow_var
        jsr     drow
        ldx     #L_PORTS
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_PROMPT
        jsr     dstr

        lbra    PPCX
PPCT
        ldx     #M_PORTT
        jsr     SendString
        ldab    PORTT
        clra
        jsr     SendDecByte
        jsr     PutNewLine

        ldx     #disp_menu0
        stx     lcd_state

        movb    #0,drow_var
        jsr     drow
        ldx     #L_PORTT
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_PROMPT
        jsr     dstr

        bra     PPCX
PPCX
        rts

PPCY
;make all ports output
        ldaa    #%11111111
        staa    DDRA
        staa    DDRB
        staa    DDRC
        staa    DDRD
        staa    DDRE
        staa    DDRF
        staa    DDRG
        staa    DDRH
        staa    DDRJ
        staa    DDRS
        staa    DDRT

        ldx     #M_TOGGLE1
        jsr     SendString
        ldy     #PORTA
        ldx     #PORTB
        jsr     toggle_port
        ldx     #M_TOGGLE7
        jsr     SendString

        jsr     PutNewLine
        ldx     #M_TOGGLE2
        jsr     SendString
        ldy     #PORTC
        ldx     #PORTD
        jsr     toggle_port
        ldx     #M_TOGGLE7
        jsr     SendString

        jsr     PutNewLine
        ldx     #M_TOGGLE3
        jsr     SendString
        ldy     #PORTE
        ldx     #PORTF
        jsr     toggle_port
        ldx     #M_TOGGLE7
        jsr     SendString

        jsr     PutNewLine
        ldx     #M_TOGGLE4
        jsr     SendString
        ldy     #PORTG
        ldx     #PORTH
        jsr     toggle_port
        ldx     #M_TOGGLE7
        jsr     SendString

        jsr     PutNewLine
        ldx     #M_TOGGLE5
        jsr     SendString
        ldy     #PORTJ
        ldx     #PORTS
        jsr     toggle_port
        ldx     #M_TOGGLE7
        jsr     SendString

        jsr     PutNewLine
        ldx     #M_TOGGLE6
        jsr     SendString
        ldy     #PORTT
        ldx     #dummy
        jsr     toggle_port
        ldx     #M_TOGGLE7
        jsr     SendString

        jsr     PutNewLine
        ldx     #M_TOGGLE8
        jsr     SendString

;make all ports input

        ldaa    #0

        staa    DDRA
        staa    DDRB
        staa    DDRC
        staa    DDRD
        staa    DDRE
        staa    DDRF
        staa    DDRG
        staa    DDRH
        staa    DDRJ
        staa    DDRS

        ldaa    #%01100000      ;Bit 6,5 of PORTT are Output
        staa    DDRT            ;
PX
        rts

PPCL
        ldx     #M_BEEP         ;flash LED D1 (or beep speaker, if connected)
        jsr     SendString
        jsr     PutNewLine

        ldx     #TONE_440       ;generate two 100 millisecond beeps @ 440 Hz
        ldab    #2
        ldy     #_100MS
        jsr     PulseXToneB
        bra     PX

ToggleJLine:
        ldab    #1              ;number is between 0 and 7
        suba    #'0'            ;convert ASCII digit to binary number
        beq     TBL1
TBL0
        aslb                    ;set the appropriate mask bit
        dbne    a,TBL0
TBL1
        bitb    PORTJ           ;if designated port bit is 1
        beq     TBM1            ;  then make it 0
        comb
        bra     TBM0
TBM1
        orab    PORTJ
        stab    PORTJ
        rts
TBM0
        andb    PORTJ
        stab    PORTJ
        rts

;Reg y contain the port address to toggle
;Reg b contain the toggle bit

toggle_port
        movb    #8,COUNTER
        ldab    #%01

toggle
        stab    0,y
        stab    0,x

        movw    #120,TIMER
        jsr     wait

        lslb
        dec     COUNTER
        bne     toggle
        rts

wait
        pshx
        pshy
wt
        movb    #$55,COPRST
        movb    #$AA,COPRST

        ldx     TIMER
        bne     wt
        puly
        pulx
        rts

;-----------------------------------------------------------------------------
ShowMenu
        jsr     PutDblLine

        ldx     #M_UNDLN
        jsr     SendString
        jsr     PutNewLine
        jsr     PutNewLine
        ldx     #M_HEADER1
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_UNDLN
        jsr     SendString
        jsr     PutNewLine
        jsr     PutNewLine

        ldx     #M_LINE1
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE2
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE3
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE4
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE5
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE6
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE7
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE8
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE9
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE10
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE11
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE12
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE13
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE14
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE15
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE16
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_LINE17
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_PROMPT
        jsr     SendString
        rts

ShowAnalog
        ldx     #M_AD0
        jsr     SendString
        ldab    ad0
        clra
        jsr     SendDecByte
        ldaa    #SPACE
        jsr     SendByte

        ldx     #M_AD1
        jsr     SendString
        ldab    ad1
        clra
        jsr     SendDecByte
        ldaa    #SPACE
        jsr     SendByte

        ldx     #M_AD2
        jsr     SendString
        ldab    ad2
        clra
        jsr     SendDecByte
        ldaa    #SPACE
        jsr     SendByte

        ldx     #M_AD3
        jsr     SendString
        ldab    ad3
        clra
        jsr     SendDecByte
        ldaa    #SPACE
        jsr     SendByte

        ldx     #M_AD4
        jsr     SendString
        ldab    ad4
        clra
        jsr     SendDecByte
        ldaa    #SPACE
        jsr     SendByte

        ldx     #M_AD5
        jsr     SendString
        ldab    ad5
        clra
        jsr     SendDecByte
        ldaa    #SPACE
        jsr     SendByte

        ldx     #M_AD6
        jsr     SendString
        ldab    ad6
        clra
        jsr     SendDecByte
        ldaa    #SPACE
        jsr     SendByte

        ldx     #M_AD7
        jsr     SendString
        ldab    ad7
        clra
        jsr     SendDecByte

        ldaa    #CR
        jsr     SendByte
        rts


HexByte2Dec

*               Supply hex value to be converted in B register
        clra
        ldx     #100    ;numerator in D, denominator in X
        idiv
*               remainder in D, quotient in X
*               B is lo-order byte
        xgdx
        stab    H       ;8 bit quotient in B
        xgdx
        ldx     #10     ;H=0X  TO=packed BCD
        idiv
        stab    TO
        xgdx
        aslb
        aslb
        aslb
        aslb
        orab    TO
        stab    TO
        rts

SendDecByte

* value is in B

        clra
        jsr     HexByte2Dec
        ldaa    H
        adda    #'0'
        jsr     SendByte
        ldaa    TO
        jsr     SendASCIIHex
        rts

SendASCIIHex
*       value in A

        psha
        anda    #$F0
        lsra
        lsra
        lsra
        lsra
        cmpa    #$A
        blt     SAH1
        suba    #$A
        adda    #'A'
        bra     SAH2
SAH1
        adda    #'0'
SAH2
        jsr     SendByte
        pula
        psha
        anda    #$0F
        cmpa    #$A
        blt     SAH3
        suba    #$A
        adda    #'A'
        bra     SAH4
SAH3
        adda    #'0'
SAH4
        jsr     SendByte
        pula
        rts


SendByte:

*  Transmits a byte, contained in register A, to the serial device via the SCI.

SB1
        ldab    SC0SR1  ;wait for transmit data register empty (TDRE)
        bpl     SB1
        staa    SC0DRL  ;send byte
        rts

PutNewLine
        ldaa    #CR
        jsr     SendByte
        ldaa    #LF
        jsr     SendByte
        rts

PutDblLine
        ldaa    #CR
        jsr     SendByte
        ldaa    #LF
        jsr     SendByte
        ldaa    #LF
        jsr     SendByte
        rts

SendString

*       x contains starting address of string
RV1
        ldaa    0,X             ;$FF denotes end of string
        cmpa    #$FF
        beq     RVX
        jsr     SendByte
        inx
        bra     RV1
RVX
        rts

GetChar:

*  Fetches one character from SCI0, 
*  and returns it in register A.  

GC1:
	ldaa	SC0SR1		;get sci flags
	anda	#RDRFflag	;mask off irrelevant bits
	beq	GC1		;loop until character found
	ldaa	SC0DRL		;get character
	rts


*******************************************************************************
* Messages

*******************************************************************************
* Messages
M_LINE1         fcc     'A => SHOW PORT A STATUS'
                fcb     $ff
M_LINE2         fcc     'B => SHOW PORT B STATUS'
                fcb     $ff
M_LINE3         fcc     'C => SHOW PORT C STATUS'
                fcb     $ff
M_LINE4         fcc     'D => SHOW PORT D STATUS'
                fcb     $ff
M_LINE5         fcc     'E => SHOW PORT E STATUS'
                fcb     $ff
M_LINE6         fcc     'F => SHOW PORT F STATUS'
                fcb     $ff
M_LINE7         fcc     'G => SHOW PORT G STATUS'
                fcb     $ff
M_LINE8         fcc     'H => SHOW PORT H STATUS'
                fcb     $ff
M_LINE9         fcc     'J => CLEAR PORT J OUTPUTS'
                fcb     $ff
M_LINE10        fcc     'S => SHOW PORT S STATUS'
                fcb     $ff
M_LINE11        fcc     'R => SHOW REAL-TIME ANALOG VALUES'
                fcb     $ff
M_LINE12        fcc     'T => SHOW PORT T STATUS'
                fcb     $ff
M_LINE13        fcc     'L => FLASH LED (CONNECT TO PT6)'
                fcb     $ff
M_LINE14        fcc     '0 TO 7 => TOGGLE THE SELECTED PORT J LINE'
                fcb     $ff
M_LINE15        fcc     'Y => TOGGLE ALL PORT LINES IN SEQUENCE'
                fcb     $ff
M_LINE16
M_TIME          fcc     'I => Set Time (hh:mm:ss) [24-hour format]'
                fcb     $ff
M_LINE17
M_DATE          fcc     'K => Set Date (yyyy/mm/dd)'
                fcb     $ff
M_CURRENT_TIME  fcc     'Current Time: '
		fcb	$ff
M_NEW_TIME      fcc     'New Time: '
		fcb	$ff
M_CURRENT_DATE  fcc     'Current Date: '
		fcb	$ff
M_NEW_DATE      fcc     'New Date: '
		fcb	$ff
M_PROMPT        fcc     '?'
                fcb     $ff
M_HEADER1       fcc     '   ADAPT-812 DEMO PROGRAM COMMAND MENU V1.01'
                FCB     $FF
M_UNDLN         fcc     '_______________________________________________'
                FCB     $FF
M_AD0           fcc     'AN0='
                fcb     $ff
M_AD1           fcc     'AN1='
                fcb     $ff
M_AD2           fcc     'AN2='
                fcb     $ff
M_AD3           fcc     'AN3='
                fcb     $ff
M_AD4           fcc     'AN4='
                fcb     $ff
M_AD5           fcc     'AN5='
                fcb     $ff
M_AD6           fcc     'AN6='
                fcb     $ff
M_AD7           fcc     'AN7='
                fcb     $ff
M_PORTA         fcc     'PORTA='
                fcb     $ff
M_PORTB         fcc     'PORTB='
                fcb     $ff
M_PORTC         fcc     'PORTC='
                fcb     $ff
M_PORTD         fcc     'PORTD='
                fcb     $ff
M_PORTE         fcc     'PORTE='
                fcb     $ff
M_PORTF         fcc     'PORTF='
                fcb     $ff
M_PORTG         fcc     'PORTG='
                fcb     $ff
M_PORTH         fcc     'PORTH='
                fcb     $ff
M_JOFF          fcc     'PORT J CLEARED'
                FCB     $FF
M_PORTS         fcc     'PORTS='
                fcb     $ff
M_PORTT         fcc     'PORTT='
                fcb     $ff
M_BEEP          fcc     '>>> BEEP! <<<'
                FCB     $FF
M_TOGGLE1       fcc     'TOGGLING PORTS A AND B'
                FCB     $FF
M_TOGGLE2       fcc     'TOGGLING PORTS C AND D'
                FCB     $FF
M_TOGGLE3       fcc     'TOGGLING PORTS E AND F'
                FCB     $FF
M_TOGGLE4       fcc     'TOGGLING PORTS G AND H'
                FCB     $FF
M_TOGGLE5       fcc     'TOGGLING PORTS J AND S'
                FCB     $FF
M_TOGGLE6       fcc     'TOGGLING PORT T'
                FCB     $FF
M_TOGGLE7       fcc     ' <-DONE'
                FCB     $FF
M_TOGGLE8       fcc     'PRESS ANY KEY'
                FCB     $FF

;
;-----------------------------------------------------------------------------
;These sub-routines are external to this main routine and are link during the
; assembling stage.

#include AUDIO.ASM      ;Audio or Beeper routine
#include RTC.ASM        ;Pcf8593 Real time clock routine
#include LCD.ASM        ;Liquid Crystal Display routine
#include KEYBRD.ASM     ;Keyboard routine                 
#include INT.ASM        ;Interrupts routine


;MC68HC812A4 VECTOR INTERRUPTS

;       org     PPAGE
;       fcb     $7

        org     $FFCE

        FDB     RESET           ;KEY WAKEUP H
        FDB     RESET           ;KEY WAKEUP J
        FDB     RESET           ;ANALOG TO DIGITAL
        FDB     RESET           ;SERIAL COMMUNICATION 1
        FDB     SerInputInt     ;SERIAL COMMUNICATION 0
        FDB     spi_int         ;SPI SERIAL TRANSFER COMPLETE
        FDB     RESET           ;PULSE ACCUMULATOR INPUT EDGE
        FDB     RESET           ;PULSE ACCUMULATOR OVERFLOW
        FDB     RESET           ;TIMER OVERFLOW
        FDB     RESET           ;TIMER CHANNEL 7
        FDB     OC6Int          ;TIMER CHANNEL 6
        FDB     RESET           ;TIMER CHANNEL 5
        FDB     RESET           ;TIMER CHANNEL 4
        FDB     RESET           ;TIMER CHANNEL 3
        FDB     RESET           ;TIMER CHANNEL 2
        FDB     keybrd_int      ;TIMER CHANNEL 1
        FDB     RESET           ;TIMER CHANNEL 0
        FDB     RealTimeInt     ;REAL TIME INTERRUPT
        FDB     RESET           ;IRQ OR KEY WAKE UP D
        FDB     RESET           ;XIRQ
        FDB     dummy_int       ;SWI
        FDB     RESET           ;RESERVED
        FDB     RESET           ;COP FAILURE RESET
        FDB     RESET           ;COP CLOCK MONITOR FAIL RESET
        FDB     RESET1          ;RESET
