;MC68HC812A4 REGISTER MAP
;MEMORY BLOCK BEGINS AT 0000H AND ENDS AT  00F3H

REG     EQU     $0000

PORTA   EQU     $0000	;PORTA
PORTB   EQU     $0001	;PORTB
DDRA    EQU     $0002	;PORTA - DATA DIRECTION REG.
DDRB    EQU     $0003	;PORTB - DATA DIRECTION REG.
PORTC   EQU     $0004	;PORTC
PORTD   EQU     $0005	;PORTD
DDRC    EQU     $0006	;PORTC - DATA DIRECTION REG.
DDRD    EQU     $0007	;PORTD - DATA DIRECTION REG.
PORTE   EQU     $0008	;PORTE
DDRE    EQU     $0009	;PORTE - DATA DIRECTION REG.
PEAR    EQU     $000A	;PEAR - PORTE ASSIGNMENT REG.
MODE    EQU     $000B	;MODE - MODE REG.
PUCR    EQU     $000C	;PUCR - PULL UP CONTROL REG.
RDRIV   EQU     $000D	;RDRIV - REDUCED DRIVE OF I/O LINES


INITRM  EQU     $0010	;INITRM - INIT. OF INTERNAL RAM POSITION REG.
INITRG  EQU     $0011	;INITRG - INIT. OF INTERNAL REG. POSITION REG.
INITEE  EQU     $0012	;INITEE - INIT. OF INTERNAL EEPROM POSITION REG.
MISC    EQU     $0013	;MISC - MISCELLANEOUS MAPPING CONTROL REG.
RTICTL  EQU     $0014	;RTICTL - REAL TIME INTERRUPT CONTROL REG.
RTIFLG  EQU     $0015	;RTIFLG - REAL TIME INTERRUPT FLAG REG.
COPCTL  EQU     $0016	;COPCTL - COP CONTROL REG.
COPRST  EQU     $0017	;COPRST - ARM/RESET COP TIMER REG.
ITST0   EQU     $0018	;ITST0
ITST1   EQU     $0019	;ITST1
ITST2   EQU     $001A	;ITST2
ITST3   EQU     $001B	;ITST3

INTCR   EQU     $001E	;INTCR - INTERRUPT CONTROL REG.
HPRIO   EQU     $001F	;HPRIO - HIGHEST PRIORITY I INTERRRUPT
KWIED   EQU     $0020	;KWIED - KEY WAKEUP PORTD INTERRUPT ENABLE REG.
KWIFD   EQU     $0021	;KWIFD - KEY WAKEUP PORTD FLAG REG.

PORTH   EQU     $0024	;PORTH
DDRH    EQU     $0025	;DDRH - DATA DIRECTION REG.
KWIEH   EQU     $0026	;KWIEH - KEY WAKEUP PORTH INTERRUPT ENABLE REG.
KWIFH   EQU     $0027	;KWIFH - KEY WAKEUP PORTH FLAG REG.
PORTJ   EQU     $0028	;PORTJ
DDRJ    EQU     $0029	;DDRJ DATA DIRECTION REG.
KWIEJ   EQU     $002A	;KWIEJ - KEY WAKEUP PORTJ INTERRUPT ENABLE REG.
KWIFJ   EQU     $002B	;KWIFJ - KEY WAKEUP PORTJ FLAG REG.
KPOLJ   EQU     $002C	;KPOLJ - KEY WAKEUP PORTJ POLARITY REG.
PUPSJ   EQU     $002D	;PUPSJ - KEY WAKEUP PORTJ PULL-UP/PULLDOWN SELECT REG.
PULEJ   EQU     $002E	;PULEJ - KEY WAKEUP PORTJ PULL-UP/PULLDOWN ENABLE REG.

PORTF   EQU     $0030	;PORTF
PORTG   EQU     $0031	;PORTG
DDRF    EQU     $0032	;DDRF - DATA DIRECTION REG.
DDRG    EQU     $0033	;DDRG - DATA DIRECTION REG.
DPAGE   EQU     $0034	;DPAGE - DATA PAGE REG.
PPAGE   EQU     $0035	;PPAGE - PROGRAM PAGE REG.
EPAGE   EQU     $0036	;EPAGE - EXTRA PAGE REG.
WINDEF  EQU     $0037	;WINDEF - WINDOW DEFINATION REG.
MXAR    EQU     $0038	;MXAR - MEMORY EXPANSION ASSGNMENT REG.

CSCTL0  EQU     $003C	;CSCTL0 - CHIP SELECT CONTROL REG. 0
CSCTL1  EQU     $003D	;CSCTL1 - CHIP SELECT CONTROL REG. 1
CSSTR0  EQU     $003E	;CSSTR0 - CHIP SELECT STRETCH REG. 0
CSSTR1  EQU     $003F	;CSSTR1 - CHIP SELECT STRETCH REG. 1
LDVH    EQU     $0040	;LDV - LOOP DIVIDER HIGH REG.
LDVL    EQU     $0041	;LDV - LOW REG.
RDVH    EQU     $0042	;RDV - REFERENCE DIVIDER HIGH REG.
RDVL    EQU     $0043	;RDV - LOW REG.

CLKCTL  EQU     $0047	;CLKCTL - CLOCK CONTROL REG.

ATDCTL0 EQU     $0060	;ATDCTL0 - RESERVED
ATDCTL1 EQU     $0061	;ATDCTL1 - RESERVED
ATDCTL2 EQU     $0062	;ATDCTL2 - ATD CONTROL REG.
ATDCTL3 EQU     $0063	;ATDCTL3 - ATD CONTROL REG.
ATDCTL4 EQU     $0064	;ATDCTL4 - ATD CONTROL REG.
ATDCTL5 EQU     $0065	;ATDCTL5 - ATD CONTROL REG.

ATDSTAT         EQU     $0066
ATDSTATH        EQU     $0066   ;ATDSTAT - ATD STATUS HIGH REG.
ATDSTATL        EQU     $0067   ;ATDSTAT - LOW REG.

STDTEST         EQU     $0068
ATDTESTH        EQU     $0068   ;ATDTEST - ATD TEST HIGH REG.
ATDTESTL        EQU     $0069   ;ATDTEST - LOW REG.

PORTAD  EQU     $006F	;PORTAD - PORT AD DATA INPUT REG.
ADR0H   EQU     $0070	;ADR0H
ADR1H   EQU     $0072	;ADR1H
ADR2H   EQU     $0074	;ADR2H
ADR3H   EQU     $0076	;ADR3H
ADR4H   EQU     $0078	;ADR4H
ADR5H   EQU     $007A	;ADR5H
ADR6H   EQU     $007C	;ADR6H
ADR7H   EQU     $007E	;ADR7H

TIOS    EQU     $0080	;TIOS - TIMER INPUT CAPTURE/OUTPUT COMPARE SELECT
CFORC   EQU     $0081	;CFORC - TIMER COMPARE FORCE REG.
OC7M    EQU     $0082	;OC7M - OUTPUT COMPARE 7 MASK REG.
OC7D    EQU     $0083	;OC7D - OUTPUT COMPARE 7 DATA REG.

TCNT    EQU     $0084
TCNTH   EQU     $0084	;TCNT - TIMER COUNT HIGH REG.
TCNTL   EQU     $0085	;TCNT - HIGH REG.

TSCR    EQU     $0086	;TSCR - TIMER SYSTEM CONTROL REG.
TQCR    EQU     $0087	;TQCR - RESERVED
TCTL1   EQU     $0088	;TCTL1 - TIMER CONTROL REG. 1
TCTL2   EQU     $0089	;TCTL2 - TIMER CONTROL REG. 2
TCTL3   EQU     $008A	;TCTL3 - TIMER CONTROL REG. 3
TCTL4   EQU     $008B	;TCTL4 - TIMER CONTROL REG. 4
TMSK1   EQU     $008C	;TMSK1 - TIMER INTERRUPT MASK 1
TMSK2   EQU     $008D	;TMSK2 - TIMER INTERRUPT MASK 2
TFLG1   EQU     $008E	;TFLG1 - TIMER INTERRUPT FLAG 1
TFLG2   EQU     $008F	;TFLG2 - TIMER INTERRUPT FLAG2

TC0     EQU     $0090
TC0H    EQU     $0090	;TC0 - TIMER INPUT/CAPTURE COMPARE HIGH REG.0
TC0L    EQU     $0091	;TC0 - LOW REG.

TC1     EQU     $0092
TC1H    EQU     $0092	;TC1 - HIGH REG.
TC1L    EQU     $0093	;TC1 - LOW REG.

TC2     EQU     $0094
TC2H    EQU     $0094	;TC2 - HIGH REG.
TC2L    EQU     $0095	;TC2 - LOW REG.

TC3     EQU     $0096
TC3H    EQU     $0096	;TC3 - HIGH REG.
TC3L    EQU     $0097	;TC3 - LOW REG.

TC4     EQU     $0098 
TC4H    EQU     $0098	;TC4 - HIGH REG.
TC4L    EQU     $0099	;TC4 - LOW REG.

TC5     EQU     $009A
TC5H    EQU     $009A	;TC5 - HIGH REG.
TC5L    EQU     $009B	;TC5 - LOW REG.

TC6     EQU     $009C
TC6H    EQU     $009C	;TC6 - HIGH REG.
TC6L    EQU     $009D	;TC6 - LOW REG.

TC7     EQU     $009E
TC7H    EQU     $009E	;TC7 - HIGH REG.
TC7L    EQU     $009F	;TC7 - LOW REG.

PACTL   EQU     $00A0	;PATCL - PULSE ACCUMULATOR CONTROL REG.
PAFLG   EQU     $00A1	;PAFLG - PULSE ACCUMULATOR FLAG REG.

PACNT   EQU     $00A2
PACNTH  EQU     $00A2	;PACNT - 16 BIT PULSE ACCUMULATOR COUNT HIGH REG.
PACNTL  EQU     $00A3	;PACNT - LOW REG.

TIMTST  EQU     $00AD	;TIMTST - TIMER TEST REG.
PORTT   EQU     $00AE	;PORTT
DDRT    EQU     $00AF	;PORTT - DATA DIRECTION REG.

SC0BDH  EQU     $00C0	;SC0BDH - SCI BAUD RATE CONTROL REG.
SC0BDL  EQU     $00C1	;SC0BDL - SCI BAUD RATE CONTROL REG.
SC0CR1  EQU     $00C2	;SC0CR1 - SCI CONTROL REG.
SC0CR2  EQU     $00C3	;SC0CR2 - SCI CONTROL REG.
SC0SR1  EQU     $00C4	;SC0SR1 - SCI STATUS REG.
SC0SR2  EQU     $00C5	;SC0SR2 - SCI STATUS REG.
SC0DRH  EQU     $00C6	;SC0DRH - SCI DATA REG.
SC0DRL  EQU     $00C7	;SC0DRL - SCI DATA REG.
SC1BDH  EQU     $00C8	;SC1BDH - SCI BAUD RATE CONTROL REG.
SC1BDL  EQU     $00C9	;SC1BDL - SCI BAUD RATE CONTROL REG.
SC1CR1  EQU     $00CA	;SC1CR1 - SCI BAUD CONTROL REG.
SC1CR2  EQU     $00CB	;SC1CR2 - SCI CONTROL REG.
SC1SR1  EQU     $00CC	;SC1SR1 - SCI STATUS REG.
SC1SR2  EQU     $00CD	;SC1SR2 - SCI STATUS REG.
SC1DRH  EQU     $00CE	;SC1DRH - SCI DATA REG.
SC1DRL  EQU     $00CF	;SC1DRL - SCI DATA REG.
SP0CR1  EQU     $00D0	;SP0CR1 - SPI CONTROL REG.
SP0CR2  EQU     $00D1	;SP0CR2 - SPI CONTROL REG.
SP0BR   EQU     $00D2	;SP0BR - SPI BAUD RATE REG.
SP0SR   EQU     $00D3	;SP0SR - SPI STATUS REG.

SP0DR   EQU     $00D5	;SP0DR - SPI DATA REG.
PORTS   EQU     $00D6	;PORTS
DDRS    EQU     $00D7	;PORTS - DATA DIRECTION REG.

EEMCR   EQU     $00F0	;EEMCR - EEPROM MODULE CONFIGURATION
EEPROT  EQU     $00F1	;EEPROT - EEPROM BLOCK PROTECT
EETST   EQU     $00F2	;EETST - EEPROM TEST
EEPROG  EQU     $00F3	;EEPROG - EEPROM CONTROL
