;lcd_disp.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*February 4, 1999         V1.00
*Written by Exequiel Rarama for the ADAPT 812
********************************************************************************

; -----------------------------------
; Display Routines
; -----------------------------------

; Local Constants
lcd_ctrl                equ     %00010000       ;Port S bit 4 = 0 - Instruction in
lcd_data                equ     %00010000       ;Port S bit 4 = 1 - Data in
lcd_enable              equ     %10000000       ;Port S bit 7 - enable
BL                      EQU     $20

us22            equ     175
us11            equ     88
us1             equ     8
ms100           equ     $61a8
ms1             equ     $9c3
TEN             equ     $80


; Memory Allocation
;disp_buffer     ds      32              ;display buffer (2 lines of 16 chars)
;disp_ptr        ds      2               ;pointer to display buffer
;disp_flag       ds      1               ;1 = update; 0 = home; -1 = done
;drow_var        ds      1
;temp            ds      1
;lcd_state       ds      2

;-----------------------------------------------------------------------------
; Display Initialization
; ----------------------

disp_init

;Initialize PORTS
        bclr    PORTS,%10010000
        bset    DDRS,%10010000          ;Set direction for lcd control and enabe
        clr     drow_var
        clr     disp_flag

;Initialize PORTJ
        movb    #$ff,DDRJ               ;Bit 7->0 of PORTJ are Output
        movb    #$00,PORTJ

        bclr    PORTS,lcd_enable
        bclr    PORTS,lcd_ctrl          ;Set Port S bit 4 to zero

        movb    TMSK2,temp
        bset    TSCR,$B0        ;enable the timer sysem. set for fast flag clears
        bset    TIOS,%01        ;enable timer channel 0 as an output compare.
        movb    #$5,TMSK2       ;set the prescaler to /32

        ldd     #ms1*$0f        ;15 millisecond delay
        addd    TCNT
        std     TC0
        brclr   TFLG1,$01,*

        movb    #%00110000,PORTJ        ;8 data bits, 2 display lines, 0
        jsr     toggle_lcd_ctrl

;        bset    PORTS,lcd_enable
;        ldy     #10000
;lp1
;        dbne    y,lp1
;        bclr    PORTS,lcd_enable

        movb    #$00,TMSK2              ;set the prescaler to /1
        ldd     #us1*4                  ;40 microsecond delay
        addd    TCNT
        std     TC0
        brclr   TFLG1,$01,*

        movb    #%00111000,PORTJ        ;8 data bits, 2 display lines, 0
        jsr     toggle_lcd_ctrl

        ldd     #us1*4                  ;40 microsecond delay
        addd    TCNT
        std     TC0
        brclr   TFLG1,$01,*

        movb    #%1100,PORTJ            ;display on, cursor off, blink off
        jsr     toggle_lcd_ctrl

        ldd     #us1*100                ;100 microsecond delay
        addd    TCNT
        std     TC0
        brclr   TFLG1,$01,*

        movb    #%1,PORTJ               ;Clear display and return cursor to home
        jsr     toggle_lcd_ctrl

        ldd     #us1*4                  ;40 microsecond delay
        addd    TCNT
        std     TC0
        brclr   TFLG1,$01,*

        movb    #%01000000,PORTJ 
        jsr     toggle_lcd_ctrl

        ldd     #us1*4                  ;40 microsecond delay
        addd    TCNT
        std     TC0
        brclr   TFLG1,$01,*

	ldx	#cgram_table
	ldab	#CGRAM_LEN
        jsr     line_update

        movb    #%10000000,PORTJ
        jsr     toggle_lcd_ctrl

        ldd     #us1*4                  ;40 microsecond delay
        addd    TCNT
        std     TC0
        brclr   TFLG1,$01,*

        movb    temp,TMSK2              ;set the prescaler to original parameters

        ldx     #disp_menu1
        stx     lcd_state

        movb    #0,drow_var
        jsr     drow
        ldx     #Testing1
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #Testing2
        jsr     dstr

        ldx     #_1SECOND*3
        stx     lcd_timer

        movb    #0,drow_var
        jsr     drow
        ldx     #Testing1
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #Testing2
        jsr     dstr

        rts

toggle_lcd_ctrl
        bclr    PORTS,lcd_ctrl
        nop
        nop
        nop
        nop
        nop
        nop

        bset    PORTS,lcd_enable

        nop
        nop
        nop
        nop
        nop
        nop

        bclr    PORTS,lcd_enable
        nop
        nop
        nop
        rts


toggle_lcd_data
        bset    PORTS,lcd_data
        nop
        nop
        nop
        nop
        nop
        nop

        bset    PORTS,lcd_enable

        nop
        nop
        nop
        nop
        nop
        nop

        bclr    PORTS,lcd_enable
        nop
        nop
        nop
        rts

cgram_table
        db      %00000                  
        db      %00000
        db      %00000
        db      %00000
        db      %00000
        db      %00000
        db      %00000
        db      %00000


CGRAM_LEN       EQU     $-cgram_table

;=============================================================================
;These subroutine displays the various messages in 2 second interval and are
; called in the main loop.
;

disp_menu0                      ;dummy display

        rts

disp_menu1
        ldx     lcd_timer
        bne     lcd_ex1

        movb    #0,drow_var
        jsr     drow
        ldx     #L_HEADER1
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_UNDLN
        jsr     dstr

        ldx     #_1SECOND*2
        stx     lcd_timer

        ldx     #disp_menu2
        stx     lcd_state
        
lcd_ex1
        rts

disp_menu2
        ldx     lcd_timer
        bne     lcd_ex2

        movb    #0,drow_var
        jsr     drow
        ldx     #L_LINE1
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_LINE2
        jsr     dstr

        ldx     #_1SECOND*2
        stx     lcd_timer

        ldx     #disp_menu3
        stx     lcd_state

lcd_ex2
        rts


disp_menu3
        ldx     lcd_timer
        bne     lcd_ex3

        movb    #0,drow_var
        jsr     drow
        ldx     #L_LINE3
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_LINE4
        jsr     dstr

        ldx     #_1SECOND*2
        stx     lcd_timer

        ldx     #disp_menu4
        stx     lcd_state

lcd_ex3
        rts

disp_menu4
        ldx     lcd_timer
        bne     lcd_ex4

        movb    #0,drow_var
        jsr     drow
        ldx     #L_LINE5
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_LINE6
        jsr     dstr

        ldx     #_1SECOND*2
        stx     lcd_timer

        ldx     #disp_menu5
        stx     lcd_state

lcd_ex4
        rts

disp_menu5
        ldx     lcd_timer
        bne     lcd_ex5

        movb    #0,drow_var
        jsr     drow
        ldx     #L_LINE7
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_LINE8
        jsr     dstr

        ldx     #_1SECOND*2
        stx     lcd_timer

        ldx     #disp_menu6
        stx     lcd_state

lcd_ex5
        rts


disp_menu6
        ldx     lcd_timer
        bne     lcd_ex6

        movb    #0,drow_var
        jsr     drow
        ldx     #L_LINE9
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_LINE10
        jsr     dstr

        ldx     #_1SECOND*2
        stx     lcd_timer

        ldx     #disp_menu7
        stx     lcd_state

lcd_ex6
        rts

disp_menu7
        ldx     lcd_timer
        bne     lcd_ex7

        movb    #0,drow_var
        jsr     drow
        ldx     #L_LINE11
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_LINE12
        jsr     dstr

        ldx     #_1SECOND*2
        stx     lcd_timer

        ldx     #disp_menu8
        stx     lcd_state

lcd_ex7
        rts

disp_menu8
        ldx     lcd_timer
        bne     lcd_ex8

        movb    #0,drow_var
        jsr     drow
        ldx     #L_LINE13
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_LINE14
        jsr     dstr

        ldx     #_1SECOND*2
        stx     lcd_timer

        ldx     #disp_menu10
;        ldx     #disp_menu9
        stx     lcd_state

lcd_ex8
        rts

disp_menu9
        ldx     lcd_timer
        bne     lcd_ex9

        movb    #0,drow_var
        jsr     drow
        ldx     #L_LINE15
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_LINE16
        jsr     dstr

        ldx     #_1SECOND*2
        stx     lcd_timer

        ldx     #disp_menu10
        stx     lcd_state

lcd_ex9
        rts

disp_menu10
        ldx     lcd_timer
        bne     lcd_ex10

        movb    #0,drow_var
        jsr     drow
        ldx     #L_PROMPT
        jsr     dstr

        movb    #1,drow_var
        jsr     drow
        ldx     #L_LINE17
        jsr     dstr

        ldx     #_1SECOND*2
        stx     lcd_timer

        ldx     #disp_menu1
        stx     lcd_state

lcd_ex10
        rts


;-----------------------------------------------------------------------------

; Clear Display
; -------------

disp_clear
	ldx	#disp_buffer		;starting address of display buffer
	stx	disp_ptr		;home cursor
        ldab    #32                     ;number of characters
	ldaa	#BL

dcl10
        staa    0,x                     ;fill buffer with spaces
	inx
	decb
	bne	dcl10
	ldaa	#1			;set flag for immediate display
	staa	disp_flag		;  update

	rts

;-----------------------------------------------------------------------------

; Set Display Position
; --------------------
; This routine sets the display buffer pointer to the selected row
; and column position.  Values are assumed to be valid:  no range checking
; is performed.
;	Entry:	A contains row number (0 - 1)
;               B contains column number (0 - 15)

disp_pos
	ldx	#disp_buffer		;starting address of display buffer
	abx				;add column number
        ldab    #16
	mul
        abx                             ;add 16 x row number
	stx	disp_ptr
	rts
;-----------------------------------------------------------------------------

; Display Character
; -----------------
;	Entry:	A contains character to be displayed
;		B contains number of occurences (DISP_REP only)

disp_chr
	ldy	disp_ptr		;store character in display buffer
        cmpa    #$a6
	bne	dsc10
	ldaa	#4
dsc10
        staa    0,y
	iny
	bra	dispex

disp_rep
	ldy	disp_ptr
        cmpa    #$a6
	bne	drp10
	ldaa	#4

drp10	staa	0,y			;store character, decrement counter
	iny				;  and loop until done
	decb
	bne	drp10

dispex
        cpy     #disp_buffer+32
	blo	dsp10
	ldy	#disp_buffer
dsp10
        sty     disp_ptr
	ldaa	#1			;set flag for immediate display
	staa	disp_flag		;  update
	rts
;-----------------------------------------------------------------------------

; Display String
; --------------

disp_str
	ldy	disp_ptr

dst10
        ldaa    0,x
	beq	dst20
        cmpa    #$a6
	bne	dst15
	ldaa	#4

dst15
        staa    0,y
	inx
	iny
	bra	dst10

dst20
        inx
	bra	dispex

;--------
disp_strn
	ldy	disp_ptr

dsn10
        ldaa    0,x
        cmpa    #$a6
	bne	dsn15
	ldaa	#4

dsn15
        staa    0,y
	inx
	iny
	decb
	bne	dsn10

	bra	dispex
;-----------------------------------------------------------------------------

; Update Display
; --------------
;	This routine updates the LCD display from the display image in
; memory whenever the update flag is set.

disp_update
        ldaa    disp_flag               ;exit if display update flag is clr
        bmi     dupex                   ; 
	dec	disp_flag
	beq	dup10

        movb    #%00000010,PORTJ        ;home cursor
        jsr     toggle_lcd_ctrl
	bra	dupex

dup10
        ldab    #16                     ;number of characters per line
	ldx	#disp_buffer		;display 1st line
	jsr	line_update

        movb    #%11000000,PORTJ
        jsr     toggle_lcd_ctrl

;        pshd
;        ldd     #us1*$4                 ;40 microsecond delay
;        addd    TCNT
;        std     TC0
;        brclr   TFLG1,$01,*
;        puld

        pshy
        ldy     #100
dup20
        dbne    y,dup20
        puly

        ldab    #16
        ldx     #disp_buffer+16         ;display 2nd line
	jsr	line_update

        movb    #%1100,PORTJ            ;display on, cursor off, blink off
        jsr     toggle_lcd_ctrl

dupex
        rts

;----------------------------------------------------------------------------
line_update
	pshb				;save character count

lup10	ldaa	0,x			;write character to display
	cmpa	#'0'			;  (substitue O for 0)
	bne	lup15
	ldaa	#'O'

lup15                                   ;Display Char to LCD
        staa    PORTJ    
        jsr     toggle_lcd_data

;        pshd
;        ldd     #us1*$4                 ;40 microsecond delay
;        addd    TCNT
;        std     TC0
;        brclr   TFLG1,$01,*
;        puld

        pshy
        ldy     #100
lup20
        dbne    y,lup20
        puly

	inx				;advance to next character, decrement
	decb				;  count & loop if not done
	bne	lup10
	pulb				;restore character count

	rts

;==============================================================================

; Set Cursor Position
; -------------------
;       A contains row number
;       B contains column number

drow
        ldaa    drow_var                ;drow_var = 0 =>1st line
                                        ;drow_var = 1 =>2nd line
	ldab	#0
	jsr	disp_pos
        rts

dpos    
        ldaa    drow_var                ;drow_var = 0 =>1st line
                                        ;drow_var = 1 =>2nd line
        ldab    dcol_var                ;dcol_var = 0 => 16 1st line
                                        ;dcol_var = 0 => 16 2nd line
	jsr	disp_pos
        rts

; Display String
; --------------
;       X contains address of string to be displayed
;       B contains length of string (if absent:  nul terminates string)

dstr    
        jsr     disp_str
        rts

dstrn    
        jsr     disp_strn
        rts

dvalx   
        ldab    #5              ;will display 5 digit value
;        subb    #3              ;lenght of value
        subb    dig_lenght      ;lenght of value to be displayed
        abx                     ;Reg X contain the address to be displayed
        jsr     disp_strn
        rts

dhex    
        ldab    temp_h
        lsrb
        lsrb
        lsrb
        lsrb
        andb    #$0f
        ldx     #hex_table      ;convert hex to ascii
        abx
        ldaa    0,x             ;
        staa    TEMP1

        ldab    temp_h
        andb    #$0f
        ldx     #hex_table      ;convert hex to ascii
        abx
        ldaa    0,x
        staa    TEMP2
        rts

hex_table
        fcc     '0'     ;
        fcc     '1'
        fcc     '2'
        fcc     '3'
        fcc     '4'
        fcc     '5'
        fcc     '6'
        fcc     '7'
        fcc     '8'
        fcc     '9'
        fcc     'A'
        fcc     'B'
        fcc     'C'
        fcc     'D'
        fcc     'E'
        fcc     'F'

;Lcd Messages
Testing1
                fcc     " Technological  "
                fcb     0

Testing2
                fcc     " Arts           "
                fcb     0

L_LINE1         fcc     'A => SHOW PORT A'
                fcb     $00
L_LINE2         fcc     'B => SHOW PORT B'
                fcb     $00
L_LINE3         fcc     'C => SHOW PORT C'
                fcb     $00
L_LINE4         fcc     'D => SHOW PORT D'
                fcb     $00
L_LINE5         fcc     'E => SHOW PORT E'
                fcb     $00
L_LINE6         fcc     'F => SHOW PORT F'
                fcb     $00
L_LINE7         fcc     'G => SHOW PORT G'
                fcb     $00
L_LINE8         fcc     'H => SHOW PORT H'
                fcb     $00
L_LINE9         fcc     'J => CLR PORT J '
                fcb     $00
L_LINE10        fcc     'S => SHOW PORT S'
                fcb     $00
L_LINE11        fcc     'R => SHOW ANALOG'
                fcb     $00
L_LINE12        fcc     'T => SHOW PORT T'
                fcb     $00
L_LINE13        fcc     'L => FLASH D1   '
                fcb     $00
L_LINE14        fcc     '0-7 => TOGGLE J '
                fcb     $00
L_LINE15
L_TIME          fcc     'I => Set Time   '
                fcb     $00
L_LINE16
L_DATE          fcc     'K => Set Date   '
                fcb     $00

L_LINE17        fcc     '                '
                fcb     $00


L_CURRENT_TIME  fcc     'Current Time:   '
                fcb     $00
L_NEW_TIME      fcc     'New Time:       '
                fcb     $00
L_CURRENT_DATE  fcc     'Current Date:   '
                fcb     $00
L_NEW_DATE      fcc     'New Date:       '
                fcb     $00
L_PROMPT        fcc     'Your Choice ?   '
                fcb     $00

L_HEADER1       fcc     ' ADAPT-812 DEMO '
                FCB     $00
L_UNDLN         fcc     '________________'
                FCB     $00

L_CLR           fcc     '                '
                FCB     $00

L_AD0           fcc     'A0'
                fcb     $00
L_AD1           fcc     'A1'
                fcb     $00
L_AD2           fcc     'A2'
                fcb     $00
L_AD3           fcc     'A3'
                fcb     $00
L_AD4           fcc     'A4'
                fcb     $00
L_AD5           fcc     'A5'
                fcb     $00
L_AD6           fcc     'A6'
                fcb     $00
L_AD7           fcc     'A7'
                fcb     $00
L_PORTA         fcc     'Port A=         '
                fcb     $00
L_PORTB         fcc     'Port B=         '
                fcb     $00
L_PORTC         fcc     'Port C=         '
                fcb     $00
L_PORTD         fcc     'Port D=         '
                fcb     $00
L_PORTE         fcc     'Port E=         '
                fcb     $00
L_PORTF         fcc     'Port F=         '
                fcb     $00
L_PORTG         fcc     'Port G=         '
                fcb     $00
L_PORTH         fcc     'Port H=         '
                fcb     $00
L_PORTS         fcc     'Port S=         '
                fcb     $00
L_PORTT         fcc     'Port T=         '
                fcb     $00
L_JOFF          fcc     'PORT J CLEARED  '
                FCB     $00
L_BEEP          fcc     '>>>> BEEP!! <<<<'
                FCB     $00


    
