;Int.asm
*******************************************************************************
*  Interrupt Routines
*******************************************************************************
;
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*February 4, 1999         V1.00
*Written by Exequiel Rarama for the ADAPT 812
********************************************************************************
;
        org     PPAGE
        fcb     $7
        org     $8000+first_org         ;Link to the main routine

;----------------------------
* Real-time Interrupt Routine
;----------------------------
RealTimeInt
        movb    #rtiflag,RTIFLG         ;clear real-time interrupt flag
                                        ; so that other interrupts can be service
        cli

RTI_1
        ldx     TIMER
        beq     RTI_2
        dex
        stx     TIMER
RTI_2
        ldx     TIMER1
        beq     RTI_3
        dex
        stx     TIMER1
RTI_3
        sei
	ldaa    keybd_timer
        beq     RTI_4
	deca
	staa    keybd_timer
        bne     RTI_4
        ldaa    #11
        staa    keybd_count
RTI_4
        cli

RTI_5
        ldx     lcd_timer
        beq     RTI_6
        dex
        stx     lcd_timer

RTI_6
        brclr   ATDSTAT,SCFflag,*       ;Loop here until SCF of ATD is set
        movb    ADR0H,ad0               ;save ATD
        movb    ADR1H,ad1
        movb    ADR2H,ad2
        movb    ADR3H,ad3
        movb    ADR4H,ad4
        movb    ADR5H,ad5
        movb    ADR6H,ad6
        movb    ADR7H,ad7
        rti

*  SCI Input Interrupt Handler

*  Gets bytes from SCI.  Sets COMMAND_PENDING flag.

SerInputInt
        ldaa    time_flag
        bne     get_rtc_data

        ldaa    date_flag
        bne     get_rtc_data

        ldaa    SC0SR1                  ;read register to clear flag RDRF
        movb    SC0DRL,COMMAND          ;read receive buffer
        movb    #TRUE,COMMAND_PENDING
        bra     SIIX

get_rtc_data
        ldab    SC0SR1                  ;read register to clear flag RDRF
        ldaa    SC0DRL                  ;read receive buffer
        staa    rtc_buf
        inc     sci_rtc_buf_flag

SIIX
        rti

;This is needed to service SWI interrupt
dummy_int
        movb    #$55,COPRST
        movb    #$AA,COPRST
        rti

*  Output Compare Interrupt Handler
;------------------------
; Audio Interrupt Routine
; -----------------------
OC6Int
audio_int
        ldd     HALF_PERIOD
        addd    TC6
        std     TC6
        bset    TFLG1,%01000000          ;clear flag;
        rti

;--------------------------
;Keyboard Interrupt routine
;--------------------------
keybrd_int
        movb    #10,keybd_timer

        ldaa    PORTT
        rora

        ldd     keybd_value
        rora
        rorb
        std     keybd_value

;        bset    TFLG1,%10               ;Clear input capture 1 interrupt
        ldaa    TC1                     ;Read channel for fast clear

        dec     keybd_count
        bne     keyex

        movb    #11,keybd_count

        inc     keybd_flag

        ldx     keybd_value+2
        stx     keybd_value+3
        ldaa    keybd_value
        rol     keybd_value+1
        rola
        rol     keybd_value+1
        rola
        staa    keybd_value+2

keyex
;        bset    TFLG1,%10               ;Clear input capture 1 interrupt

        rti

