;Bootloader
;
;Author: Exequiel Rarama
;Revised by:  Carl Barnes
;code_adr       equ     RAM+$10         ;Defined in MAIN.ASM

burn_ee
        ldx     #code
        ldy     #code_adr
        ldab    #code_len

copy_strn
        ldaa    0,x                     ;get next byte from source string
        inx                             ;  & increment source address

        staa    0,y                     ;copy byte to destination string
        iny                             ;  & increment destination address

        decb                            ;loop until all bytes have been copied
        bne     copy_strn

;this is where it goes to burn the eeprom
; once it finishes loading bootloader code into ram
;
;
        jmp     code_adr

code   ;The beginning of code to be loaded to ram
                ;CAUTION! make sure to use relative branching from now on
        brclr   SC0SR1,RDRFflag,*
        ldab    SC0SR1          ;read register to clear flag RDRF
        ldab    SC0DRL          ;read receive buffer
        cmpb    #'S'            ;Wait until S received
        bne     code
                ;first, bulk erase the EEPROM
bulk_ee:
        bset    PORTT,%01000000         ;Test led 'ON' at start of bulk erase
        movb    #$8f,EEPROT                     ;protect bootcode and vectors in EEPROM
        movb    #%00000110,EEPROG       ;Set to Bulk Erase, EELAT=ERASE=1, ROW=BYTE=0
                staa    EEPROM                          ;Store 'Don't Care' Data to any aligned EEPROM Address
        bset    EEPROG,$01                      ;Turn on Programming Voltage, EEPGM=1
        bsr     delay10                         ;do some delay
        bclr    EEPROG,$01                      ;Turn off Programming voltage, EEPGM=0.
        bclr    EEPROG,$02                      ;Clear EE Latch, EELAT=0, Enables Read
        BSET    EEPROG,$80                                              ;protect from bulk erase
        bclr    PORTT,%01000000         ;Test led 'OFF' at end of bulk erase.
                bra     got_S

prg_ee
;program a byte
        bset    PORTT,%01000000                 ;Test led 'ON' at start of burn
        movb    #%10000010,EEPROG               ;set up for program with EELAT=1
        stab    0,y                     ;store data to be burn
        bset    EEPROG,$01                              ;EEPGM = 1
        bsr     delay10                 ;do some delay
        bclr    EEPROG,$01              ;EEPGM = 0
        bclr    EEPROG,%00000010        ;EELAT = 0
        bclr    PORTT,%01000000         ;Test led 'OFF' when finished programming byte
        rts

delay10:
        ldx     #$3E7E      ; Initialize counter to 10 ms delay value
LOOP:   dex                         ; Decrement Counter
        BNE     LOOP        ; If counter not equal to zero goto LOOP, else
        RTS                 ; Return from subroutine

prog_ee
        cpy     #$fffe         ;intercept reset vector & program pseudo-reset vector instead
        beq     vector1
        cpy     #$ffff
        beq     vector2
        cpy             #$ffc0
        blo             vex
        bclr    EEPROT,$01      ;if vector, then erase location first
        bsr             byte_erase
        bra             vex
vector1
        ldy     #$fdfe
        bra     vex
vector2
        ldy     #$fdff
vex
        bra     prg_ee

byte_erase:
                movb    #$9e,EEPROG     ;needed for programming new vectors (to be implemented)
                stab    0,y
                bset    EEPROG,$01
                bsr     delay10
                bclr    EEPROG,$01
                bclr    EEPROG,$02
                rts

load_s19

        bsr     readc
        cmpb    #'S'            ;Wait until S1 or S9 received,
        bne     load_s19        ; discarding checksum of previous S1 record
got_S
        bsr     readc
        cmpb    #'1'
        beq     load1           ;load1

        cmpb    #'9'
        bne     load_s19        ;Check for termination signal
        bra     led_off         ;Go signal the end of eeprom burn

load1
        bsr     rdbyte          ;Complete reading S9 record before terminating
        tba
        suba    #3              ;# of bytes, subtract address (2 byte) and checksum (1 byte)
        staa    byte_count      ;store it into byte counter

        bsr     getadr          ;Get the address of where to burn the data into eeprom
                                ;The address in contained in y reg
go_next_byte
        bsr     rdbyte          ;Get data to burn into the EEPROM
                                ;Reg b contains the data to be written
        bsr     prog_ee         ;Go burn eeprom
        iny                     ;increment address

        dec     byte_count      ;Decrement byte counter
        bne     go_next_byte    ;Go get next byte to burn
        bra     load_s19        ;End of S19 message, go get another one

led_off                                 ;loop here until reset
        ldaa    #$ff                    ;turn on all block protects
        staa    EEPROT
        bclr    PORTT,%01000000
        bra     *

rdbyte
        bsr     readc           ;first read MS nibble
        bsr     hexbin          ;convert to binary
        lslb                    ;and move to upper nibble
        lslb
        lslb
        lslb
        stab    temp
        bsr     readc           ;Get ASCII char in ACCB
        bsr     hexbin
        orab    temp
        rts

getadr
        psha                    ;save byte counter
        bsr     rdbyte          ;Read MS byte of address
        tba                     ;and put it in MS byte of ACCD
        bsr     rdbyte          ;Now read LS byte of address into Ls byte of ACCD
        xgdy                    ;Put load address in Y
        pula                    ;Restore byte counter
        rts                     ;and return

hexbin
        cmpb    #'9'            ;if ACCB>9 then assume its A-F
        bls     hexnum
        addb    #9

hexnum
        andb    #$0f
        rts

;--------------------------------
readc
        brclr   SC0SR1,RDRFflag,readc
        ldab    SC0SR1          ;read register to clear flag RDRF
        ldab    SC0DRL          ;read receive buffer
        rts

code_len equ    ($-code)
