;LAN.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*Oct 20, 2001		V1.00		LAN connectivity - Initial Release
*
*Jan 24, 2002		V1.02
*
*Author: Exequiel Rarama
********************************************************************************
;Assembled with MCUez

	include "REG812A.INC"

;Public Function
	XDEF LAN_init
	XDEF LAN_init_wait
	XDEF Reset_Crystal

	XDEF LAN_write
	XDEF LAN_read
	XDEF LAN_data

	XDEF Frame_Transmit			;Send Packet to LAN
	XDEF Frame_Read			;Read Packet from LAN

	XDEF go_LAN
	XDEF Poll_LAN

;Public Variables
	XDEF LAN_state
	XDEF LAN_wait_timer
	XDEF Frame_TxRx_flag

	XDEF Packet_Write_len
	XDEF Packet_Write_Buff

	XDEF Packet_Read_Buff
	XDEF Packet_Read_len

;External Function
	XREF OutStr
	XREF SerOutput0

	XREF Dump_word
	XREF Dump_byte

;External Variables
	XREF state_timer
	XREF wait_timer

	XREF CrLfStr

;------------------------------------------------------------------------------
EPAGE0		equ	$0700
LAN		equ	EPAGE0+$0000

;/*	Crystal CS8900A PacketPage	*/

PacketPage		equ	LAN+$00

portRxTxDataL		equ	LAN+$00
portRxTxDataH		equ	LAN+$01
portRxTxData1L	equ	LAN+$02
portRxTxData1H	equ	LAN+$03
portTxCmdL		equ	LAN+$04
portTxCmdH		equ	LAN+$05
portTxLengthL		equ	LAN+$06
portTxLengthH		equ	LAN+$07

portISQL		equ	LAN+$08
portISQH		equ	LAN+$09

portPtrL		equ	LAN+$0A
portPtrH		equ	LAN+$0B
portDataL		equ	LAN+$0C
portDataH		equ	LAN+$0D
portData1L		equ	LAN+$0E
portData1H		equ	LAN+$0F

;Internal Registers in I/O mode
ppEISA			equ	$0000
ppProdID		equ	$0002
ppIOBase		equ	$0020
ppIntNum		equ	$0022
ppMemBase		equ	$002C
ppRxCfg		equ	$0102
ppRxCtl		equ	$0104
ppTxCfg		equ	$0106
ppTxCmdRd		equ	$0108
vppBufCfg		equ	$010A
ppLineCtl		equ	$0112
ppSelfCtl		equ	$0114
ppBusCtl		equ	$0116
ppTestCtl		equ	$0118
ppISQ			equ	$0120
ppRxEvt		equ	$0124
ppTxEvent		equ	$0128
ppBufEvt		equ	$012C
ppRxMiss		equ	$0130
ppTxCol		equ	$0132
ppLineSt		equ	$0134
ppSelfSt		equ	$0136
ppBusSt		equ	$0138
ppTxCmd		equ	$0144
ppTxLength		equ	$0146
ppIndAddr		equ	$0158
ppRxStat		equ	$0400
ppRxLength		equ	$0402
ppRxFrame		equ	$0404
ppTxFrame		equ	$0A00
 
REG_NUM_MASK		equ	$003F
REG_NUM_RX_EV		equ	$0004
REG_NUM_TX_EV		equ	$0008
REG_NUM_BF_EV		equ	$000C
REG_NUM_RX_MS		equ	$0010
REG_NUM_TX_CL		equ	$0012

SELF_CTL_RST		equ	$0040
SELF_ST_INIT		equ	$0080
SELF_CTL_HC1E		equ	$2000
SELF_CTL_HCB1		equ	$8000

LNCTL_10BT_OF		equ	$0000			;/* Rx and Tx off */
LNCTL_10BT_ON		equ	$0060			;/* Rx and Tx on */
LINE_CTL_10BT		equ	$0000
LINE_CTL_10BASET	equ	$0000

TEST_CTL_FDX		equ	$4000

RX_CFG_RXOKIE		equ	$0100
RX_CTL_RX_OKA		equ	$0100
RX_CTL_IND_A		equ	$0400
RX_CTL_BCASTA		equ	$0800
RX_CTL_PRO_A		equ	$0080
RX_CTL_RUNT		equ	$2000

TX_CFG_ALL_IE		equ	$8F00
TX_CMD_STRTAL		equ	$00C0


Rdy4TxNow		equ	%00000001	;High byte bit 8 of BusST register
TxOK			equ	%00000001	;High byte bit 8 of TxEvent register
RxOK			equ	%00000001	;High byte bit 8 of RxEvent
Runt			equ	%00100000	;High byte bit D of RxEvent
RxOKiE			equ	%00000001	;High byte bit 8 of RxCFG

PolarityOK		equ	%00010000	;High byte bit C of LineST
LinkOK			equ	%10000000	;Low byte Bit 7 of LineST

MsgLen			equ	29		;Data length
tx_flag		equ	%000000001	;Bit 0 = 1 ->Data to be transmitted to LAN
rx_flag		equ	%000000010	;Bit 1 = 1 ->Data to be read from LAN

TDREflag		equ	%10000000	;TDRE - Transmit Data Register Empty flag
;------------------------------------------------------------------------------
DataSec:	SECTION

;/*	Ethernet packet offsets	*/

pktLenH		ds.b	1
pktLenL		ds.b	1

pktDest0H		ds.b	1
pktDest0L		ds.b	1

pktDest1H		ds.b	1
pktDest1L		ds.b	1

pktDest2H		ds.b	1
pktDest2L		ds.b	1

pktSrc0H		ds.b	1
pktSrc0L		ds.b	1
pktSrc1H		ds.b	1
pktSrc1L		ds.b	1
pktSrc2H		ds.b	1
pktSrc2L		ds.b	1
pktTypeH		ds.b	1
pktTypeL		ds.b	1

;/* with IP	*/

ip_verlen		ds.b	1
ip_tos			ds.b	1
ip_len			ds.b	1
ip_id			ds.b	1
ip_fragoff		ds.b	1
ip_ttl			ds.b	1
ip_proto		ds.b	1
ip_cksum		ds.b	1
ip_src			ds.b	1
ip_dst			ds.b	1
ip_data		ds.b	1

;Crystal Lan variables
var			ds.b	4

LAN_state		ds.b	2
LAN_wait_timer	ds.b	2	;Transmit Timer
Frame_TxRx_flag	ds.b	1	;Frame transmit/Receive flag

portISQ_buff		ds.b	2	;Interrupt Service Queu
Packet_Write_ptr	ds.b	2
Packet_Write_len	ds.b	2
Packet_Read_ptr	ds.b	2
Packet_Read_len	ds.b	2
Packet_Write_Buff	ds.b	32*2
Packet_Read_Buff	ds.b	32*2

;------------------------------------------------------------------------------
CodeSec: 	SECTION

LAN_init_wait
	movw	#go_LAN,LAN_state		
	movw	#122*1,LAN_wait_timer
	movb	#%01000000,DDRT		;LED output
	clr	Frame_TxRx_flag		;Clear Transmit/Receive flag for next Frame transmit

	rts

Reset_Crystal
	movw	#ppSelfCtl,var			
	movw	#SELF_CTL_RST,var+2		;issue a reset to the chip
	jsr	WritePP			;Write to Internal Register

Check_INITD_bit
	ldd	#ppSelfSt			;get self status
	jsr	ReadPP
	std	var				;Save word to memory to check bit

	brclr	var+1,SELF_ST_INIT,Check_INITD_bit	;Check SelfSt register Bit 7 if set

	movw	#Poll_LAN,LAN_state		;go Poll ISQ
	clr	Frame_TxRx_flag		;Clear Transmit/Receive flag for next Frame transmit

	ldx	#Msg_Reset			;Reset Message
	jsr	OutStr
	rts

;------------------------------------------------------------------------------
LAN_init
	ldx	#Msd_Id
	jsr	OutStr

	ldd	#ppEISA			;Get Manufacturer Product Identification Code
	jsr	ReadPP
	pshd					;Exchange byte order
	pulb
	pula
	jsr	Dump_word			;Internal Address = $0000 to $0001

	ldd	#ppEISA+2			;Get Manufacturer Product Identification Code
	jsr	ReadPP
	pshd					;Exchange byte order
	pulb
	pula
	jsr	Dump_word			;Internal Address = $0002 to $0003

	ldx	#CrLfStr
	jsr	OutStr

	movw	#ppLineCtl,var
	movw	#LINE_CTL_10BASET,var+2	;set to 10BaseT
	jsr	WritePP			;Write to Internal Register

	movw	#ppTestCtl,var
	movw	#TEST_CTL_FDX,var+2		;set to full duplex
	jsr	WritePP

	movw	#ppRxCfg,var			;
	movw	#RX_CFG_RXOKIE|RX_CTL_RUNT,var+2	;enable RxOK and Runt interrupt
	jsr	WritePP			;Write to Internal Register

	movw	#ppRxCtl,var			;
	movw	#RX_CTL_RUNT|RX_CTL_RX_OKA|RX_CTL_IND_A|RX_CTL_BCASTA|RX_CTL_PRO_A,var+2
	jsr	WritePP			;Write to Internal Register

	movw	#ppTxCfg,var			;Enable TxEvent Interrupt
	movw	#TX_CFG_ALL_IE,var+2
	jsr	WritePP			;Write to Internal Register

;Start of MAC
	movw	#ppIndAddr+0,var		;
	movw	#MAC_Address+0,var+2
	jsr	WritePP			;Write to Internal Register

	movw	#ppIndAddr+2,var		;
	movw	#MAC_Address+2,var+2
	jsr	WritePP			;Write to Internal Register

	movw	#ppIndAddr+4,var		;
	movw	#MAC_Address+4,var+2
	jsr	WritePP			;Write to Internal Register
;End of MAC

	movw	#ppIntNum,var			;
	movw	#$0000,var+2			;INT is on IRTRQ0
	jsr	WritePP			;Write to Internal Register

	ldd	#ppBusCtl			;get Bus Control
	jsr	ReadPP
	
	pshd
	jsr	Dump_word
	ldx	#CrLfStr
	jsr	OutStr
	puld

	oraa	#$80				;Set bit F of BusCTL to Enable IRQ
	orab	#$00
	std	var+2			
	movw	#ppBusCtl,var			; 
	jsr	WritePP			;Write to Internal Register
	
	ldd	#ppLineCtl			;get Line Control
	jsr	ReadPP

	pshd
	jsr	Dump_word
	ldx	#CrLfStr
	jsr	OutStr
	puld

	oraa	#$00				;
	orab	#$C0
	std	var+2				;set SerRxOn and SerTxOn
	movw	#ppLineCtl,var		;Enable Rx and Tx
	jsr	WritePP			;Write to Internal Register

	clr	Frame_TxRx_flag		;Clear Transmit/Receive flag for next Frame transmit

	ldd	#ppLineSt
	jsr	ReadPP				;Check Line Status

	std	var
	brclr	var+1,LinkOK,Link_bad

	ldx	#Msg_link_good
	jsr	OutStr
	bra	LAN_init_10

Link_bad
	ldx	#Msg_link_bad
	jsr	OutStr

LAN_init_10
	brclr	var,PolarityOK,Pol_bad

	ldx	#Msg_Pol_good
	jsr	OutStr
	bra	LAN_init_20

Pol_bad
	ldx	#Msg_Pol_bad
	jsr	OutStr

LAN_init_20
	ldx	#Msg_Init			;CS8900 initialised
	jsr	OutStr

LAN_init_ex
	rts

;------------------------------------------------------------------------------
go_LAN
	ldx	LAN_wait_timer
	bne	go_LAN_ex

	movw	#Poll_LAN,LAN_state		;go Poll ISQ

go_LAN_ex
	rts

;------------------------------------------------------------------------------
LAN_data
	rts


LAN_read
	jsr	Frame_Read
	ldd	#ppRxEvt			;Clear RxEvent to receive next available Frame
	jsr	ReadPP				;Read Internal register

	rts


LAN_write
	rts

;------------------------------------------------------------------------------
delay	
	ldy	#$8000

delay10
	dbne	y,delay10
	rts


;==============================================================================
Poll_LAN
	ldx	#portISQL			;Point to Interrupt Service Queu address
	ldab	0,x				;Get Low Byte
	ldaa	1,x				;Get High byte
	std	portISQ_buff

	ldaa	portISQ_buff+1		;Check if 0
	beq	Poll_LAN_ex			;If 0 then done checking ISQ

	cmpa	#REG_NUM_RX_EV		;Check if RxEvent
	beq	go_RxEvent			;go Read Frame if equal

	cmpa	#REG_NUM_TX_EV		;Chech if TxEvent
	beq	go_TxEvent			;go Transmit Frame if equal

	rts					;Ignore RxMiss and TxCol event

go_RxEvent
	movw	#Frame_Read,LAN_state	;go Frame read
	bra	Poll_LAN_ex			

go_TxEvent
	rts

	movw	#Frame_Transmit,LAN_state	;go Frame Transmit

Poll_LAN_ex
	rts


;------------------------------------------------------------------------------
Frame_Read
	ldx	#Msg_RxEvent
	jsr	OutStr
	ldd	portISQ_buff			;<--testPoll_LAN_ex
	jsr	Dump_word			;Dump RxEvent

;Discard Byte
	ldx	#Msg_Discard			;This value should be the same as RxEvent
	jsr	OutStr
	ldx	#portRxTxDataL
	ldaa	1,x				;High byte - read and discard status
	ldab	0,x				;Low byte - read and discard status
	jsr	Dump_word			;<--test

;Byte Length
	ldx	#Msg_read_len			;<--test
	jsr	OutStr
	ldx	#portRxTxDataL
	ldaa	1,x				;Hight byte - get length
	ldab	0,x				;Low byte - get length
	std	Packet_Read_len		;Save to Read memory counter
	jsr	Dump_word			;<--test

	ldx	#CrLfStr
	jsr	OutStr

;-->test
	ldd	Packet_Read_len		;Get byte count, check for 0 count just in case
	beq	Frame_Read_ex

	ldx	#portRxTxDataL		;Get Packet Page Data Port
	ldy	#Packet_Read_Buff		;Get Read Frame buffer

Byte_read
	movb	1,x,1,y+			;Save data to buffer and increment
	dbeq	D,Frame_Read_10		;Check if Odd count
	movb	0,x,1,y+			;Save to Buffer and increment
	dbne	D,Byte_read			;Decrement byte counter - at this point the byte counter is even

Frame_Read_10
	movw	#Packet_Read_Buff,Packet_Read_ptr	;Initialize pointer
	movw	#Dump_LAN_data,LAN_state	;go Dump data to SCI
	rts

Frame_Read_ex
	movw	#Poll_LAN,LAN_state		;go Poll ISQ
	rts

;------------------------------------------------------------------------------
Dump_LAN_data
	ldx	#Msg_Data1
	jsr	OutStr

	ldx	Packet_Read_len		;Get byte counter	
	ldy	#Packet_Read_Buff		;Get Read Frame buffer

Dump_10
	ldaa	0,y
	jsr	Dump_byte
	iny
	dbne	x,Dump_10			;Decrement counter, check if zero byte count

;-->Test
	ldx	#CrLfStr
	jsr	OutStr

	ldx	Packet_Read_Buff+13		;Get Data byte from Frame counter	
	inx					;<-Test

	ldy	#Packet_Read_Buff+15		;Get Read Frame buffer

Dump_20
	ldaa	0,y
	jsr	SerOutput0
	iny
	dbne	x,Dump_20			;Decrement counter, check if zero byte count

	ldx	#CrLfStr
	jsr	OutStr

;-->End Test

	bclr	Frame_TxRx_flag,rx_flag	;Clear Receive flag for next Read transmit
	movw	#Poll_LAN,LAN_state		;go Poll ISQ
	rts

;------------------------------------------------------------------------------
Frame_Transmit
	brclr	Frame_TxRx_flag,tx_flag,Frame_txex	;Check transmit bit flag

	ldx	#portTxCmdL
	ldd	#$00c0				;Request for buffer space, TxPadDis=1 (Runt will be transmitted)
						;Append CRC, Force bit=1
	stab	0,x				;Low Byte
	staa	1,x				;High Byte

	movw	#MsgLen,Packet_Write_len	;<---This is a test

	ldd	Packet_Write_len
	lsrd					;Check if Odd or even Byte
	bcs	Make_even_length	

	bra	Length_OK			;Length is even

Make_even_length
	ldx	Packet_Write_len
	inx	
	stx	Packet_Write_len		;Make byte count even

Length_OK
	ldx	#portTxLengthL
	ldd	Packet_Write_len		;Get Packet length for write
	stab	0,x				;Low Byte - Packet Length
	staa	1,x				;Hight Byte - Packet Length

	movw	#check_BusST,LAN_state	;go check BusST Rdy4TxNow flag
	movw	#122*2,LAN_wait_timer	;Set for 2 second wait

Frame_txex
	rts

check_BusST
	ldd	#ppBusSt
	jsr	ReadPP				;Read Internal register

	std	var					;Save temporarily
	brclr	var,Rdy4TxNow,check_BusST_10	;Check BusST register Bit 8 if set

	movw	#Transmit_to_LAN,LAN_state	;go Transmit to LAN
	movw	#00,LAN_wait_timer		;clr Timer
	bclr	Frame_TxRx_flag,tx_flag	;clear transmit flag for next transfer

	rts

check_BusST_10					
	ldx	LAN_wait_timer		;Check if timed out
	bne	check_BusST_20

	ldx	#Transmit_timer_error	;Yes, timed out
	jsr	OutStr

	movw	#Poll_LAN,LAN_state		;go Poll ISQ

check_BusST_20
	rts


Transmit_to_LAN
	ldd	Packet_Write_len
	ldx	#portRxTxDataL
	ldy	#Packet_Write_Buff
	ldy	#Msg_test1		;<-----This is a Test

Byte_Send
	movb	1,y+,1,x		;Move data to Data Port and increment to next address
					;High Byte - Motorola byte order

	dbeq	d,Frame_Ex		;Decrement byte count.  If pointer is odd and reached 0 then exit else
	movb	1,y+,0,x		;Move data to Data Port and increment to next address
					;Low Byte - Motorola byte order

	dbne	d,Byte_Send		;Loop until done - decrement again and check for end of buffer

Frame_Ex
	bclr	Frame_TxRx_flag,tx_flag	;Clear transmit flag for next Frame transmit
	movw	#Poll_LAN,LAN_state		;go Poll ISQ
	movw	#00,LAN_wait_timer		;clr Timer

	rts			


;------------------------------------------------------------------------------
; 	Reg D contains the offset of the Internal register 
;	Reg D returns the data read from the Internal register 
		
ReadPP
	ldx	#portPtrL		;Packet Port Pointer
	stab	0,x			;Low byte address of Internal register
	staa	1,x			;High byte address of Internal register

	ldx	#portDataL		;Data Pointed to by Reg D
	ldab	0,x			;Low byte data of Internal register
	ldaa	1,x			;Hight byte data of Internal register

	rts				;Reg D contain the value - Motorola byte order

;------------------------------------------------------------------------------
; 	Reg D contains the offset of the Internal register. 
;	Reg var contains the data to be written into the Internal register 
 
WritePP					
	ldx	#portPtrL		;Packet Port Pointer
	ldd	var
	stab	0,x			;Low byte address of Internal register
	staa	1,x			;High byte address of Internal register

	ldx	#portDataL		;Data Pointed to by Reg D
	ldd	var+2
	stab	0,x			;Low byte data to Internal register
	staa	1,x			;High byte data to Internal register
	
	rts				;No return value

;------------------------------------------------------------------------------
IP_Address	dc.b	193	;IP1
		dc.b	168	;IP2
		dc.b	96	;IP3
		dc.b	155	;IP4

;*	MAC address MAC1-MAC2-MAC3-MAC4-MAC5-MAC6	*

MAC_Address	dc.b	$06	;MAC1
		dc.b	$06	;MAC2
		dc.b	$06	;MAC3
		dc.b	$06	;MAC4
		dc.b	$06	;MAC5
		dc.b	$06	;MAC6

Source_ADD	dc.b	$07	;SA1
		dc.b	$08	;SA2
		dc.b	$09	;SA3
		dc.b	$0a	;SA4
		dc.b	$0b	;SA5
		dc.b	$0c	;SA6


Msg_Data		dc.b	$0a,$0d,"Getting Data",$0
Msg_Data1		dc.b	$0a,$0d,"Dumping to SCI - ",$0

Msg_Init		dc.b	$0a,$0d,"CS8900 initialised",$0

Transmit_timer_error	dc.b	$0a,$0d,"Crystal LAN not Ready",$0

Msg_test1		dc.b	$06,$06,$06,$06,$06,$06,$07,$08,$09,$0a,$0b,$0c,$0d,$00,$0e,"THIS IS A TEST",$0

Msg_test2		dc.b	$0a,$0d,"Data is in Buffer waiting for TxOK bit to set",$0
Msg_test3		dc.b	$0a,$0d,"Data Transmitted correctly",$0
Msg_test4		dc.b	$0a,$0d,"Data Did not Transmit correctly",$0
Msg_Reset		dc.b	$0a,$0d,"Crystal Chip is Reset",$0
Msg_link_bad		dc.b	$0a,$0d,"Link BAD",$0
Msg_link_good		dc.b	$0a,$0d,"Link GOOD",$0
Msg_Pol_bad		dc.b	$0a,$0d,"Polarity BAD",$0
Msg_Pol_good		dc.b	$0a,$0d,"Polarity GOOD",$0

Msg_read_len		dc.b	$0a,$0d,"Frame Read Length - ",$0
Msg_RxEvent		dc.b	$0a,$0d,"RxEvent Status - ",$0		
Msg_RxLength		dc.b	$0a,$0d,"RxLength (Packet Page + $402) - ",$0
Msg_Discard		dc.b	$0a,$0d,"Discard Status - ",$0		

Msd_Id			dc.b	$0d,$0a,"Crystal LAN ID Number - ",$0

	
	END
