;MAIN.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*Oct 20, 2001		V1.00		LAN connectivity - Initial Release
*
*Author: Exequiel Rarama
********************************************************************************
;Assembled with MCUez

; ---------------------------
; Demo - Main Routine
; ---------------------------

	include "REG812A.INC"

;Public Function
	XDEF ResetFunc		;Pointed to by reset vector

;Public Variables
	XDEF state		
	XDEF state_timer
	XDEF wait_timer
	XDEF command_pending

;External Function
	XREF RealTimeInit	;Initialize RTI

	XREF msg_init		;Display message
	XREF msg_prompt

	XREF go_power

	XREF LAN_init_wait
	XREF Reset_Crystal
	XREF LAN_init		;Initialize Crystal Lan chip
	XREF Poll_LAN


;External Variables
	XREF command_state
	XREF LAN_state

;------------------------------------------------------------------------------
*  Operational Parameters

RAM		equ	$0800		;68HC912b32 internal RAM
STACK		equ	$0c00		;Stack at top of internal ram
rbase		equ	$0000		;68HC912B32 register block
EEPROM		equ	$0d00		;68HC912B32 internal EEPROM
CODE		equ	$8000		;Start of Flash

* Operational Constants

;SCI Variables
scimask         equ     %00101100       ;RIE - SCI Interrupt enable
                                        ;RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
;MCLK=8Mzh
BAUD110         equ     4545    ;(baud) 110 baud with 16 Mhz crystal
BAUD300         equ     1667    ;(baud) 300 baud with 16 Mhz crystal
BAUD600         equ     833     ;(baud) 600 baud with 16 Mhz crystal
BAUD1200        equ     417     ;(baud) 1200 baud with 16 Mhz crystal
BAUD2400        equ     208     ;(baud) 2400 baud with 16 Mhz crystal
BAUD4800        equ     104     ;(baud) 4800 baud with 16 Mhz crystal
BAUD9600        equ     52      ;(baud) 9600 baud with 16 Mhz crystal
BAUD14400       equ     35      ;(baud) 14400 baud with 16 Mhz crystal
BAUD19200       equ     26      ;(baud) 19200 baud with 16 Mhz crystal
BAUD38400       equ     13      ;(baud) 19200 baud with 16 Mhz crystal

;
EWDIR		equ	$80		;Extra window position
CS3EP		equ	%00001000	;CS3
;------------------------------------------------------------------------------
DataSec:	SECTION

* System Variables

;timers
state			ds.b	2
state_timer		ds.b	2
wait_timer		ds.b	2
command_pending	ds.b	1

;------------------------------------------------------------------------------
CodeSec: 	SECTION

ResetFunc					;This is where the RESET vector points to
	sei					;Disable Any interrupts

;Initialize COP
	bset	COPCTL,%111			;COP is armed to reset in 1 second

;Initialize Stack
	lds	#STACK				;initialize stack pointer

;Set up external memory control registers
	movb	#$04,PEAR			;enable read/write signal
	movb	#$B0,MODE			;normal exp. narrow

	movb	#$20,WINDEF			;enable extra windows
	movb	#$0F,MXAR			;enable A16, A17, A18, A19

	movb	#%00101000,CSCTL0		;enable CSP0 to cover $8000 to $FFFF, Enable CS3
	movb	#%00001000,CSCTL1		;enable EPAGE (extra page) CS3 follow epage
	bclr	MISC,EWDIR

	clr	EPAGE				;Initialize EPAGE to Page 0

;Initialize Serial Communication Interface
	movb	#scimask,SC0CR2		;enable SCI 0 rcvr. & xmtr. & rx int    
	movb	#0,SC0CR1			
	movw	#BAUD9600,SC0BDH		;Set baud rate to 9600    
	ldaa	SC0SR1				;read register to clear flag RDRF
	ldaa	SC0DRL				;dummy read to flush receive buffer

	jsr	RealTimeInit			;Initialize Real time clock
	jsr	go_power
	jsr	LAN_init_wait			;Initialize Port use for Crystal

	jsr	msg_init			;display message
	jsr	LAN_init
	jsr	msg_prompt			;go show prompt

	clr	command_pending		;Initialize command flag
	cli					;unmask interrupts

main
	movb	#$55,COPRST     	;
	movb	#$AA,COPRST

	ldx	state			;Process state routine
	jsr	0,x

	ldx	command_state		;Process command state
	jsr	0,x

	ldx	LAN_state		;Process LAN state
	jsr	0,x

main10
	bra	main


	END