;MAIN.ASM
;Bootloader for the 812A4 processor
;
;Author: Exequiel Rarama
;
$BASE 0AH

        INCLUDE "REGS.INC"

RAM             equ     $0800
STACK           equ     $0BFF
EEPROM          equ     $f000
EEPROM_BOOT     equ     $fe00

;SCI Variables
scimask         equ     %00001100       ;TE - Transmit Enable
                                        ;RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

$BASE 10T
;Baud rate definitions
;MCLK=8Mzh
BAUD110         equ     4545    ;(baud) 110 baud with 16 Mhz crystal
BAUD300         equ     1667    ;(baud) 300 baud with 16 Mhz crystal
BAUD600         equ     833     ;(baud) 600 baud with 16 Mhz crystal
BAUD1200        equ     417     ;(baud) 1200 baud with 16 Mhz crystal
BAUD2400        equ     208     ;(baud) 2400 baud with 16 Mhz crystal
BAUD4800        equ     104     ;(baud) 4800 baud with 16 Mhz crystal
BAUD9600        equ     52      ;(baud) 9600 baud with 16 Mhz crystal
BAUD14400       equ     35      ;(baud) 14400 baud with 16 Mhz crystal
BAUD19200       equ     26      ;(baud) 19200 baud with 16 Mhz crystal
BAUD38400       equ     13      ;(baud) 19200 baud with 16 Mhz crystal

$BASE 0AH

        org     RAM

temp            ds      1
head			ds		1
tail			ds		1
byte_count      ds      1
ee_adr          ds      2
buffer			ds		64
code_adr        equ     $

        org     EEPROM_BOOT

; Start of Program
; ----------------
reset
        sei
        lds     #STACK                  ;initialize stack to top of ram

;Initialize PLL Clock
        ldaa    #%00000000      ;MUXCLK=SYSCLK=16Mhz, SYSCLK/2=E clock (16mhz/2=8mhz)
        staa    CLKCTL          ;MCLK=PCLK=8Mhz

;Initialize COP
        ldaa    #%00000000      ;COP is diabled
        staa    COPCTL          ;

;Initialize PORTT
        ldaa    #%01000000      ;Bit 6 PORTT as Output
        staa    DDRT
        ldaa    #$0
        staa    PORTT

check_port                      ;check bit 6 of PORTC to determine boot
        MOVB	#0,DDRC         ; or jump to user's program
        BSET	PUCR,$04		;make sure pullup is enabled
        brclr   PORTC,%01000000,go_boot
        bra     user_code               ;jump to user's code.

go_boot
;Initialize Serial Communication Interface
        ldaa    #scimask        ;enable SCI 0 rcvr. & xmtr. & rx int
        staa    SC0CR2
        ldaa    #0
        staa    SC0CR1
        ldx     #BAUD1200
        stx     SC0BDH
        ldaa    SC0SR1          ;read register to clear flag RDRF
        ldaa    SC0DRL          ;dummy read to flush receive buffer

        jmp     burn_ee         ;go burn eeprom (this routine is in BULKEE.ASM)

user_code
        ldx     $fdfe
        cpx     #$ffff
        beq     go_error
        jmp     0,x

;comes here if vector address is undefine
go_error
        bclr    PORTT,%01000000
        bsr     delay
        bset    PORTT,%01000000
        bsr     delay
        bra     go_error

delay
        ldab    #4
dly1
        ldy     #0
dly2
        dey
        bne     dly2
        decb
        bne     dly1
        rts

        INCLUDE "bulkee.asm"

;=============================================================================
;Vector
        ORG     $FFFE
        FDB     reset           ;RESET

