;STATES.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*Oct 20, 2001		V1.00		LAN connectivity - Initial Release
*
*Author: Exequiel Rarama
********************************************************************************
;Assembled with MCUez

	include "REG812A.INC"

;Public Function
	XDEF go_power

;Public variables
	XDEF delay_timer
	XDEF command_state

;External Function
	XREF LAN_write
	XREF LAN_read
	XREF LAN_data
	XREF LAN_init

	XREF Dump_word

	XREF Frame_Transmit			;Transmit Packet of Data to LAN
	XREF Frame_Read			;Read Packet from LAN

	XREF Reset_Crystal
	XREF go_LAN

	XREF msg_prompt

;External Variables
	XREF state		
	XREF state_timer
	XREF wait_timer

	XREF sci_com_data
	XREF command_pending
	XREF OutStr
	XREF SerOutput0
	XREF Frame_TxRx_flag

	XREF LAN_wait_timer
	XREF LAN_state

;Mask
tx_flag		equ	%000000001	;Bit 0 = 1 ->Data to be transmitted to LAN
rx_flag		equ	%000000010	;Bit 1 = 1 ->Data to be read from LAN

;------------------------------------------------------------------------------
DataSec:	SECTION
delay_timer	ds.b	2
command_state	ds.b	2

;------------------------------------------------------------------------------
CodeSec: 	SECTION

go_power	
	movw	#state_loop,state
	movw	#go_ready,command_state

	rts

state_loop
	rts

go_ready
	ldaa	command_pending
	beq	go_ready_ex

	clr	command_pending	;clear flag for next command

	ldaa	sci_com_data
	anda	#$df			;simple convert to upper case (only works for alpha char)

	cmpa	#'A'			;
	beq	go_test_page0

	cmpa	#'B'			;
	beq	go_Reset_Crystal

	cmpa	#'C'			;
	beq	go_send_data

	cmpa	#'D'			;
	beq	go_get_data

	jsr	msg_prompt

go_ready_ex
	rts

;------------------------------------------------------------------------------
go_test_page0
	movb	#$0,EPAGE			;Page 0 = $400 + $300 for the Crystal address
	jsr	LAN_init

	rts

;------------------------------------------------------------------------------
go_Reset_Crystal
	ldx	#Msg_Reset			;Resetting Crystal
	jsr	OutStr
	jsr	Reset_Crystal			;Initialize LAN_state and do Software Reset
	rts

;------------------------------------------------------------------------------
go_send_data
	bset	Frame_TxRx_flag,tx_flag	;Set flag for transmit
	jsr	Frame_Transmit		;go transmit data
	rts

go_get_data
	jsr	LAN_read			;go Read data
;	jsr	Frame_Read			;go Read data

	rts


;------------------------------------------------------------------------------
Msg_Page0	dc.b	$0d,$0a,"Test Page 0",$0d,$0a,$0
Msg_Reset	dc.b	$0d,$0a,"Resetting Crystal",$0d,$0a,$0

	
	END