
#include <hc12.h>

#define	PORTP	_P(0x56)
#define	DDRP	_P(0x57)


/* Local Constants	*/

#define lcd_ctrl 	0x40   		/*	Port A bit 6 = 0 - Instruction in	*/
#define lcd_data 	0x40    	/*	Port A bit 6 = 0 - Data in	*/
#define lcd_enable 	0x80  		/*	Port A bit 7 - enable	*/
#define	BL 			0x20
#define EOT 		0x04        /*	end of text/table	*/

#define TRUE    	0xFF
#define FALSE   	0x00


/*	Spi initialization variables	*/

#define spi_mask1 0x50   /*	SPE,MSTR=1, SWOM,CPOL,CPHA=0	*/
#define spi_mask2 0xE0   /*	Bit 7,6,5=1 the rest=0	*/

#define spi_baud1 0x0    /*	4.0 Mhz	*/
#define spi_baud2 0x01   /*	2.0 Mhz	*/
#define spi_baud3 0x02   /*	1.0 Mhz	*/
#define spi_baud4 0x03   /*	0.5 Mhz	*/
#define spi_baud5 0x04   /*	250 kHz	*/
#define spi_baud6 0x05   /*	125 kHz	*/
#define spi_baud7 0x06   /*	62.5 kHz	*/	
#define spi_baud8 0x07   /*	31.3 kHz	*/
#define SPIF 0x80        /*	flag after the 8th clock	*/
#define SPIE 0x80        /* Spi interrupt enable	*/    
#define LSBF 0x01        /*	SPI LSB First enable	*/
/*#define slave_select 0x80       *Chip select for the sound chip*	*/

#define SSPIN 0x80       /*	Chip select for the sound chip	*/

#define TEN 0x80
#define us2 0x08





/*	lcd messages	*/

char ok[20]= "LCD Routine Program.";

unsigned char MSG[11][20] ={"LCD Routine Program." ,
							"This is a TEST......" , 
							"--------------------" ,
							"Msg4................" ,
							"Msg5................" ,
							"Msg6................" ,
							"Msg7................" ,
							"Technological Arts  " ,
							"                    " ,
							"Keyboard Test......." ,
							"Msg11..............."} ;


/*	Memory Allocation for LC Display routine	*/
unsigned char disp_buffer[80];	/*	display buffer (4 lines of 20 chars)	*/
unsigned char *disp_ptr ;         /*	pointer to display buffer	*/
unsigned char disp_flag ;         /*	1 = update; 0 = home; -1 = done	*/
unsigned char drow_var ;       
/*temp            rmb     1*/
unsigned short lcd_state ; 
/*temp_h          rmb     
TEMP1           rmb     1
TEMP2           rmb     1	*/
unsigned short lcd_timer ;
unsigned char dcol_var ;      
unsigned char dig_lenght ;     
unsigned char l_flag ;         
volatile unsigned char spi_int_flag ;   
unsigned short u_delay_var ;



void Disp_init(void);
void Disp_updata(void);
void Disp_menu(void);
void Toggle_lcd_ctrl(char x);
void Toggle_lcd_data(char x);
void Disp_clear(void);
void Dump_spi_data(char x);
void Delay(void);
void Small_delay(void);



void main(void)
	{
	
	COPCTL = 0;
	
	Disp_init();				/*	Initialize LCD display	*/
	
	Toggle_lcd_ctrl(0x02);
	Delay();
	/*Toggle_lcd_data('p');*/
	
	
	Disp_updata() ;
	
	while(1)
		{
		Delay();		
		Disp_menu();
		}	
	
	}
	
	


void Disp_init(void)
	{
	unsigned char x;
	unsigned short i;
	
	DDRP = 0xC0 ;	/*	Initialize Port P	*/
	DDRS = spi_mask2 ;
	PORTS &= 0x7F ;	/*	inititalize port to 0	*/
	
	SP0CR1 = spi_mask1 ;	/*	SPE,MSTR=1, CPOL,SWOM,CPHA=0	*/
	SP0CR2 &= 0xFE ;		/*	SPC0=0, Normal mode	*/
	
	SP0BR = spi_baud3 ;		/*	set clock to 1 Mhz	*/
	
	x = SP0SR ;
	x = SP0DR ;		/* clear flag and buffer	*/
	
	spi_int_flag = 0 ;
	disp_flag = 0 ;
	
	Delay();
	Delay();
	Delay();
	
	Toggle_lcd_ctrl(0x30);	/*	8 data bits, 2 display lines, 0	*/
	
	Small_delay();
	
	Toggle_lcd_ctrl(0x38);	/*	8 data bits, 2 display lines, 0	*/
	
	Small_delay();
	
	Toggle_lcd_ctrl(0x0C);	/*	display on, cursor off, blink off	*/
	
	Small_delay();
	
	Toggle_lcd_ctrl(0x01);	/*	Clear display and return cursor to home	*/
	
	Small_delay();	
	
	Toggle_lcd_ctrl(0x40);
	
	Small_delay();
	
	Toggle_lcd_ctrl(0x80);
	Small_delay();
	
	Disp_clear() ;
	
	}
	
	
	
	
void Disp_clear(void)
	{
	
	unsigned char i ;
	 
	for( i=0 ; i < 80 ; i++)
		{
		
		disp_buffer[i] = BL ;	/*	fill buffer with spaced	*/
		
		}
		
		disp_flag = TRUE ;	/*	set flag for immediate display	*/
		
	}
	
	
void Dump_spi_data(char x)
	{
	
	char y;
	
	y = SP0SR ;
	y = SP0DR ;			/*	clear flag and buffer	*/
	
	SP0DR = x ;
	
	while((SP0SR & 0X80) == 0) ;
	
	y = SP0SR ;
	y = SP0DR ;
	
	}
		
	
	
void Delay(void)
	{
	
	unsigned short x;
	
	for(x=0 ; x < 0xFFFF; x++);
	
	}
	
void Small_delay(void)
	{
	
	unsigned short x ;
	for(x=0 ; x < 0x10; x++);
	
	}


void Toggle_lcd_ctrl(char x)
	{
	
	char i ;
	
	Dump_spi_data(x) ;
	
	PORTS |= 0x80 ; /*	DRIVE SELECT OF 74HC595 HI	*/
	
	for(i=0 ; i < 4 ; i++);
	
	PORTS &= 0x7F ;	/*	DRIVE SELECT OF 74HC595 LO	*/

	
	PORTP &= 0xBF ;
	
	for(i=0 ; i < 4 ; i++);
	
	PORTP |= 0x80 ;	/*	Pulse lcd enable	*/
	
	for(i=0 ; i < 4 ; i++);	
	
	PORTP &= 0x7F ;
	
	}
	

void Toggle_lcd_data(char x)
	{
	
	char i ;
	
	Dump_spi_data(x) ;
	
	PORTS |= 0x80 ; /*	DRIVE SELECT OF 74HC595 HI	*/
	
	for(i=0 ; i < 4 ; i++);
	
	PORTS &= 0x7F ;	/*	DRIVE SELECT OF 74HC595 LO	*/

	
	PORTP |= 0x40 ;
	
	for(i=0 ; i < 4 ; i++);
	
	PORTP |= 0x80 ;	/*	Pulse lcd enable	*/
	
	for(i=0 ; i < 4 ; i++);	
	
	PORTP &= 0x7F ;
	
	}
	

/*	update display
	This routine updates the LCD display from the display image in
	memory whenever the update flag is set.
*/
void Disp_updata(void)
	{
	
	unsigned i ;
	
	if(disp_flag)
		{
		
		Toggle_lcd_ctrl(0x02) ;	/*	home cursor	*/
		
		Delay();
		
		for(i=0 ; i < 20 ; i++)
			{
			Toggle_lcd_data(disp_buffer[i]) ;
			Small_delay();
			}
		for(i=0 ; i < 20 ; i++)
			{
			Toggle_lcd_data(disp_buffer[40+i]) ;
			Small_delay();
			}
		
		for(i=0 ; i < 20 ; i++)
			{
			Toggle_lcd_data(disp_buffer[20+i]) ;
			Small_delay();
			}
		
		for(i=0 ; i < 20 ; i++)
			{
			Toggle_lcd_data(disp_buffer[60+i]) ;
			Small_delay();
			}
				
				
		Toggle_lcd_ctrl(0x0C);	/*	display on, cursor off, blink off	*/
						
		}
		
		disp_flag = FALSE ;
		Toggle_lcd_ctrl(0x02) ;	/*	home cursor	*/
	
	}	
		
		


/*	show the menu	*/


void Disp_menu(void)
	{
	
	unsigned char i, j, x, y  ;
	
	
	for(x=0; x < 5 ; x++) 
		{
		
		for(i=0; i < 4 ; i++)
			{
		
			for(j=0; j < 20 ; j++)
				{
			
				disp_buffer[(i*20) + j] = MSG[i+x][j] ;
			
				}
			}
			
		disp_flag = TRUE ;
		Disp_updata();
		for(y=0; y<10; y++){Delay();}
		}
		
	}

/*
void Disp_menu(void)
	{
	
	unsigned char i, j, x=0  ;
	
	
	for(x=0; x < 5 ; x++) 
	
		
		for(i=x; i < x+4 ; i++)
			{
		
			for(j=0; j < 20 ; j++)
				{
			
				disp_buffer[j] = ok[j] ;
			
				}
			
			
		disp_flag = TRUE ;
		Disp_updata();
		for(i=0; i< 10; i++){Delay();}
	
		
	}

*/

	
void SPIHandler(void)
	{
	
	char x ;
	spi_int_flag = 0x01 ;
	x = SP0SR ;
	x = SP0DR ;
	
	asm("rti") ;
	
	}


/* If you need to set up interrupt vectors (e.g. single chip mode system
 * or system without monitor, then you can simply include vectors.c. The
 * "right" way to do things is to set up a project with mulitple files,
 * but to just try out the compiler, this works just as well.
 */
#ifdef _HC16
#include "vectrs16.c"
#else
#include "vectors.c"
#endif
/* note that since vectors.c uses pragma to change the text section name
 * there should not be stuff after this unless you change the name
 * back
 */


