*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*March 16, 2000         1.00            PCF8593 RTC and SPI EEPROM
*Author: Exequiel Rarama
*******************************************************************************
;
; ----------------------------
; ADAPT-912MX1
; ----------------------------
;REGS912A.INC is an external file containing the 68HC912 register definitions
;
#include REGS912A.INC

*  Operational Parameters

_100MS          equ     25
_250MS          equ     61
_500MS          equ     125
_1SECOND        equ     250
_2SECONDS       equ     500
_3SECONDS       equ     750
_5SECONDS       equ     1250
_10SECONDS      equ     2500
_25SECONDS      equ     6250



RAM     equ     $0800           ;68HC912B32 internal RAM
STACK   equ     $0bff           ;Stack at top of internal ram

* Operational Constants

true            equ     $ff
false           equ     $00
CR              equ     $D
LF              equ     $A
SPACE           equ     $20

* Masks

;SCI Variables
scimask         equ     %00101100 ;RIE - SCI Interrupt enable
                                  ;RE - Receiver Enable
RDRFflag        equ     %00100000 ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000 ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
;MCLK=8MHz
BAUD110         equ     4545    ;(baud) 110 baud with 16 Mhz crystal
BAUD300         equ     1667    ;(baud) 300 baud with 16 Mhz crystal
BAUD600         equ     833     ;(baud) 600 baud with 16 Mhz crystal
BAUD1200        equ     417     ;(baud) 1200 baud with 16 Mhz crystal
BAUD2400        equ     208     ;(baud) 2400 baud with 16 Mhz crystal
BAUD4800        equ     104     ;(baud) 4800 baud with 16 Mhz crystal
BAUD9600        equ     52      ;(baud) 9600 baud with 16 Mhz crystal
BAUD14400       equ     35      ;(baud) 14400 baud with 16 Mhz crystal
BAUD19200       equ     26      ;(baud) 19200 baud with 16 Mhz crystal
BAUD38400       equ     13      ;(baud) 38400 baud with 16 Mhz crystal

*-----------------------------------------------------------------------------
;Spi initialization variables
spi_mask1       equ     %01010000       ;SPE,MSTR=1, SWOM,CPOL,CPHA=0
spi_mask2       equ     %11100000       ;Bit 7,6,5=1 the rest=0
spi_mask3       equ     %01010100       ;SPE,MSTR=1, SWOM,CPOL=0, CPHA=1

spi_baud1       equ     %00000000       ;4.0 Mhz
spi_baud2       equ     %00000001       ;2.0 Mhz
spi_baud3       equ     %00000010       ;1.0 Mhz
spi_baud4       equ     %00000011       ;0.5 Mhz
spi_baud5       equ     %00000100       ;250 kHz
spi_baud6       equ     %00000101       ;125 kHz
spi_baud7       equ     %00000110       ;62.5 kHz
spi_baud8       equ     %00000111       ;31.3 kHz
SPIF            equ     %10000000       ;flag after the 8th clock
SPIE            equ     %10000000       ;Spi interrupt enable    
LSBF            equ     %00000001       ;SPI LSB First enable

slave_select    equ     $10     ;spi slave select

;Delay
us8             equ     16              ;2 microsecond delay
us1             equ     8               ;1 microsecond delay
TEN             equ     $80
*-----------------------------------------------------------------------------
        org     RAM

* System Variables


TEMP1                   ds      1
TEMP2                   ds      1

H                       ds      1       ;used in binary to decimal conversion
TO                      ds      1

;-------------
;RTC Variables
;-------------
spi_read                ds      1
spi_write               ds      1

rtc_reg_address         ds      1
read_write_flag         ds      1               ;if bit 0 is 0 then write else read
ack_flag                ds      1               ;acknowledged flag

time_flag               ds      1
date_flag               ds      1

time_temp
time_seconds_hundred    ds      1
time_seconds            ds      1
time_minutes            ds      1
time_hours              ds      1
time_days               ds      1
time_months             ds      1
leap_var                ds      1
DBUFR                   ds      5

result                  ds      4
operand                 ds      2

u_delay_var             ds      2
spi_int_flag            ds      1

;spi eeprom variables
eeprom_data             ds      1               ;spi eeprom data buffer
eeprom_address          ds      2               ;spi eeprom address
sci_flag                ds      1               ;Valid sci value
char_counter            ds      1
ee_rd_wr_flag           ds      1

;routine address
states                  ds      2
        org     $1000

time_years              ds      2       ;the year is saved in battery-backed RAM
leap_year               ds      1

***************************** Program *******************************

        org     $2000
RESET
        sei

Init:                           ;This is where the RESET vector points to
;Initialize Stack
        lds     #STACK          ;initialize stack pointer

;Initialize COP
        clr     COPCTL                  ;turn COP off

;Initialize Serial Communication Interface
        movb    #$0c,SC0CR2             ;enable SCI 0 rx & tx
        movb    #0,SC0CR1               ;  for polled operation
        movw    #BAUD9600,SC0BDH       ;Set baud rate
        clr     sci_flag                ;Initialize flag

        jsr     RTC_INIT        ;initialize the real-time clock/calendar chip
        jsr     ShowMenu        ;display menu in terminal window

        cli
        jsr     init_spi
        jsr     go_power        ;Initialize states

;-----------------------------------------------------------------------------
;Main loop - all routine are process here
;
main
        ldaa    ee_rd_wr_flag
        bne     main10
        jsr     ProcessCommand  ;check for user command

main10
        ldx     states          ;process states
        jsr     0,x

        bra     main
;-----------------------------------------------------------------------------

go_power
        ldx     #wait_here
        stx     states
        rts

wait_here
        brclr   ee_rd_wr_flag,%01,wait_here10
        ldx     #go_read
        stx     states
        movb    #4,char_counter         ;initialize counter
        movw    #0,eeprom_address       ;Initialize address
        bra     wait_here20

wait_here10
        brclr   ee_rd_wr_flag,%10,wait_here20
        ldx     #go_write
        stx     states
        movb    #6,char_counter ;initialize counter
        movw    #0,eeprom_address       ;Initialize address
        clr     eeprom_data

wait_here20
        rts

***********************************************************************
*Procedure Definitions:
***********************************************************************

ShowMenu:
        jsr     PutDblLine
        ldx     #M_HEADER1
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_TIME
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_DATE
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_READ
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_WRITE
        jsr     SendString
        jsr     PutNewLine
        ldx     #M_PROMPT
        jsr     SendString
        rts


ProcessCommand:
        jsr     GetChar

        ldab    sci_flag        ;check for character
        beq     PCX
        clr     sci_flag        ;check for character        

        jsr     SendByte        ;echo the character
        oraa    #$20            ;convert to lower case, if required

        cmpa    #'t'            ;read/set time
        lbeq     PCT

        cmpa    #'d'            ;read/set date
        lbeq     PCD

        cmpa    #'r'            ;Read spi
        lbeq     PCR

        cmpa    #'w'            ;Write spi
        lbeq     PCW

        jsr     ShowMenu        ;display menu in terminal window
        bra     PCX             ;  and exit

PCT:
        jsr     PutNewLine
        jsr     GET_TIME
        bra     PCX

PCD:
        jsr     PutNewLine
        jsr     GET_DATE
        bra     PCX

PCR:
;        jsr     PutNewLine
        movb    #%01,ee_rd_wr_flag
        bra     PCX

PCW:
;        jsr     PutNewLine
        movb    #%10,ee_rd_wr_flag
        bra     PCX

PCX
        rts


HexByte2Dec

                        ;Supply hex value to be converted in B register
        clra            ;numerator in D, denominator in X
        ldx     #100    ;remainder in D, quotient in X
        idiv            ;B is lo-order byte
        xgdx
        stab    H       ;8 bit quotient in B
        xgdx
        ldx     #10     ;H=0X  TO=packed BCD
        idiv
        stab    TO
        xgdx
        aslb
        aslb
        aslb
        aslb
        orab    TO
        stab    TO
        rts


GetChar:

*  Fetches one character from SCI0,
*  and returns it in register A.

GC1:
        ldaa    SC0SR1          ;get sci flags
        anda    #RDRFflag       ;mask off irrelevant bits
        beq     GC2             ;loop until character found
        ldaa    SC0DRL          ;get character

        movb    #1,sci_flag
        bra     GC3

GC2
        clr     sci_flag

GC3
        rts


get_time_char
        ldaa    SC0SR1          ;get sci flags
        anda    #RDRFflag       ;mask off irrelevant bits
        beq     get_time_char   ;loop until character found
        ldaa    SC0DRL          ;get character
        rts

GetByte:

*  Converts 2 hex characters to a single byte value,
*  and returns it in register A.

GB1:
        jsr     GetChar
        jsr     Hex2Bin
        lsla
        lsla
        lsla
        lsla
        staa    TEMP1
        jsr     GetChar
        jsr     Hex2Bin
        oraa    TEMP1
        rts


Hex2Bin:

*  Converts an ASCII hex character in register A
*  to a binary nibble and returns it in register A.

        cmpa    #'9
        bls     HEX
        adda    #9
HEX:    anda    #$f
        rts

GetAddress:

* Extracts load address and returns it in register Y.

        pshb                    ;preserve byte count
        jsr     GetByte
        staa    TEMP2
        jsr     GetByte
        tab
        ldaa    TEMP2
        xgdy
        pulb
        rts


SendDecByte

* value is in B

        clra
        jsr     HexByte2Dec
        ldaa    H
        adda    #'0'
        jsr     SendByte
        ldaa    TO
        jsr     SendASCIIHex
        rts

SendASCIIHex
*       value in A

        psha
        anda    #$F0
        lsra
        lsra
        lsra
        lsra
        cmpa    #$A
        blt     SAH1
        suba    #$A
        adda    #'A'
        bra     SAH2
SAH1
        adda    #'0'
SAH2
        jsr     SendByte
        pula
        psha
        anda    #$0F
        cmpa    #$A
        blt     SAH3
        suba    #$A
        adda    #'A'
        bra     SAH4
SAH3
        adda    #'0'
SAH4
        jsr     SendByte
        pula
        rts


SendByte:

*  Transmits a byte, contained in register A, to the serial device via the SCI.

SB1
        ldab    SC0SR1  ;wait for transmit data register empty (TDRE)
        bpl     SB1
        staa    SC0DRL  ;send byte
        rts

PutNewLine
        ldaa    #CR
        jsr     SendByte
        ldaa    #LF
        jsr     SendByte
        rts

PutDblLine
        ldaa    #CR
        jsr     SendByte
        ldaa    #LF
        jsr     SendByte
        ldaa    #LF
        jsr     SendByte
        rts

SendString:
*       x contains starting address of string
RV1
        ldaa    0,X             ;$FF denotes end of string
        cmpa    #$ff
        beq     RVX
        jsr     SendByte
        inx
        bra     RV1
RVX
        rts

*******************************************************************************
* Messages

*******************************************************************************
* Messages
M_TIME          fcc     'T => Set Time (hh:mm:ss) [24-hour format]'
                fcb     $ff
M_DATE          fcc     'D => Set Date (yyyy/mm/dd)'
                fcb     $ff
M_READ          fcc     'R => Read spi EEPROM (Any address in hex)'
                fcb     CR,LF
                fcc     'eg. RXXXX where XXXX=address'
                fcb     $ff
M_WRITE         fcc     'W => Write to spi EEPROM (Any address in hex)'
                fcb     CR,LF
                fcc     'eg. WXXXXYY where XXXX=address, YY=data'
                fcb     $ff
M_PROMPT        fcc     '?'
                fcb     $ff
M_HEADER1       fcc     ' ADAPT912 MX1 SPI EEPROM/RTC UTILITY VERSION 1.00'
                fcb     $ff
M_CURRENT_TIME  fcc     'Current Time: '
                fcb     $ff
M_NEW_TIME      fcc     'New Time: '
                fcb     $ff
M_CURRENT_DATE  fcc     'Current Date: '
                fcb     $ff
M_NEW_DATE      fcc     'New Date: '
                fcb     $ff
M_NOT           fcc     'Not implemented'
                fcb     $ff
;
;-----------------------------------------------------------------------------
;The "include" sub-routines are external, and are linked during assembly.

#include RTC.ASM
#include spi_ee.ASM

        org    $FFD8
        FDB     spi_int         ;SPI SERIAL TRANSFER COMPLETE
